EXTPROC CEnvi2
/********************************************************************
 *** KbdRate.cmd - CEnvi2 sample file which will, on most systems, ***
 *** ver.1         set the keyboard typematic values.             ***
 ********************************************************************/

#define MIN_DELAY    1
#define MAX_DELAY    5000
#define MIN_RATE     1
#define MAX_RATE     5000

main(argc,argv)
{
   if ( argc != 3 )
      Instructions()
   else {
      // check input values for valid ranges
      delay = atoi(argv[1]);
      rate = atoi(argv[2]);
      if ( delay < MIN_DELAY  ||  MAX_DELAY < delay
        || rate < MIN_RATE  ||  MAX_RATE < rate ) {
         printf("\aInvalid input value; enter /? for instructions\n");
      } else {
         SetDelayAndRate(delay,rate);
      }
   }
}

SetDelayAndRate(delay,rate)  // DynamicLink to Dos Calls to set rate and delay
{
   // Open $Kbd device
   #define ORD_DOS32OPEN   273
   rc = DynamicLink("doscalls",ORD_DOS32OPEN,BIT32,CDECL,
                    "\\DEV\\KBD$",FileHandle,ActionTaken,0,
                    0,0x01,0x40,0);
   assert( 0 == rc );

   // call DosDevIOCTL to set kbd delay and rate
   #define ORD_DOS32DEVIOCTL     284
   #define KEYBOARD_CATEGORY     4
   #define KBD_SETTYPAMATICRATE  0x0054
   BLObPut(Parms,delay,UWORD16);
   BLObPut(Parms,rate,UWORD16);
   // rc = DosDevIOCtl(DevHandle, ulCategory,
   //      ulFunction, pParmList,
   //      ulParmLengthMax,
   //      pParmLengthInOut, pDataArea,
   //      ulDataLengthMax, pDataLengthInOut);
   DynamicLink("doscalls",ORD_DOS32DEVIOCTL,BIT32,CDECL,
               FileHandle,KEYBOARD_CATEGORY,KBD_SETTYPAMATICRATE,
               Parms,BLObSize(Parms),NULL,NULL,0,NULL);

   // close device
   #define ORD_DOS32CLOSE  257
   DynamicLink("doscalls",ORD_DOS32CLOSE,BIT32,CDECL,FileHandle);
}




Instructions()
{
   printf("\n")
   printf("KbdRate - Set keyboard typematic rates.  This works with most BIOS's\n")
   printf("\n")
   printf("USAGE: KbdRate Delay Rate\n")
   printf("\n")
   printf("Where: Delay - Delay in milliseconds before repeat; min = %d, max = %d\n",MIN_DELAY,MAX_DELAY);
   printf("       Rate  - Repetitions of key per second; min = %d, max = %d\n",MIN_RATE,MAX_RATE);
   printf("\n")
}

