@echo OFF
REM **********************************************************
REM *** Sessions.cmd - Show lots of examples for using the ***
REM *** ver.3          SESSION.CMD utility.                ***
REM **********************************************************

cls
ECHO This is an example of many of the ways you can use the
ECHO Session.cmd. Utility.
ECHO 
ECHO This First example is a standard OS/2 windowed session.
pause
ECHO Session /Title "Plain OS/2 Window" /WIN /F
CALL Session /Title "Plain OS/2 Window" /WIN /F
pause
CALL KILL "Plain OS/2 Window" > NUL

cls
ECHO Now create a standard DOS window
pause
ECHO Session /Title "Plain DOS Window" /WIN /DOS /F
CALL Session /Title "Plain DOS Window" /WIN /DOS /F
pause
CALL KILL "Plain DOS Window" > NUL

cls
ECHO For these windowed DOS and OS/2 sessions, you can also specify window
ECHO position and font sizes.  In this examples, many DOS and OS/2 windows
ECHO will be created in the foreground, at different locations and with
ECHO different font sizes
pause
ECHO Session /Title "OS/2 8x8 @ 0,t0" /WIN /F /FONT 8x8 /POS 0,t0
CALL Session /Title "OS/2 8x8 @ 0,t0" /WIN /F /FONT 8x8 /POS 0,t0
ECHO Session /Title "DOS 10x6 @ 15,t15" /DOS /WIN /F /FONT 10x6 /POS 15,t15
CALL Session /Title "DOS 10x6 @ 15,t15" /DOS /WIN /F /FONT 10x6 /POS 15,t15
ECHO Session /Title "OS/2 10x8 @ 30,t30" /WIN /F /FONT 10x8 /POS 30,t30
CALL Session /Title "OS/2 10x8 @ 30,t30" /WIN /F /FONT 10x8 /POS 30,t30
ECHO Session /Title "DOS 12x8 @ 45,t45" /DOS /WIN /F /FONT 12x8 /POS 45,t45
CALL Session /Title "DOS 12x8 @ 45,t45" /DOS /WIN /F /FONT 12x8 /POS 45,t45
ECHO Session /Title "OS/2 14x6 @ 60,t60" /WIN /F /FONT 14x6 /POS 60,t60
CALL Session /Title "OS/2 14x6 @ 60,t60" /WIN /F /FONT 14x6 /POS 60,t60
ECHO Session /Title "DOS 14x8 @ 75,t75" /DOS /WIN /F /FONT 14x8 /POS 75,t75
CALL Session /Title "DOS 14x8 @ 75,t75" /DOS /WIN /F /FONT 14x8 /POS 75,t75
ECHO Session /Title "OS/2 16x8 @ 90,t90" /WIN /F /FONT 16x8 /POS 90,t90
CALL Session /Title "OS/2 16x8 @ 90,t90" /WIN /F /FONT 16x8 /POS 90,t90
ECHO Session /Title "DOS 18x8 @ 105,t105" /DOS /WIN /F /FONT 18x8 /POS 105,t105
CALL Session /Title "DOS 18x8 @ 105,t105" /DOS /WIN /F /FONT 18x8 /POS 105,t105
pause
CALL KILL "OS/2 8x8 @ 0,t0" > NUL
CALL KILL "DOS 10x6 @ 15,t15" > NUL
CALL KILL "OS/2 10x8 @ 30,t30" > NUL
CALL KILL "DOS 12x8 @ 45,t45" > NUL
CALL KILL "OS/2 14x6 @ 60,t60" > NUL
CALL KILL "DOS 14x8 @ 75,t75" > NUL
CALL KILL "OS/2 16x8 @ 90,t90" > NUL
CALL KILL "DOS 18x8 @ 105,t105" > NUL

cls
ECHO You can also start PM sessions, with size and positions
pause
ECHO Session /Title "Maximum OS/2 Editor" /PM /MAX /B E.EXE Register.doc
CALL Session /Title "Maximum OS/2 Editor" /PM /MAX /B E.EXE Register.doc
ECHO Session /Title "Minimum OS/2 Editor" /PM /MIN /B E.EXE Register.doc
CALL Session /Title "Minimum OS/2 Editor" /PM /MIN /B E.EXE Register.doc
ECHO Session /Title "Positioned OS/2 Editor" /PM /POS 50,150 /B E.EXE Register.doc
CALL Session /Title "Positioned OS/2 Editor" /PM /POS 50,150 /B E.EXE Register.doc
ECHO Session /Title "Sized OS/2 Editor" /PM /SIZE 300,200 /B E.EXE Register.doc
CALL Session /Title "Sized OS/2 Editor" /PM /SIZE 300,200 /B E.EXE Register.doc
pause
CALL KILL "Maximum OS/2 Editor" > NUL
CALL KILL "Minimum OS/2 Editor" > NUL
CALL KILL "Sized OS/2 Editor" > NUL
CALL KILL "Positioned OS/2 Editor" > NUL

cls
ECHO You can also set any of the "DOS Settings..." variables.
ECHO In these examples some will be set directly, and others will be
ECHO set through an environment variable.  Here a few DOS sessions
ECHO will be started with different memory settings.
pause
ECHO 
ECHO Session /Title "480K DOS Session" /SET DOS_RMSIZE=480 /DOS /WIN /FONT 8x8 /F /POS 0,0 command.com "/K mem.exe"
CALL Session /Title "480K DOS Session" /SET DOS_RMSIZE=480 /DOS /WIN /FONT 8x8 /F /POS 0,0 command.com "/K mem.exe"
ECHO 
ECHO Session /Title "560K DOS Session, No EMS" /SET DOS_RMSIZE=560 /SET EMS_MEMORY_LIMIT=0 /DOS /WIN /FONT 8x8 /F /POS 40,40 command.com "/K mem.exe"
CALL Session /Title "560K DOS Session, No EMS" /SET DOS_RMSIZE=560 /SET EMS_MEMORY_LIMIT=0 /DOS /WIN /FONT 8x8 /F /POS 40,40 command.com "/K mem.exe"
ECHO 
ECHO SET MY_DOS_SETTINGS=DOS_RMSIZE,280;EMS_MEMORY_LIMIT,8192
SET MY_DOS_SETTINGS=DOS_RMSIZE,280;EMS_MEMORY_LIMIT,8192
ECHO Session /Title "280K DOS Session, 8K EMS" /SET #MY_DOS_SETTINGS /DOS /WIN /FONT 8x8 /F /POS 80,80 command.com "/K mem.exe"
CALL Session /Title "280K DOS Session, 8K EMS" /SET #MY_DOS_SETTINGS /DOS /WIN /FONT 8x8 /F /POS 80,80 command.com "/K mem.exe"
ECHO 
pause
CALL KILL "280K DOS Session, 8K EMS" > NUL
CALL KILL "560K DOS Session, No EMS" > NUL
CALL KILL "480K DOS Session" > NUL
SET MY_DOS_SETTINGS=

cls
ECHO Here's two Windows programs: NotePad and File Manager.  NotePad will be
ECHO started in standard mode, and File Manager will run in Enhanced mode.
ECHO Note that SESSION.CMD does not set the title of a Windows session, and
ECHO so the title specified must be the title that Windows gives to that session.
pause
ECHO 
ECHO Session /W /SEP /POS 0,0 /SIZE 300,400 NotePad
CALL Session /W /SEP /POS 0,0 /SIZE 300,400 NotePad
ECHO 
ECHO Session /W /ENH /SEP /POS 50,60 /SIZE 300,400 /Title "File Manager" WinFile
CALL Session /W /ENH /SEP /POS 50,60 /SIZE 300,400 /Title "File Manager" WinFile
ECHO 
pause
CALL KILL "File Manager" > NUL
CALL KILL NotePad > NUL
