EXTPROC CEnvi2
/***************************************************************
 *** Switch - Switch to the specified window/task.  Make any ***
 *** ver.1    slow match on the window name.                 ***
 ***************************************************************/

#include <PMdll.lib>

main(argc,argv)
{
   if ( 2 != argc  ||  !strcmp(argv[1],"/?")  ||  !stricmp(argv[1],"/help") )
      Instructions();
   else
      // create for input folder or for current dir if no input folder
      SwitchToName(argv[1]);
}

SwitchToName(Name)
   // this will create a list of all windows that can be switched to, and try
   // to match any portion of Name with the window title
{
   // create list of switchable windows
   SwitchList = WinQuerySwitchList(Info().hab);
   assert( SwitchList != NULL );
   SwitchCount = 1 + GetArraySpan(SwitchList);
   // check each of those windows for title match to Name, and if so then switch
   for ( ExactMatch = 0; ExactMatch < SwitchCount; ExactMatch++ ) {
      if ( 0 == WinQuerySwitchEntry(SwitchList[ExactMatch],SwEntry) ) {
         if ( !stricmp(Name,SwEntry.title) )
            break;
         // that wasn't exact, so find partial if not one alread
         if ( !defined(Partial)  &&  FindNameInTitle(Name,SwEntry.title) )
            PartialMatch = ExactMatch;
      }
   }
   if ( ExactMatch < SwitchCount )
      WinSwitchToProgram(SwitchList[ExactMatch]);
   else if ( defined(PartialMatch) )
      WinSwitchToProgram(SwitchList[PartialMatch]);
   else
      printf("No window task found to match \"%s\"\n",Name);
}

FindNameInTitle(name,title) // if name found anywhere in title, then TRUE, else FALSE
{
   nameLen = strlen(name);
   while( 0 != title[0] ) {
      if ( !strnicmp(name,title++,nameLen) )
         return TRUE;
   }
   return(FALSE);
}

Instructions()
{
   printf("\n")
   printf("Switch - Switch to specified task by Title name.  If an exact match\n")
   printf("         is not found then tries for a partial match.\n");
   printf("\n")
   printf("SYNTAX: Switch TitleSpec\n")
   printf("\n")
   printf("Where:  TitleSpec - Full or partial title\n")
   printf("\n")
   printf("Examples: Switch Desktop    - Switch focus to the OS/2 desktop\n")
   printf("          Switch E.EXE      - Switch to running e.exe, if there is one\n")
   printf("\n")
}

