EXTPROC CEnvi2
//***********************************************************************
//*** TextEcho.cmd - Demonstration of TextBoss.lib.  This starts      ***
//*** ver.1          a DOS or OS/2 window and echos everything on it. ***
//***********************************************************************

#include <PMdll.lib>
#include <WinTools.lib>
#include <ClipBrd.lib>
#include <FileIO.lib>
#include <NamePipe.lib>
#include <TextBoss.lib>

// Find out if want to echo DOS or OS/2
printf("Echo DOS window, OS/2 window, or Full-Screen OS/2?  (D | O | F) :");
do {
   SessionType = toupper(getch());
} while ( SessionType != 'D'  &&  SessionType != 'O'  && SessionType != 'F' );
printf("%c\n",SessionType);

switch ( SessionType ) {
   case 'D':
      SessionName = "DOS Echo Source";
      StartParms = "/WIN /DOS /B command.com /C mode 80,25";
      break;
   case 'O':
      SessionName = "OS/2 Echo Source";
      StartParms = "/WIN /B cmd.exe /C mode 80,25";
      break;
   case 'F':
      SessionName = "Full-Screen OS/2 Echo Source";
      StartParms = "/FS /B /N CEnvi2.exe FSSlave.cmm MySlave CMD.EXE /K mode 80,25";
      break;
}

// Start a session in the background
system("mode 80,26");
system("start \"%s\" %s",SessionName,StartParms);
suspend(3000);

printf("\nTextEcho has started a windowed session named \"%s\"\n",SessionName);
printf("TextEcho will now attempt to control that session so that what you\n");
printf("type HERE will be typed THERE, and what is displayed THERE will be\n");
printf("displayed HERE.  The effect should be of a VERY SLOW WINDOW.  For\n");
printf("this illusion to work, this OS/2 has been set to 26 lines, and that\n");
printf("session is at 25 lines.  This will work best if that session is visible\n");
printf("and this OS/2 session remains in the foreground.\n");
printf("\n");
printf("When \"%s\" is visible, press any key...",SessionName);
getch();
printf("\n");

WindowHandle = GetWindowHandle(SessionName);
if ( NULL == WindowHandle ) {
   printf("Could not locate session named \"%s\"\n",SessionName);
   abort();
}

if ( SessionType == 'D' )
   PasteToTextWindow(WindowHandle,"ServeOS2 DOS_ECHO\r");

// initialize data to compare when it has changed
PreviousData = "";
PreviousLen = 0;

while ( IsWindow(WindowHandle) ) {

   // If keys are available, then send them to the window
   if ( kbhit() ) {
      KeysLen = 0;
      do {
         if ( 0 == (Keys[KeysLen] = byte(getch())) ) {
            // extended key, so send any existing ascii string, then
            // send just this extended key
            if ( KeysLen ) {
               Keys[KeysLen] = '\0';
               if ( SessionType == 'D' )
                  SendDosKey("DOS_ECHO",Keys);
               else if ( SessionType == 'O' )
                  SendOS2Key(WindowHandle,Keys);
               else
                  SendFullOS2Key("MySlave",Keys);
            }
            if ( SessionType == 'D' )
               SendDosKey("DOS_ECHO",getch() << 8);
            else if ( SessionType == 'O' )
               SendOS2Key(WindowHandle,getch() << 8);
            else
               SendFullOS2Key("MySlave",getch() << 8);
            KeysLen = 0;
         } else {
            KeysLen++;
         }
      } while( kbhit() );
      if ( KeysLen ) {
         Keys[KeysLen] = '\0';
         if ( SessionType == 'D' )
            SendDosKey("DOS_ECHO",Keys);
         else if ( SessionType == 'O' )
            SendOS2Key(WindowHandle,Keys);
         else
            SendFullOS2Key("MySlave",Keys);
      }
   }

   // Read the text in the window, if it has changed
   if ( SessionType == 'F' ) {
      if ( Data = ReadFullOS2Text("MySlave",lColCount,lRowCount,8000) ) {
         DataLen = lColCount * lRowCount;
      }
   } else {
      Data = ReadTextWindow(WindowHandle,DataLen);
   }
   if ( NULL != Data
     && ( PreviousLen != DataLen || memcmp(Data,PreviousData,DataLen) ) ) {
      if ( SessionType == 'F' ) {
         ScreenCursor(0,0);
         printf("%s",Data);
      } else {
         Lines = CopyTextBufferToLines(Data,LineCount);
         for ( row = 0; row < 25; row++ ) {
            ScreenCursor(0,row);
            printf("%-80.80s",Lines[row]);
         }
      }
      PreviousLen = DataLen;
      PreviousData = Data;
   }

   suspend(250);

}
