EXTPROC CEnvi2
//****************************************************************
//*** TextWin.cmd - Get text from, or put text into a windowed ***
//*** ver.5         OS/2 or DOS session by session name.       ***
//****************************************************************

Instructions()
{
   puts("\a")
   puts(`TextWin - GET/PUT text from/into a DOS or OS/2 session`)
   puts(``)
   puts(`SYNTAX: TextWin [OPTIONS} <Name> [Text]`)
   puts(``)
   puts(`WHERE: Name - Partial matching title of windowed session. If using FSSlave or`)
   puts(`              DOSSlave options then this is the name for those slaves`)
   puts(`       Text - Text to send to window, if not supplied then will get`)
   puts(`              text from window and display.  End in \r to send`)
   puts(`              carriage-return`)
   puts(`OPTIONS: /DOSSlave - Send keys to DOS session running SERVEOS2.COM;`)
   puts(`                     Note: cannot read text from SERVEOS2.COM method`)
   puts(`         /FSSlave - Send keys to full-screen OS/2 session running FSSlave.cmm`)
   puts(``)
   puts(`Examples: TextWin "DOS Window"`)
   puts(`          TextWin "OS/2 Win" "Hello"`)
   puts(`          TextWin "OS/2 Win" "Dir c:\*.*\r"`)
   puts(`          TextWin /FSSlave NOTES QUIT\r`)
   puts(``)
}

#include <TextBoss.lib>
#include <OptParms.lib>

main(argc,argv)
{
   FSSlave = OptionalParameter(argc,argv,"FSSlave");
   DOSSlave = OptionalParameter(argc,argv,"DOSSlave");
   SessionTitle = argv[1];
   if ( argc == 2 ) {
      if ( FSSlave )
         FullOS2TextGet(SessionTitle);
      else if ( DOSSlave )
         DOSSlaveTextGet(SessionTitle);
      else
         WinTextGet(SessionTitle);
   } else if ( argc == 3 ) {
      Text = argv[2];
      // if text ends in carriage return '\r' then add a real carriage return
      if ( !stricmp("\\r",Text + strlen(Text) - 2) )
         strcpy(Text + strlen(Text) - 2,"\r");
      if ( FSSlave )
         FullOS2TextPut(SessionTitle,Text);
      else if ( DOSSlave )
         DOSSlaveTextPut(SessionTitle,Text);
      else
         WinTextPut(SessionTitle,Text);
   } else
      Instructions();
}

WinTextGet(SessionTitle)
{
   if ( !(Data = ReadTextWindow(SessionTitle)) )
      printf("\aCould not read data from session \"%s\"\n",SessionTitle);
   else {
      DataLines = CopyTextBufferToLines(Data,LineCount);
      for ( i = 0; i < LineCount; i++ )
         printf("\n%s",DataLines[i]);
   }
}

WinTextPut(SessionTitle,Text)
{
   if ( !GetWindowHandle(SessionTitle) )
      printf("\aCould not find session \"%s\"\n",SessionTitle);
   else {
      // send this text to the window
      PasteToTextWindow(SessionTitle,Text);
   }
}

FullOS2TextGet(QueueName)
{
   if ( !(Data = ReadFullOS2Text(QueueName,Col,Row,10000)) )
      printf("\aCould not find FSSlave \"%s\"\n",QueueName);
   else
      puts(Data);
}

FullOS2TextPut(QueueName,Text)
{
   if ( !SendFullOS2Key(QueueName,Text) )
      printf("\aError sending to full-screen FSSlave \"%s\"\n",QueueName);
}

DosSlaveTextGet(SlaveName)
{
   printf("\aCannot read DOS screen via SERVEOS2.COM.\n");
}

DosSlaveTextPut(SlaveName,Text)
{
   if ( !SendDOSKey(SlaveName,Text) )
      printf("\aError sending to DOS ServeOS2 \"%s\"\n",SlaveName);
}


