EXTPROC CEnvi2
/************************************************************
 *** WinHide.cmd - CEnvi program to hide a window by name ***
 ************************************************************/

#include <PMdll.lib>

#define  NO_ERROR          0     // return code from most successful DosCalls

HideWindow(WindowHandle)
{
   #define ORD_WIN32SETWINDOWPOS 875
   #define SWP_HIDE              0x0010
   DynamicLink("PMWIN",ORD_WIN32SETWINDOWPOS,BIT32,CDECL,
               WindowHandle,0,
               0,0,0,0,
               SWP_HIDE);
}


main(argc,argv)
{
   if ( argc != 2  ||  !strcmp(argv[1],"/?")  ||  !strcmpi(argv[1],"help") ) {
      Instructions();
   } else {
      // build list of all window titles
      SwitchList = WinQuerySwitchList(Info().hab);
      assert( SwitchList != NULL );
      SwitchCount = 1 + GetArraySpan(SwitchList);
      for ( i = 0; i < SwitchCount; i++ ) {
         if ( 0 == WinQuerySwitchEntry(SwitchList[i],SwEntry) ) {
            if ( !stricmp(argv[1],SwEntry.title) ) {
               HideWindow(SwEntry.hwnd);
            }
         }
      }
   }
}

Instructions()
{
   printf("\n")
   printf("WinHide - Hide a Window by window title\n")
   printf("\n")
   printf("SYNTAX: WinHide WindowTitle\n")
   printf("\n")
   printf("Where:  WindowTitle - Full Window Title\n")
   printf("\n")
}

