EXTPROC CEnvi2
/******************************************************************
 *** WinList - CEnvi2 program to display all windows that may be ***
 *** ver.1     switched to.                                     ***
 ******************************************************************/

#include <PMdll.lib>
#include <WinTools.lib>

// create list of switchable windows
SwitchList = WinQuerySwitchList(Info().hab);
assert( SwitchList != NULL );

SwitchCount = 1 + GetArraySpan(SwitchList);

printf("Switch  Proc  Sess  WinHndl   Switch-Title/Window-Title\n");
printf("------  ----  ----  --------  ----------------\n");

for ( i = 0; i < SwitchCount; i++ ) {
   printf(" %-8d",SwitchList[i]);
   if ( 0 == WinQuerySwitchEntry(SwitchList[i],SwEntry) ) {
      printf("%-6d%-5d%-10X%s",SwEntry.process,SwEntry.session,SwEntry.hwnd,SwEntry.title);
      if ( (FullTitle = GetWindowTitle(SwEntry.hwnd)) )
         printf("\n                            / %s",FullTitle);
   }
   printf("\n");
}

