@echo OFF
REM ***********************************************************
REM *** XMouse.cmd - Set the active window to always be the ***
REM *** ver.1        one under the mouse, as in XWindows    ***
REM ***********************************************************

ECHO XMouse - Set the window under the mouse as the active
ECHO          window, unless the ctrl-key is pressed or
ECHO          any mouse buttons are pressed, which will
ECHO          temporarily de-activate XMOUSE

Start "XMouse" /N /B /WIN /MIN CEnvi2 %0.cmd %1 %2 %3 %4
CEnvi2 suspend(10000); // give time to read the message
GOTO CENVI_EXIT


#include <WinTools.lib>

#define SUSPEND_TIME    333   // milliseconds between checks

// give earlier message time to display, and make myself invisible
ShowWindow(Info().WinHandle,SW_HIDE);
suspend(10000);

for( ; ; ) {

   suspend(SUSPEND_TIME);

   // get position of active window
   if ( !(ActiveHwnd = GetActiveWindow()) ) {
      WinPos.left = WinPos.right =
      WinPos.top = WinPos.bottom = -1000;
   } else {
      GetWindowRect(ActiveHwnd,WinPos);
   }

   // get position of pointer
   Ptr = PointerPosition();

   // if pointer is not in currently active window then set new active
   #define VK_CTRL      0x0A
   #define VK_BUTTON1   0x01
   #define VK_BUTTON2   0x02
   #define VK_BUTTON3   0x03
   if ( ( Ptr.col < WinPos.left  ||  WinPos.right < Ptr.col
       || Ptr.row < WinPos.bottom  ||  WinPos.top < Ptr.row )
     && !KeyPressed(VK_CTRL) && !KeyPressed(VK_BUTTON1)
     && !KeyPressed(VK_BUTTON2) && !KeyPressed(VK_BUTTON3) ) {

      // go down z-order list of windows to find the first one
      // containing this pointer, then make it active
      lEnum = WinBeginEnumWindows(HWND_DESKTOP);
      while ( lChild = WinGetNextWindow(lEnum) ) {
         if ( IsVisible(lChild) ) {
            GetWindowRect(lChild,WinPos);
            if ( WinPos.left <= Ptr.col  &&  Ptr.col <= WinPos.right
              && WinPos.bottom <= Ptr.row  &&  Ptr.row <= WinPos.top ) {
               // don't accept this window if it is last in z-order (i.e., desktop)
               if ( WinGetNextWindow(lEnum) )
                  SetActiveWindow(lChild);
               break;
            }
         }
      }
      WinEndEnumWindows(lEnum);
   }
}



PointerPosition() // return current cursor position in screen coordinates
{                 // structure elements returned are .col and .row
   #define ORD_WIN32QUERYPOINTERPOS 823
   BLObSize(pointer,4 * 2);
   DynamicLink("PMWIN",ORD_WIN32QUERYPOINTERPOS,BIT32,CDECL,
               HWND_DESKTOP,pointer);
   position.col = BLObGet(pointer,0,SWORD16);
   position.row = BLObGet(pointer,4,SWORD16);
   return(position);
}

KeyPressed(pKey)  // return boolen TRUE if keypressed now, else FALSE
{
   #define ORD_WIN32SETKEYBOARDSTATETABLE   921
   _table[255] = '\0';   // initialize 256-byte key table
   DynamicLink("PMWIN",ORD_WIN32SETKEYBOARDSTATETABLE,BIT32,CDECL,
               HWND_DESKTOP,_table,FALSE);
   return( 0x80 & _table[pKey] );
}

:CENVI_EXIT
