unit Dialun;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, DdeMan, Verinfo;

type
  TDialUninstall = class(TForm)
    btUnInst: TBitBtn;
    btStop: TBitBtn;
    Mem_Desc: TMemo;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Tit_Desc: TLabel;
    Label2: TLabel;
    DdeClient: TDdeClientConv;
    OpenUnInstall: TOpenDialog;
    VersionInfo: TVersionInfo;
    procedure btStopClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
    procedure btUnInstClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-dclarations }
    First : boolean;
    function  DestroyGroup (FileName : string) : integer;
  public
    { Public-dclarations }
  end;

var
  DialUninstall: TDialUninstall;

implementation

uses Decla,Disque,Lecture,UnAbout;

{$R *.DFM}
{$R INFO.RES}


(* Destroy programs group *)
function TDialUninstall.DestroyGroup (FileName : string) : integer;
var Tmp : integer;
    Macro : string;
    Cmd   : array [0 .. 255] of Char;
begin
 Tmp := 0;
 if FileName = '' then
  Tmp := 1
 else
 begin
  Macro := Format('[DeleteGroup(%s)]', [FileName]) + #13#10;
  StrPCopy (Cmd, Macro);
  DDEClient.ConnectMode := DDEAutomatic;
  if WinVersion > Old_Win then
  begin
   if DDEClient.SetLink('','PROGMAN') = true then
   begin
    if not DDEClient.ExecuteMacro(Cmd, False) then
     Tmp := 2;
    Application.ProcessMessages;
    DDEClient.CloseLink;
   end
   else
    Tmp := 3;
  end
  else
  begin
   if DDEClient.SetLink('PROGMAN','PROGMAN') = true then
   begin
    if not DDEClient.ExecuteMacro(Cmd, False) then
     Tmp := 2;
    Application.ProcessMessages;
    DDEClient.CloseLink;
   end
   else
    Tmp := 3;
  end;
 end;
 DestroyGroup := Tmp;
end;

(* initialisation *)
procedure TDialUninstall.Initialise(Sender: TObject);
begin
 Error := -1;
 First := true;
 Tit_Desc.Enabled := false;
 Mem_Desc.Enabled := false;
 ActiveControl := btUnInst;
end;

(* UnInstall button *)
procedure TDialUninstall.btUnInstClick(Sender: TObject);
var Tmp : string;
    Ite : integer;
    Tp1 : integer;
begin
 OpenUnInstall.FileName := Fch_UnIns + 'INS';
 if OpenUnInstall.Execute then
 begin
  if ExtractFileName (OpenUnInstall.FileName) <> Fch_UnIns + 'INS' then
  begin
   MessageDlg ('You must choose an Unsetup file (UNSETUP.INS)',
               mtError,[mbok],0);
   exit;
  end;
  UnSetupPath := ExtractFilePath (OpenUninstall.FileName);
  Mem_Desc.Lines.Add ('UnInstall is starting ...');
  btUnInst.Enabled := false;
  btStop.Enabled := false;
  Error := ReadUnsFile;
  if Error = 0 then
  begin
   (* groups *)
   for Ite := 1 to max_Group do
   begin
    with VGroup [Ite] do
    begin
     if FullName <> '' then
     begin
      if DestroyGroup (FullName) <> 0 then
      (* try a second chance *)
      begin
       if DestroyGroup (FullName) <> 0 then
       (* unable to destroy *)
       begin
        Error := 3;
        Mem_Desc.Lines.Add ('Deleting group ' + FullName + ' Fail');
       end
       else
        Mem_Desc.Lines.Add ('Deleting group ' + FullName + 'Ok');
      end
      else
       Mem_Desc.Lines.Add ('Deleting group ' + FullName + 'Ok');
     end;
    end;
   end;
   (* files *)
   for Ite := 1 to max_Files do
   begin
    with VFiles [Ite] do
    begin
     if FullName <> '' then
     begin
      if DeleteFile (FullName) <> 0 then
      (* try a second chance *)
      begin
       if DeleteFile (FullName) <> 0 then
       (* unable to destroy *)
       begin
        Error := 2;
        Mem_Desc.Lines.Add ('Deleting files ' + FullName + ' Fail');
       end
       else
        Mem_Desc.Lines.Add ('Deleting files ' + FullName + ' Ok');
      end
      else
       Mem_Desc.Lines.Add ('Deleting files ' + FullName + ' Ok');
     end;
    end;
   end;
   (* UnSetup application *)
   Mem_Desc.Lines.Add ('Deleting UnSetup application');
   DeleteFile (MainDir + '\' + Fch_UnIns + 'INS');
   DeleteFile (MainDir + '\' + Fch_UnIns + 'LOG');
   DeleteFile (MainDir + '\' + Fch_UnIns + 'EXE');
   (* directories *)
   for Ite := max_direc downto 1 do
   begin
    with VDirect [Ite] do
    begin
     if FullName <> '' then
     begin
      if DestroyDirectory (FullName) <> 0 then
      (* try a second chance *)
      begin
       if DestroyDirectory (FullName) <> 0 then
       (* unable to destroy *)
       begin
        Error := 1;
        Mem_Desc.Lines.Add ('Deleting directory ' + FullName + 'Fail');
       end
       else
        Mem_Desc.Lines.Add ('Deleting directory ' + FullName + ' Ok');
      end
      else
       Mem_Desc.Lines.Add ('Deleting directory ' + FullName + ' Ok');
     end;
    end;
   end;
  end
  else
  (* error during read of unistall file *)
   Error := Error + 4;
  Mem_Desc.Enabled := true;
  Mem_Desc.Lines.Add ('Uninstall is ended');
  (* conclusion *)
  btStop.Enabled := true;
  If error = 0 then
  begin
   Mem_Desc.Lines.Add ('UnInstall is successfull');
   Final.ShowModal;
   Close;
  end
  else
  begin
   Mem_Desc.Lines.Add ('UnInstall is unsuccessfull');
   case Error of
    1 : tmp := 'because unable to delete directory';
    2 : tmp := 'because unable to delete file';
    3 : tmp := 'because unable to delete group';
    4 : tmp := 'because bad parameter on UnInstall file';
    5 : tmp := 'because uninstall file (UNSETUP.INS) doesn''t exist';
    6 : tmp := 'because unable to read line on unistall file';
    7 : tmp := 'because not a number on line';
    8 : tmp := 'because maximum of files reach';
    9 : tmp := 'because wrong number in line';
   end;
   Mem_Desc.Lines.add (Tmp);
  end;
 end;
end;

(* button Stop *)
procedure TDialUninstall.btStopClick(Sender: TObject);
begin
 Close;
end;

procedure TDialUninstall.FormCreate(Sender: TObject);
begin
   {format for large fonts}
   if screen.PixelsPerInch = 120 then
     begin
     DialUninstall.Width := 498 ;
     DialUninstall.Height := 393 ;
     end
   else
     begin
     DialUninstall.Width := 400 ;
     DialUninstall.Height := 315 ;
     end;
   DialUninstall.Position := poScreenCenter;
   DialUninstall.Resize;
end;

end.
