unit Generale;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Gfvcl, Verinfo;

type
  TMainBack = class(TForm)
    MTitle: TLabel;
    MTitle1: TLabel;
    MSubTitle: TLabel;
    MSubTitle1: TLabel;
    MAuthor: TLabel;
    MAuthor1: TLabel;
    MJerome: TLabel;
    GradientFill1: TGradientFill;
    VersionInfo: TVersionInfo;
    procedure Initialisation(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-dclarations }
    procedure PutTheText (Flag : boolean);
  public
    { Public-dclarations }
  end;

var MainBack: TMainBack;

implementation

uses Decla,Lecture,Disque,
     Welcome,Custom,Target,UnInst,Install,Process,Success,UnSucces,Packet;

{$R *.DFM}
{$R INFO.RES}

(* initialisation of main Window *)
procedure TMainBack.Initialisation(Sender: TObject);
var Tmp : string;
    bcl : integer;
begin
 if First = true then
 begin
  CustomizeFlg := False;
  UnInstallCop := False;
  UnInstallFil := False;
  PutTheText (False);
  Error := ReadInsFile;
  if Error = 0 then
  begin
   PutTheText (True);
   WelcomeDialog.Show;
   First := false;
  end
  else
  begin
   case Error of
     01 : Tmp := 'InsFile not found';
     02 : Tmp := 'Unabled to open InsFile';
     03 : Tmp := 'Unabled to read one line';
     04 : Tmp := 'Wrong paragraf title';
     05 : Tmp := 'Wrong line because = sign not found';
     06 : Tmp := 'Wrong line because paragrf not found';
     07 : Tmp := 'Wrong line in a information paragraph';
     08 : Tmp := 'Wrong line in a disks paragraph';
     09 : Tmp := 'Wrong line in a origin paragraph';
     10 : Tmp := 'Wrong line in a destination paragraph';
     11 : Tmp := 'Wrong line in a group paragraph';
     12 : Tmp := 'Wrong line in a icons paragraph';
     13 : Tmp := 'Wrong line in a files paragraph';
     14 : Tmp := 'Wrong line in a run paragraph';
     15 : Tmp := 'Wrong number in Num parameter';
     16 : Tmp := 'Wrong number before = sign';
     17 : Tmp := 'Wrong parameters in a Group line';
     18 : Tmp := 'Wrong parameters in a Icons line';
     19 : Tmp := 'Wrong parameters in a Files line';
     20 : Tmp := 'Wrong parameters in a Run line';
     21 : Tmp := 'Wrong number in a Dsk line';
     22 : Tmp := 'Wrong number in a Spc line';
     23 : Tmp := 'Wrong line in a Ini paragraph';
     24 : Tmp := 'Wrong number in a Ini parameter';
     25 : Tmp := 'Wrong number before = sign';
     26 : Tmp := 'Wrong parameter in a INI line';
     27 : Tmp := 'Wrong line in a packet file paragraph';
     28 : Tmp := 'Wrong parameter in a packet file line';
   end;
   MessageDlg (Tmp,MtError,[mbok],0);
   Close;
  end;
 end
 else
 begin
  case CurrentWin of
   1 : WelcomeDialog.Show;
   2 : TargetDialog.Show;
   3 : UnInstallDialog.Show;
   4 : InstallDialog.Show;
   5 : ProcessDialog.Show;
   6 : SuccessDialog.Show;
   7 : UnSuccessDialog.Show;
   8 : CustomDialog.Show;
   9 : PacketDialog.Show;
  end;
 end;
end;

(* creation of main window *)
procedure TMainBack.FormCreate(Sender: TObject);
begin
 First := true;
 CurrentWin := 1;
end;

(* drawing all text on background *)
procedure TMainBack.PutTheText (Flag : boolean);
begin
 if Flag = True then
 begin
  MTitle.Caption := Title + ' ' + Version;
  MSubTitle.Caption := SubTitle;
  MAuthor.Caption := '(c)' + CopyRight + ' by ' + Author;
  MTitle1.Caption := MTitle.Caption;
  MSubTitle1.Caption := MSubTitle.Caption;
  MAuthor1.Caption := MAuthor.Caption;
 end;
 (* title *)
 MTitle.Left := 10;
 MTitle.Top  := 5;
 MTitle1.Left := MTitle.Left + 5;
 MTitle1.Top := MTitle.Top + 5;
 (* subtitle *)
 MSubTitle.Left := 10;
 MSubTitle.Top := MTitle1.Top + MTitle1.Height - 2;
 MSubTitle1.Left := MSubTitle.Left + 5;
 MSubTitle1.Top := MSubTitle.Top + 5;
 (* author *)
 MAuthor.Left := 0;
 MAuthor.Width := Screen.Width;
 MAuthor.Top := Screen.Height - abs ((MAuthor.Font.Height * 4));
 MAuthor1.Left := MAuthor.Left + 4;
 MAuthor1.Width := Screen.Width - 4;
 MAuthor1.Top := MAuthor.Top + 4;
 (* main author *)
 MJerome.Left := 10;
 MJerome.Top := Screen.Height - round (abs((MJerome.Font.Height * 1.5)));
end;

end.
