#ifndef INC_LISTE_HPP
#define INC_LISTE_HPP

#include "listtype.hpp"
#include "LISTENEL.hpp"



        /*
Die Klasse LISTE ist stellt Funktionen zur Verarbeitung von Listen zur Verfgung.
Wenn bei Datenslots eine Kardinalitt von "m" (Many) angegeben wird, ist der Slot automatisch vom Typ LISTE. Der Programmierer ist dann selber dafr Verantwortlich, wie Elemente in die Liste eingefgt, gelscht, bearbeitet etc. werden.
Selbstverstndlich steht es dem Programmierer frei, diese Klasse durch eine eigene zu ersetzen.
*/
class LISTE  {


// erzeugt von US (Innovative Software) am 14.08.1991, 13:24
// letzte nderung von US am 22.09.1991, 11:41

    public:
/*
Konstruktor zur Initialisierung der Slots.
*/
        LISTE();
/*
Das Erste Element der Liste wird zum aktuellen Element gemacht.
Wenn die Liste leer ist, ist das aktuelle Element 0.
Der Rckgabewert ist der Zeiger auf die Daten des aktuellen Elements, wenn die Liste nicht leer ist, sonst 0.
*/
        VOIDPTR GoFirst();
/*
Das letzte Element der Liste wird zum aktuellen Element gemacht.
Wenn die Liste leer ist, ist das aktuelle Element 0.
Der Rckgabewert ist der Zeiger auf die Daten des aktuellen Elements, wenn die Liste nicht leer ist, sonst 0.
*/
        VOIDPTR GoLast();
/*
Das nachfolgende Element des Aktuellen Elements der Liste wird zum aktuellen Element gemacht.
Wenn das aktuelle Element 0 ist, bleibt das aktuelle Element 0.
Der Rckgabewert ist der Zeiger auf die Daten des neuen aktuellen Elements, sonst 0.
*/
        VOIDPTR GoNext();
/*
Das verhergehende Element des Aktuellen Elements der Liste wird zum aktuellen Element gemacht.
Wenn das aktuelle Element 0 ist, bleibt das aktuelle Element 0.
Der Rckgabewert ist der Zeiger auf die Daten des neuen aktuellen Elements, sonst 0.
*/
        VOIDPTR GoPrevious();
/*
Diese Methode fgt ein Neues Element in die Liste vor dem aktuellen Element ein. Wenn das Aktuelle Element 0 ist, wird das neue Element an das Ende der Liste angehangen.

Die Parameter enthalten folgende Werte:

VOIDPTR Data: Zeiger auf die Daten des neuen Elements. Wenn dieser Parameter 0 ist, wird kein neues Element eingefgt.

DELETEPROC DeleteProc: Zeiger auf eine Funktion, die vor dem Lschen des Elements aufgerufen wird. Dieser Parameter darf 0 sein.

Der Rckgabewert ist ungleich 0, wenn das Einfgen erfolgreich war. Danach ist das neue Element das aktuelle Element.

*/
        int Insert(VOIDPTR Data, DELETEPROC DeleteProc);
/*
Diese Methode hngt ein Neues Element an das Ender der Liste.

Die Parameter enthalten folgende Werte:

VOIDPTR Data: Zeiger auf die Daten des neuen Elements. Wenn dieser Parameter 0 ist, wird kein neues Element angehngt.

DELETEPROC DeleteProc: Zeiger auf eine Funktion, die vor dem Lschen des Elements aufgerufen wird. Dieser Parameter darf 0 sein.

Der Rckgabewert ist ungleich 0, wenn das Anhngen erfolgreich war. Danach ist das neue Element das aktuelle Element.

*/
        int Append(VOIDPTR Data, DELETEPROC DeleteProc);
/*
Diese Methode liefert den Zeiger auf die Daten des aktuellen Elements zurck. Wenn das aktuelle Element 0 ist, wird eine 0 zurckgegeben.
*/
        VOIDPTR GetCurrent();
/*
Destruktor. Alle zur Liste gehrenden LISTENELEMENTE und ggf. der assoziierte Speicher werden gelscht.
*/
        ~LISTE();
/*
Wenn das aktuelle Element ungleich 0 ist, wird es aus der Liste gelscht. Das nachfolgende Element des zu lschenden Elements wird das neue aktuelle Element.
Der Rckgabewert ist ungleich 0, wenn das Lschen erfolgreich war.
*/
        int Delete();
/*
Wenn das aktuelle Element ungleich 0 ist, wird es aus der Liste gelscht. Das nachfolgende Element des zu lschenden Elements wird das neue aktuelle Element.
Der Rckgabewert ist ungleich 0, wenn das Lschen erfolgreich war.
Die Daten des LISTENELEMENTs werden nicht gelscht!
*/
        int Exclude();
/*
Gibt die Anzahl der in der Liste enthaltenen Elemente zurck.
*/
        int GetElementCount();
/*
Diese Funktion ruft fr jedes Element der Liste die 
Callback-Funktion auf, bis diese einen Wert ungleich 0 
zurckgibt oder alle Elemente abgearbeitet wurden. Der 
Rckgabewert von EnumElements ist gleich dem Rckgabewert 
des letzten Aufrufs der Callback-Funktion. Wenn die Liste leer ist, wird 0 zurckgegeben. 
 
Die Callback-Funktion mu folgende Syntax haben: 
 
long Callback(void* Data, va_list argptr); 
 
Gibt die Callback-Funktion Null zurck, wird, falls vorhanden, 
die Callback-Funktion fr das nchste Element aufgerufen. Gibt 
sie einen  Wert ungleich Null zurck, wird EnumElements abgebrochen und dieser Wert als Ergebnis von EnumElements 
zurckgegegben. 
 
*/
        long EnumElements(LISTEENUMFUNC EnumFunc, ...);
/*
Diese Funktion ruft fr jedes Element der Liste die Methode Delete auf. Dadurch werden alle Elemente gelscht und ihr zugehriger Speicher freigegeben, indem die zugehrige DeleteProc aufgerufen wird.
*/
        void DeleteAll();
/*
Diese Methode ruft fr alle Listenelemente die Methode Exclude auf. Dadurch wird die Liste leer, die zugehrigen LISTENELEMENTE werden gelscht, aber die zu den LISTENELEMENTEn gehrenden Daten werden nicht gelscht (die DeleteProc wird nicht aufgerufen).
*/
        void ExcludeAll();
/*
Die Methode FindData sucht in der Liste nach dem ersten Element, da mit den Daten, auf die DataPtr zeigt, assoziiert ist. 
Wenn kein Element gefunden wurde, ist der Rckgabewert und das aktuelle Element 0, sonst ist der Rckgabewert ungleich 0 und das Aktuelle Element zeigt auf das gefundene Element.

*/
        int FindData(VOIDPTR DataPtr);
    private:
/*
Integer, der die Anzahl der in dieser Liste enthaltenen Elemente enthlt.
*/
        int AnzahlElemente;
/*
Referenz auf das erste Element der Liste. Wenn die Liste leer ist, ist ErstesElement gleich 0.
*/
        LISTENELEMENT* ErstesElement;
/*
Referenz auf das letzte Element der Liste. Wenn die Liste leer ist, ist LetztesElement gleich 0.
*/
        LISTENELEMENT* LetztesElement;
/*
Referenz auf das aktuelle Element der Liste. Dieser Slot kann auch dann 0 sein, wenn die Liste nicht leer ist. Wenn die Liste leer ist, ist dieser Slot auf jeden Fall gleich 0.
*/
        LISTENELEMENT* AktuellesElement;
/*
Enumfunktion fr FindData
*/
        static long FindDataEnum(VOIDPTR Data, va_list argptr);
};

#endif
