PROGRAM Volume;
USES {$IFDEF DPMI} Crt, {$ELSE} WinProcs,WinCRT, {$ENDIF}  VolFuncs;
VAR
  DriveNum    : Byte;
  DriveLet, C : Char;
  V           : VolString;
  HasLabel    : Boolean;

{$IFNDEF WINDOWS}
  PROCEDURE Beep;
  BEGIN
    Sound(2000); Delay(100);
    Sound(1000); Delay(200);
    NoSound;
  END;
  {$ELSE}
  Procedure Beep;
  begin
     MessageBeep(0);
  end;
  {$ENDIF}

  PROCEDURE SyntaxOut;
  BEGIN
    Beep;
    WriteLn('Syntax: "VOLUME [d:]"   ',
            '(d: is a drive letter)');
    Halt;
  END;

  PROCEDURE GetParameters;
  BEGIN
    CASE ParamCount OF
      0 : DriveNum := 0;
      1 : BEGIN
            V := ParamStr(1);
            DriveLet := UpCase(V[1]);
            DriveNum := Ord(DriveLet) - Ord('@');
            IF (DriveNum < 1) OR (DriveNum > 26) THEN
              SyntaxOut;
          END;
      ELSE SyntaxOut;
    END;
  END;

  PROCEDURE GetExistingLabel;
  BEGIN
    V := '';
    Write('Volume in drive ',DriveLet,' ...');
    IF GetLabel(DriveNum, V) THEN
      BEGIN
        WriteLn(#8#8#8'is ',V);
        HasLabel := TRUE;
      END
    ELSE
      BEGIN
        WriteLn(#8#8#8'has no label');
        HasLabel := FALSE;
      END;
  END;

  PROCEDURE GetNewLabel;
  VAR C : Char;
  BEGIN
    Write('Volume label (11 characters, ',
          'ENTER for none)?');
    V := '';
    REPEAT
      C := UpCase(ReadKey);
      CASE C OF
        #0 : C := UpCase(ReadKey); {read extended key}
        #8 : IF length(V) > 0 THEN
               BEGIN
                 Dec(V[0]);
                 Write(#8,' ',#8);
               END
             ELSE Beep;
        #13 : ; {ok}
        #0..#31 : Beep;
        ELSE
          IF length(V) < 11 THEN
            BEGIN
              Inc(V[0]);
              Write(C);
              V[length(V)] := C;
            END
          ELSE Beep;
      END;
    UNTIL C = #13;
    WriteLn;
  END;

BEGIN
  GetParameters;
  GetExistingLabel;
  GetNewLabel;
  IF V = '' THEN
    BEGIN
      Write('Delete current volume label (Y/N)? ');
      REPEAT
        C := UpCase(ReadKey);
      UNTIL (C = 'Y') OR (C = 'N');
      WriteLn(C);
      Write('Label of volume in drive ',
             DriveLet,' ...');
      IF C = 'Y' THEN
        IF DelLabel(DriveNum) THEN
          WriteLn(#8#8#8'successfully deleted.')
        ELSE WriteLn(#8#8#8'was not deleted.')
      ELSE WriteLn(#8#8#8,'will not be deleted.');
    END
  ELSE
    BEGIN
      Write('Label of volume in drive ',
             DriveLet,' ...');
      IF (NOT HasLabel) OR DelLabel(DriveNum) THEN
        IF SetLabel(DriveNum, V) THEN
          WriteLn(#8#8#8'changed to ',V,'.')
        ELSE WriteLn(#8#8#8'was not changed.')
      ELSE WriteLn(#8#8#8,'could not be replaced.');
    END;
END.
