VERSION 2.00
Begin Form Form1 
   Caption         =   "Audio / Video Playback"
   ClientHeight    =   4020
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   6990
   Height          =   4425
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   268
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   466
   Top             =   1140
   Width           =   7110
   Begin CommandButton cmdStop 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Close"
      Height          =   345
      Left            =   1470
      TabIndex        =   3
      Top             =   540
      Width           =   1305
   End
   Begin Timer timNotify 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   60
      Top             =   3720
   End
   Begin TextBox txtVideoFile 
      Height          =   315
      Left            =   525
      TabIndex        =   1
      Top             =   120
      Width           =   3060
   End
   Begin CommandButton cmdResume 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Resume"
      Height          =   345
      Left            =   1470
      TabIndex        =   5
      Top             =   930
      Width           =   1305
   End
   Begin CommandButton cmdPause 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Pause"
      Height          =   345
      Left            =   120
      TabIndex        =   4
      Top             =   930
      Width           =   1305
   End
   Begin CommandButton cmdPlay 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Open && Play"
      Height          =   345
      Left            =   120
      TabIndex        =   2
      Top             =   540
      Width           =   1305
   End
   Begin PictureBox picStage 
      Height          =   4965
      Left            =   2910
      ScaleHeight     =   4935
      ScaleWidth      =   6465
      TabIndex        =   16
      TabStop         =   0   'False
      Top             =   540
      Width           =   6495
   End
   Begin Frame frmOptions 
      Caption         =   "Video playback options:"
      Height          =   1935
      Left            =   120
      TabIndex        =   7
      Top             =   1350
      Width           =   2655
      Begin CheckBox chkMuteSound 
         Caption         =   "&Mute sound"
         Height          =   315
         Left            =   90
         TabIndex        =   15
         Top             =   1560
         Width           =   1905
      End
      Begin OptionButton rdbSizeMode 
         Caption         =   "&Default"
         Height          =   285
         Index           =   0
         Left            =   80
         TabIndex        =   11
         Top             =   270
         Value           =   -1  'True
         Width           =   1305
      End
      Begin OptionButton rdbSizeMode 
         Caption         =   "Stretch stage to video"
         Height          =   285
         Index           =   3
         Left            =   90
         TabIndex        =   14
         Top             =   1230
         Width           =   2235
      End
      Begin OptionButton rdbSizeMode 
         Caption         =   "Center video in stage"
         Height          =   285
         Index           =   2
         Left            =   80
         TabIndex        =   13
         Top             =   900
         Width           =   2235
      End
      Begin OptionButton rdbSizeMode 
         Caption         =   "&Stretch video to stage"
         Height          =   285
         Index           =   1
         Left            =   80
         TabIndex        =   12
         Top             =   570
         Width           =   2235
      End
   End
   Begin Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "&File:"
      Height          =   195
      Left            =   90
      TabIndex        =   0
      Top             =   180
      Width           =   375
   End
   Begin Label lblVideoInfo 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Height          =   195
      Left            =   4740
      TabIndex        =   8
      Top             =   180
      Width           =   75
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Video info:"
      Height          =   195
      Left            =   3690
      TabIndex        =   6
      Top             =   180
      Width           =   930
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Frame:"
      Height          =   195
      Left            =   8280
      TabIndex        =   9
      Top             =   180
      Width           =   585
   End
   Begin Label lblFrame 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      Caption         =   "0"
      Height          =   195
      Left            =   9375
      TabIndex        =   10
      Top             =   180
      Width           =   120
   End
End
Option Explicit

Sub chkMuteSound_Click ()
Dim lRes As Long
    If mmIsOpen("VideoFile") Then
        lRes = mmSetSilent("VideoFile", chkMuteSound.Value)
    End If
End Sub

Sub cmdPause_Click ()
Dim iRes As Integer
    iRes = mmPause("VideoFile")
    cmdPause.Enabled = False
    cmdResume.Enabled = True
End Sub

Sub cmdPlay_Click ()
Dim lRes As Long
    lblFrame.Caption = "0"
    If mmIsOpen("VideoFile") Then
        lRes = mmSeek("VideoFile", 1)
    Else
        lRes = mmOpen(txtVideoFile.Text, "VideoFile", True, picStage.hWnd)
        'lRes = mmOpen(txtVideoFile.Text, "VideoFile", False, 0)
    End If
    If lRes > 0 Then
        MsgBox mmGetErrorString(), 48, "Error"
        lblVideoInfo.Caption = ""
        Exit Sub
    Else
        lblVideoInfo.Caption = "size: " + Format$(mmVideoWidth("VideoFile")) + "x" + Format$(mmVideoHeight("VideoFile")) + ", length: " + Format$(mmLength("VideoFile"))
    End If
    If rdbSizeMode(0).Value Then
        lRes = mmDefaultVideo("VideoFile")
    ElseIf rdbSizeMode(1).Value Then
        lRes = mmStretchVideo("VideoFile", picStage.hWnd)
    ElseIf rdbSizeMode(2).Value Then
        lRes = mmCenterVideo("VideoFile", picStage.hWnd)
    ElseIf rdbSizeMode(3).Value Then
        lRes = mmSizeVideo("VideoFile", picStage.hWnd)
    End If
    If lRes > 0 Then
        MsgBox mmGetErrorString(), 48, "Error"
        Exit Sub
    End If
    lRes = mmSetSilent("VideoFile", chkMuteSound.Value)
    If lRes > 0 Then
        MsgBox mmGetErrorString(), 48, "Error"
        Exit Sub
    End If
    lRes = mmPlay("VideoFile", 0, mmLength("VideoFile"), False)
    If lRes > 0 Then
        MsgBox mmGetErrorString(), 48, "Error"
        Exit Sub
    End If
    cmdStop.Enabled = True
    cmdPause.Enabled = True
    timNotify.Enabled = True
End Sub

Sub cmdResume_Click ()
Dim iRes As Integer
    iRes = mmResume("VideoFile", False)
    cmdResume.Enabled = False
    cmdPause.Enabled = True
End Sub

Sub cmdStop_Click ()
Dim lRes As Long
    lRes = mmClose("VideoFile")
    cmdStop.Enabled = False
    cmdPause.Enabled = False
    cmdResume.Enabled = False
    timNotify.Enabled = False
End Sub

Sub Form_Load ()
Dim lRes As Long
Dim lVolLeft As Long, lVolRight As Long
Dim iRes As Integer
Dim sAudioFile As String

    cmdPlay.Enabled = False
    cmdPause.Enabled = False
    cmdResume.Enabled = False
    cmdStop.Enabled = False
    WindowState = 2
    Show

    sAudioFile = App.Path + "\CHIMES.WAV"
    lRes = mmOpen(sAudioFile, "Audio", False, 0)
        
    If lRes <> 0 Then
        MsgBox mmGetErrorString(), 48, "Error playing " + sAudioFile
        Exit Sub
    End If

    iRes = mmGetVolume("Audio", lVolLeft, lVolRight)

    lRes = mmPlay("Audio", 1, mmLength("Audio"), False)
    Do While mmStatus("Audio") <> "stopped" And mmStatus("Audio") <> "error"
        DoEvents
    Loop
    lRes = mmClose("Audio")
End Sub

Sub Form_Unload (Cancel As Integer)
Dim lRes As Long
    If mmIsOpen("VideoFile") Then lRes = mmClose("VideoFile")
    If mmIsOpen("Audio") Then lRes = mmClose("Audio")
    End
End Sub

Sub rdbSizeMode_Click (Index As Integer)
Dim lRes As Long
    If mmIsOpen("VideoFile") Then
        Select Case Index
            Case 0: lRes = mmDefaultVideo("VideoFile")
            Case 1: lRes = mmStretchVideo("VideoFile", picStage.hWnd)
            Case 2: lRes = mmCenterVideo("VideoFile", picStage.hWnd)
            Case 3: lRes = mmSizeVideo("VideoFile", picStage.hWnd)
        End Select
        picStage.Cls
    End If
End Sub

Sub timNotify_Timer ()
    If mmStatus("VideoFile") <> "stopped" Then
        lblFrame.Caption = Format$(mmPosition("VideoFile"))
        lblFrame.Refresh
    Else
        timNotify.Enabled = False
    End If
End Sub

Sub txtVideoFile_Change ()
    cmdPlay.Enabled = (Trim$(txtVideoFile.Text) <> "")
End Sub

