VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00FFFFFF&
   Caption         =   "ListEx Demo"
   ClientHeight    =   5175
   ClientLeft      =   135
   ClientTop       =   1485
   ClientWidth     =   9285
   Height          =   5580
   Left            =   75
   LinkTopic       =   "Form1"
   ScaleHeight     =   345
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   619
   Top             =   1140
   Width           =   9405
   Begin CommandButton Cmd_Exit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   7440
      TabIndex        =   15
      Top             =   4200
      Width           =   975
   End
   Begin ListExBox ListEx4 
      Height          =   1395
      ItemDefHeight   =   13
      Left            =   2040
      TabIndex        =   14
      Top             =   3480
      Width           =   4335
   End
   Begin ListExBox ListEx3 
      Height          =   1395
      ItemDefHeight   =   13
      Left            =   240
      SelectStyle     =   1  'Standard
      TabIndex        =   13
      Top             =   3480
      Width           =   1455
   End
   Begin ListExBox ListEx2 
      Columns         =   4
      Height          =   750
      ItemDefHeight   =   32
      Left            =   6840
      TabIndex        =   12
      Top             =   2400
      Width           =   1950
   End
   Begin ListExBox ListEx1 
      Height          =   2190
      ItemDefHeight   =   13
      Left            =   240
      MultiSelect     =   2  'Extended
      SelectStyle     =   1  'Standard
      TabIndex        =   11
      Top             =   480
      Width           =   6135
   End
   Begin PictureBox Picture1 
      AutoRedraw      =   -1  'True
      Height          =   480
      Left            =   8640
      ScaleHeight     =   450
      ScaleWidth      =   450
      TabIndex        =   10
      Top             =   3360
      Visible         =   0   'False
      Width           =   480
   End
   Begin DirListBox Dir1 
      Height          =   1830
      Left            =   6720
      TabIndex        =   8
      Top             =   480
      Width           =   2295
   End
   Begin FileListBox File1 
      Height          =   420
      Index           =   1
      Left            =   7560
      Pattern         =   "*.ico"
      TabIndex        =   7
      Top             =   3360
      Visible         =   0   'False
      Width           =   975
   End
   Begin CommandButton Cmd_Add 
      Caption         =   "Add Lines"
      Height          =   375
      Left            =   1560
      TabIndex        =   6
      Top             =   2760
      Width           =   1215
   End
   Begin FileListBox File1 
      Height          =   420
      Index           =   0
      Left            =   6600
      TabIndex        =   1
      Top             =   3360
      Visible         =   0   'False
      Width           =   975
   End
   Begin CommandButton Cmd_Load 
      Caption         =   "Load Files"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   2760
      Width           =   1215
   End
   Begin Image Img_Icons 
      Height          =   240
      Index           =   5
      Left            =   7800
      Picture         =   LISTEX.FRX:0000
      Top             =   4800
      Visible         =   0   'False
      Width           =   240
   End
   Begin Image Img_Icons 
      Height          =   240
      Index           =   4
      Left            =   7440
      Picture         =   LISTEX.FRX:018A
      Top             =   4800
      Visible         =   0   'False
      Width           =   240
   End
   Begin Image Img_Icons 
      Height          =   240
      Index           =   3
      Left            =   8160
      Picture         =   LISTEX.FRX:0314
      Top             =   4800
      Visible         =   0   'False
      Width           =   240
   End
   Begin Shape Shape4 
      Height          =   1695
      Left            =   1920
      Top             =   3360
      Width           =   4575
   End
   Begin Image Img_Chk 
      Height          =   180
      Index           =   1
      Left            =   6960
      Picture         =   LISTEX.FRX:049E
      Top             =   3840
      Visible         =   0   'False
      Width           =   180
   End
   Begin Image Img_Chk 
      Height          =   180
      Index           =   0
      Left            =   6720
      Picture         =   LISTEX.FRX:05B8
      Top             =   3840
      Visible         =   0   'False
      Width           =   180
   End
   Begin Shape Shape3 
      Height          =   1695
      Left            =   120
      Top             =   3360
      Width           =   1695
   End
   Begin Shape Shape2 
      Height          =   3135
      Left            =   120
      Top             =   120
      Width           =   6375
   End
   Begin Shape Shape1 
      Height          =   3135
      Left            =   6600
      Top             =   120
      Width           =   2535
   End
   Begin Label Lbl_File 
      Caption         =   "ICON Directory"
      Height          =   255
      Index           =   4
      Left            =   6720
      TabIndex        =   9
      Top             =   240
      Width           =   2175
   End
   Begin Image Img_Icons 
      Height          =   480
      Index           =   2
      Left            =   8760
      Picture         =   LISTEX.FRX:06D2
      Top             =   3840
      Visible         =   0   'False
      Width           =   480
   End
   Begin Image Img_Icons 
      Height          =   480
      Index           =   0
      Left            =   7440
      Picture         =   LISTEX.FRX:09D4
      Top             =   3840
      Visible         =   0   'False
      Width           =   480
   End
   Begin Image Img_Icons 
      Height          =   480
      Index           =   1
      Left            =   8160
      Picture         =   LISTEX.FRX:0CD6
      Top             =   3840
      Visible         =   0   'False
      Width           =   480
   End
   Begin Label Lbl_File 
      Caption         =   "Creation Time"
      Height          =   255
      Index           =   3
      Left            =   4920
      TabIndex        =   5
      Top             =   240
      Width           =   1215
   End
   Begin Label Lbl_File 
      Caption         =   "Creation Date"
      Height          =   255
      Index           =   2
      Left            =   3600
      TabIndex        =   4
      Top             =   240
      Width           =   1215
   End
   Begin Label Lbl_File 
      Caption         =   "Size"
      Height          =   255
      Index           =   1
      Left            =   1920
      TabIndex        =   3
      Top             =   240
      Width           =   1215
   End
   Begin Label Lbl_File 
      Caption         =   "File Name"
      Height          =   255
      Index           =   0
      Left            =   240
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
End
Option Explicit
DefInt A-Z
' LISTEX - Demo program for using the LISTEX.VBX control
' Joe C. Oliphant
' joe_oliphant@csufresno.edu
' CompuServe [71742,1451]

Dim MaxWidth%

Const LGHTGREY& = &HC0C0C0
Const DRKGREY& = &H808080

Sub Cmd_Add_Click ()
    Dim I
    
    For I = 0 To ListEx1.ListCount - 1 Step 2
    ListEx1.ItemBackColor(I) = LGHTGREY
    If I + 1 < ListEx1.ListCount Then
         ListEx1.ItemBackColor(I + 1) = DRKGREY
    End If
    Next I
End Sub

Sub Cmd_Exit_Click ()
    End
End Sub

Sub Cmd_Load_Click ()
    Dim A$, I%, J%, Ret, TB$, TimeStamp$
    Dim Ext$, UI%
    
    UI = 0
    'UI = 3
    TB$ = Chr$(9)
    ListEx1.Clear
    ListEx1.TabStops(12) = Lbl_File(2).Left - ListEx1.Left
    ListEx1.TabStops(13) = Lbl_File(3).Left - ListEx1.Left
    
    ListEx1.ImageOffset = 4
    ListEx1.TextOffset = 24
    For I = 0 To File1(0).ListCount - 1
    A$ = File1(0).List(I)
    TimeStamp = FileDateTime(A$)
    ListEx1.AddItem A$ & TB$ & Right_Justify(FileLen(A$), 12, MaxWidth) & TB$ & Format$(TimeStamp, "mm/dd/yy") & TB$ & Format$(TimeStamp, "hh:mm:ss am/pm")
    J = InStr(A$, ".")
    Ext$ = ""
    If J Then Ext$ = Mid$(A$, J + 1, 3)
    Select Case Ext$
    Case "wri", "txt", "doc"
        ListEx1.ItemImage(I) = Img_Icons(UI + 1).Picture
        ListEx1.ItemForeColor(I) = QBColor(1)
    Case "bat", "com", "exe"
        ListEx1.ItemImage(I) = Img_Icons(UI + 2).Picture
        ListEx1.ItemForeColor(I) = QBColor(2)
    Case Else
        ListEx1.ItemImage(I) = Img_Icons(UI).Picture
    End Select
    Next I
End Sub

Sub Dir1_Change ()
    Dim I, ICOFile$
    
    Screen.MousePointer = 11
    File1(1).Path = Dir1.Path
    File1(1).Refresh
    ListEx2.Clear
    For I = 0 To File1(1).ListCount - 1
    ICOFile$ = Dir1.Path & "\" & File1(1).List(I)
    ListEx2.AddItem ""
    ListEx2.ItemImage(I) = LoadPicture(ICOFile$)
    Next I
    Screen.MousePointer = 0
End Sub

Sub Form_Load ()
    Dim A$, I, Lft%

    ListEx3.AddItem "Check Boxes"
    ListEx3.ItemForeColor(0) = QBColor(1)
    ListEx3.SelectEnable(0) = False
    For I = 1 To 20
    ListEx3.AddItem "Check " & Format$(I)
    ListEx3.ItemImage(ListEx3.NewIndex) = Img_Chk(0).Picture
    Next I
    
    ListEx4.AddItem "Screen Fonts"
    ListEx4.ItemForeColor(0) = QBColor(1)
    ListEx4.SelectEnable(0) = False
    ListEx3.ImageOffset = Img_Chk(0).Width * .25
    ListEx3.TextOffset = Img_Chk(0).Width * 1.5
    
    For I = 1 To Screen.FontCount
    A$ = Screen.Fonts(I)
    If A$ <> "" Then
        ListEx4.ItemDefHeight = 18
        ListEx4.AddItem A$
        If I Mod 2 Then
            ListEx4.FontItalic = True
            ListEx4.FontBold = False
        Else
            ListEx4.FontItalic = False
            ListEx4.FontBold = True
        End If
        ListEx4.ItemFontName(I) = A$
        ListEx4.ItemFontSize(I) = 16
    End If
    Next I
    
    FontName = ListEx1.FontName
    FontBold = ListEx1.FontBold
    FontItalic = ListEx1.FontItalic
    FontSize = ListEx1.FontSize
    FontStrikethru = ListEx1.FontStrikethru
    FontUnderline = ListEx1.FontUnderline
    MaxWidth = TextWidth("0")     ' Widest character to be used
    If ((TextWidth(" ") Mod 2) And (MaxWidth Mod 2 = 0)) Or ((TextWidth(" ") Mod 2 = 0) And (MaxWidth Mod 2)) Then
        MaxWidth = MaxWidth - 1         ' If width of space is odd and MaxWidth is even or vice-versa, subtract 1 from MaxWidth
    End If
    ' Set tab stops in ListEx1 so that data can be right justified
    ListEx1.NumTabs = 14
    ListEx1.ItemDefHeight = 16
    Lft = Lbl_File(1).Left - ListEx1.Left
    For I = 0 To 11
    ListEx1.TabStops(I) = Lft + I * MaxWidth
    Next I

End Sub

Sub ListEx3_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim I
    
    I = ListEx3.ListIndex
    If I = 0 Then Exit Sub
    If X > (Img_Chk(0).Width * 1.25) * Screen.TwipsPerPixelX Then Exit Sub
    If ListEx3.ItemData(I) Then
        ListEx3.ItemImage(I) = Img_Chk(0).Picture
        ListEx3.ItemData(I) = False
    Else
        ListEx3.ItemImage(I) = Img_Chk(1).Picture
        ListEx3.ItemData(I) = True
    End If
End Sub

Function Right_Justify$ (Parm&, Lngth%, MaxWidth%)
    Dim A$, TotalLen%, SLen%, Tabs%
    
    A$ = Format$(Parm, "#,##0")
    TotalLen = MaxWidth * Lngth                 ' max tab stops * width
    SLen = TextWidth(A$)                        ' Width of string
    Do Until SLen Mod MaxWidth = 0              ' Loop until SLen lines up on a tab stop
    If SLen >= TotalLen Then Exit Do            ' Stop if string is too long
    A$ = " " & A$                               ' Add a leading space to make up difference in width
    SLen = TextWidth(A$)                        ' Get new width
    Loop
    Tabs = (TotalLen - TextWidth(A$)) / MaxWidth' Determine how many tabs to add
    If Tabs > 0 Then A$ = String$(Tabs, 9) & A$ ' Add leading tabs
    Right_Justify$ = A$
End Function

