Option Explicit

Function cpGet (ctl As Control, ByVal sKey As String) As Variant
Dim EOR As String
Dim lPos As Long
Dim sTag As String
Dim lPosNext As Long

   EOR = Chr$(26)

   sTag = ctl.Tag
   lPos = InStr(sTag, sKey)

   If lPos = 0 Then
      cpGet = ""

   Else
      lPosNext = InStr(lPos, sTag, EOR)
      If lPosNext = 0 Then lPosNext = Len(sTag) + 1

      lPos = lPos + Len(sKey) + 1

      cpGet = Mid$(sTag, lPos, lPosNext - lPos)
   End If
End Function

Function cpGetForm (frm As Form, ByVal sKey As String) As Variant
Dim EOR As String
Dim lPos As Long
Dim sTag As String
Dim lPosNext As Long

   EOR = Chr$(26)

   sTag = frm.Tag
   lPos = InStr(sTag, sKey)

   If lPos = 0 Then
      cpGetForm = ""

   Else
      lPosNext = InStr(lPos, sTag, EOR)
      If lPosNext = 0 Then lPosNext = Len(sTag) + 1

      lPos = lPos + Len(sKey) + 1

      cpGetForm = Mid$(sTag, lPos, lPosNext - lPos)
   End If
End Function
 

Sub cpSet (ctl As Control, ByVal sKey As String, ByVal PropValue As Variant)
Dim EOR As String
Dim sValue As String
Dim lPos As Long
Dim sTag As String
Dim lPosNext As Long

   EOR = Chr$(26)

   If IsNull(PropValue) Then
      sValue = ""
   Else
      sValue = PropValue
   End If
   
' Make sure the new property value doesn't contain an embedded EOR
   lPos = InStr(sValue, EOR)
   If lPos Then
      sValue = Left$(sValue, lPos)
   End If

' Search the Tag property for the key (include EOR and '=' to
' only match unique key value)
   sTag = ctl.Tag
   lPos = InStr(sTag, EOR & sKey & "=")

   ' New Property
   If lPos = 0 Then
      ' Don't add if value is empty
      If sValue = "" Then
         Exit Sub
      End If
      
      sTag = sTag & EOR & sKey & "=" & sValue

   Else ' insert new value mid-string
   ' find the end of this entry (beginning of right-hand Tag text to keep)
      lPosNext = InStr(lPos + 1, sTag, EOR)
      If lPosNext = 0 Then lPosNext = Len(sTag) + 1

   ' Point at end of left-hand Tag text to keep
      lPos = lPos + Len(sKey) + 1

      sTag = Left$(sTag, lPos) & sValue & Mid$(sTag, lPosNext)
   End If

   ctl.Tag = sTag
End Sub

Sub cpSetForm (frm As Form, ByVal sKey As String, ByVal PropValue As Variant)
Dim EOR As String
Dim sValue As String
Dim lPos As Long
Dim sTag As String
Dim lPosNext As Long

   EOR = Chr$(26)

   If IsNull(PropValue) Then
      sValue = ""
   Else
      sValue = PropValue
   End If
   
' Make sure the new property value doesn't contain an embedded EOR
   lPos = InStr(sValue, EOR)
   If lPos Then
      sValue = Left$(sValue, lPos)
   End If

' Search the Tag property for the key (include EOR and '=' to
' only match unique key value)
   sTag = frm.Tag
   lPos = InStr(sTag, EOR & sKey & "=")

   ' New Property
   If lPos = 0 Then
      ' Don't add if value is empty
      If sValue = "" Then
         Exit Sub
      End If
      
      sTag = sTag & EOR & sKey & "=" & sValue

   Else ' insert new value mid-string
   ' find the end of this entry (beginning of right-hand Tag text to keep)
      lPosNext = InStr(lPos + 1, sTag, EOR)
      If lPosNext = 0 Then lPosNext = Len(sTag) + 1

   ' Point at end of left-hand Tag text to keep
      lPos = lPos + Len(sKey) + 1

      sTag = Left$(sTag, lPos) & sValue & Mid$(sTag, lPosNext)
   End If

   frm.Tag = sTag
End Sub

