VERSION 2.00
Begin Form frmLocal 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "SuperChat Local"
   ClientHeight    =   1365
   ClientLeft      =   1050
   ClientTop       =   6345
   ClientWidth     =   8505
   ControlBox      =   0   'False
   Height          =   1770
   Icon            =   LOCAL.FRX:0000
   Left            =   990
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   91
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   567
   Top             =   6000
   Width           =   8625
   Begin CommandButton btnQuit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   7200
      TabIndex        =   2
      Top             =   120
      Width           =   1140
   End
   Begin CommandButton btnConnect 
      Caption         =   "&Call"
      Height          =   375
      Left            =   7200
      TabIndex        =   1
      Top             =   600
      Width           =   1140
   End
   Begin dsSocket dssLocal 
      DataSize        =   2048
      Left            =   6480
      Linger          =   0   'False
      LocalPort       =   0
      RemoteDotAddr   =   ""
      RemoteHost      =   ""
      RemotePort      =   0
      ServiceName     =   ""
      Timeout         =   0
      Top             =   90
   End
   Begin TextBox txtLocal 
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   360
      Left            =   360
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   600
      Width           =   6405
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Type Here:"
      Height          =   195
      Left            =   90
      TabIndex        =   3
      Top             =   240
      Width           =   960
   End
End
DefInt A-Z

Sub btnConnect_Click ()
    
    '-- Show the connect form
    frmConnect.Show 1

End Sub

Sub btnQuit_Click ()
    
    Unload frmChat

End Sub

Sub dssLocal_Accept (SocketID As Integer)
'-- Accept occurs when someone connects to YOU.
    
    '-- We need a new form
    Dim Frm As Form
    
    '-- NumNodes is the number of people connected
    NumNodes = NumNodes + 1
    
    '-- Load a new form and set its tag to a non-zero
    '   value so we can identify it as a node
    Set Frm = New frmNode
    Frm.Tag = Str$(NumNodes)
    
    '-- Setting the Socket property hands over the
    '   connection to the new form's DsSocket control
    Frm.dssNode.Socket = SocketID
    
    '-- Determine the user's alias
    If Len(frmConnect.txtAlias) = 0 Then
        frmConnect.txtAlias = frmLocal.dssLocal.LocalName
    End If
    
    '-- Send the alias to the connected user, so they can
    '   see who they're talking to
    Frm.dssNode.Send = "NAME=" & frmConnect.txtAlias & "~"
    
    '-- Make the Chat window "pop up" if its minimized
    If frmChat.WindowState = 1 Then
        frmChat.WindowState = 0
    End If
    
    '-- Move the local form to the bottom of the screen and
    '   tile horizontally, putting the local form on the
    '   bottom
    frmLocal.Top = frmChat.Height
    frmChat.Arrange 1
    btnConnect.Enabled = False
    txtLocal.Enabled = True

    
End Sub

Sub dssLocal_Connect ()
'-- You have successfully connected to another
'   superchat host.
    
    '-- We need a new form
    Dim Frm As Form
    
    '-- NumNodes is the number of people connected
    NumNodes = NumNodes + 1
    
    '-- Load a new form and set its tag to a non-zero
    '   value so we can identify it as a node
    Set Frm = New frmNode
    Frm.Tag = Str$(NumNodes)
    
    '-- Setting the Socket property hands over the
    '   connection to the new form's DsSocket control
    Frm.dssNode.Socket = dssLocal.Socket
    
    '-- Send the alias to the connected user, so they can
    '   see who they're talking to
    Frm.dssNode.Send = "NAME=" & frmConnect.txtAlias & "~"
    
    '-- Move the local form to the bottom of the screen and
    '   tile horizontally, putting the local form on the
    '   bottom
    frmLocal.Top = frmChat.Height
    frmChat.Arrange 1
    
    btnConnect.Enabled = False
    txtLocal.Enabled = True

End Sub

Sub dssLocal_Exception (ErrorCode As Integer, ErrorDesc As String)

    If ErrorCode = SOCK_ERR_CLOSED Then
        btnConnect.Enabled = True
        txtLocal.Enabled = False
    End If

End Sub

Sub dssLocal_Listen ()
'-- This means SuperChat is listening
    
    Caption = "Port" & Str$(ListenPort) & " Ready"

End Sub

Sub Form_Load ()
    
    '-- Initailize the alias field in the connect window.
    frmConnect.txtAlias = frmLocal.dssLocal.LocalName

End Sub

Sub Form_Unload (Cancel As Integer)
    
    '-- Close the socket connection if its open.
    On Error Resume Next
    dssLocal.Action = SOCK_ACTION_CLOSE

End Sub

Sub txtLocal_KeyPress (KeyAscii As Integer)
    
    Static szLine As String

    Select Case KeyAscii
        Case 13 '-- C/R
            '-- Send the keystroke through all nodes
            '   effectively broadcasting your keystrokes.
            For i = 0 To Forms.Count - 1
                If Len(Forms(i).Tag) Then
                    Forms(i).txtNode.SelStart = Len(Forms(i).txtNode)
                    Forms(i).txtNode.SelText = "> " & szLine & Chr$(13) & Chr$(10)
                    Forms(i).dssNode.Send = szLine & Chr$(13) & Chr$(10)
                End If
            Next
            szLine = ""
            txtLocal = ""
            KeyAscii = 0
        Case 8  '-- BackSpace
            '-- remove the last character
            szLine = Left$(szLine, Len(szLine) - 1)
        Case Else
            szLine = szLine & Chr$(KeyAscii)
    End Select
    
    

End Sub

