Attribute VB_Name = "modGetVolumeInformation"
' modGetVolumeInformation - Get volume information.
' 96/03/07 Written by: Larry Rebich

    Option Explicit
    DefLng A-Z

    Const FILE_CASE_PRESERVED_NAMES = &H2
    Const FILE_CASE_SENSITIVE_SEARCH = &H1
    Const FILE_UNICODE_ON_DISK = &H4
    Const FILE_PERSISTENT_ACLS = &H8
    Const FILE_VOLUME_IS_COMPRESSED = &H8000
    
    Const FS_CASE_IS_PRESERVED = FILE_CASE_PRESERVED_NAMES
    Const FS_CASE_SENSITIVE = FILE_CASE_SENSITIVE_SEARCH
    Const FS_UNICODE_STORED_ON_DISK = FILE_UNICODE_ON_DISK
    Const FS_PERSISTENT_ACLS = FILE_PERSISTENT_ACLS
    Const FS_VOL_IS_COMPRESSED = FILE_VOLUME_IS_COMPRESSED

    Declare Function GetVolumeInformation Lib "kernel32" Alias "GetVolumeInformationA" _
        (ByVal lpRootPathName As String, _
         ByVal lpVolumeNameBuffer As String, _
         ByVal nVolumeNameSize As Long, _
         lpVolumeSerialNumber As Long, _
         lpMaximumComponentLength As Long, _
         lpFileSystemFlags As Long, _
         ByVal lpFileSystemNameBuffer As String, _
         ByVal nFileSystemNameSize As Long) As Long
     
    Dim lRet As Long            'return value from call
    Dim sVolName As String      'volume name
    Dim lVolSN As Long          'serial number
    Dim lMaxCompLen As Long     'if 255 then supports long file names
    Dim lVolFlags As Long       'flags, see constants above
    Dim sVolFileSys As String   'file system type
    Const iBufLen = 255         'buffer length
     

Private Function GVI_GetVolumeInformation(sDriveRoot As String) As Boolean
' Main routine, used by all other public routines
    sVolName = String$(iBufLen, vbNull)
    sVolFileSys = String$(iBufLen, vbNull)
    lRet = GetVolumeInformation(sDriveRoot, sVolName, Len(sVolName), _
           lVolSN, lMaxCompLen, lVolFlags, sVolFileSys, Len(sVolFileSys))
    If lRet Then
        GVI_GetVolumeInformation = True
    End If
End Function

Public Function GVI_LongFileNamesSupported(sDriveRoot As String, _
    bLongFileNamesSupported As Boolean, lLength As Long) As Boolean
' Return bLongFileNamesSupported=True if long file names supported on the indicated drive.
' Return the length in lLength.
' Return True if successful.
    If GVI_GetVolumeInformation(sDriveRoot) Then
        lLength = lMaxCompLen
        If lMaxCompLen = 255 Then
            bLongFileNamesSupported = True
        Else
            bLongFileNamesSupported = False
        End If
        GVI_LongFileNamesSupported = True
    End If
End Function

Public Function GVI_VolumeSerialNumber(sDriveRoot As String) As String
' Return the Disk's Volume Serial Number as a formatted string
    If GVI_GetVolumeInformation(sDriveRoot) Then
        GVI_VolumeSerialNumber = GVI_FormatVolumeNumber(lVolSN)
    End If
End Function

Private Function GVI_FormatVolumeNumber(lVolNumber As Long) As String
' Return a formatted volume serial number
    Dim sTemp As String
    If lVolNumber <> 0 Then
        sTemp = Hex$(lVolNumber)
        sTemp = Right$("00000000" & sTemp, 8)
        sTemp = Left$(sTemp, 4) & "-" & Right$(sTemp, 4)
        GVI_FormatVolumeNumber = sTemp
    End If
End Function

Public Function GVI_VolumeName(sDriveRoot As String) As String
' Disk's Volume Name
    If GVI_GetVolumeInformation(sDriveRoot) Then
        GVI_VolumeName = sVolName
    End If
End Function

Public Function GVI_FileSystem(sDriveRoot As String) As String
' File system's name, FAT, HPFS or NTFS
    If GVI_GetVolumeInformation(sDriveRoot) Then
        GVI_FileSystem = sVolFileSys
    End If
End Function

Public Function GVI_VolumeCompressed(sDriveRoot As String) As Boolean
' Return True if the specified volume is a compressed volume; for example, a DoubleSpace volume.
    If GVI_GetVolumeInformation(sDriveRoot) Then
        If Hex(lVolFlags And FILE_VOLUME_IS_COMPRESSED) = Hex(FILE_VOLUME_IS_COMPRESSED) Then
            GVI_VolumeCompressed = True
        End If
    End If
End Function

Public Function GVI_PersistentACLS(sDriveRoot As String) As Boolean
' Return True if the file system preserves and enforces access control lists
    If GVI_GetVolumeInformation(sDriveRoot) Then
        If Hex(lVolFlags And FILE_PERSISTENT_ACLS) = Hex(FILE_PERSISTENT_ACLS) Then
            GVI_PersistentACLS = True
        End If
    End If
End Function

Public Function GVI_FileUnicodeOnDisk(sDriveRoot As String) As Boolean
' Return True if the file system supports Unicode in file names
    If GVI_GetVolumeInformation(sDriveRoot) Then
        If Hex(lVolFlags And FILE_UNICODE_ON_DISK) = Hex(FILE_UNICODE_ON_DISK) Then
            GVI_FileUnicodeOnDisk = True
        End If
    End If
End Function

Public Function GVI_FileCaseSensitiveSearch(sDriveRoot As String) As Boolean
' Return True if the file system supports case-sensitive file names
    If GVI_GetVolumeInformation(sDriveRoot) Then
        If Hex(lVolFlags And FILE_CASE_SENSITIVE_SEARCH) = Hex(FILE_CASE_SENSITIVE_SEARCH) Then
            GVI_FileCaseSensitiveSearch = True
        End If
    End If
End Function

Public Function GVI_FileCasePerserved(sDriveRoot As String) As Boolean
' Return True if the file system preserves the case of file names when saved to disk
    If GVI_GetVolumeInformation(sDriveRoot) Then
        If Hex(lVolFlags And FILE_CASE_PRESERVED_NAMES) = Hex(FILE_CASE_PRESERVED_NAMES) Then
            GVI_FileCasePerserved = True
        End If
    End If
End Function





