VERSION 4.00
Begin VB.Form frmGetVolumeInformation 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Get Volume Information"
   ClientHeight    =   2940
   ClientLeft      =   3360
   ClientTop       =   3750
   ClientWidth     =   3870
   Height          =   3660
   Left            =   3300
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2940
   ScaleWidth      =   3870
   ShowInTaskbar   =   0   'False
   Top             =   3090
   Width           =   3990
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   60
      TabIndex        =   0
      Top             =   2580
      Width           =   3735
   End
   Begin VB.ListBox List1 
      BackColor       =   &H8000000F&
      Height          =   2430
      IntegralHeight  =   0   'False
      Left            =   60
      TabIndex        =   1
      Top             =   60
      Width           =   3735
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About"
      End
   End
End
Attribute VB_Name = "frmGetVolumeInformation"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' LongFileNamesSupported.Frm
' 96/03/07 Written by Larry Rebich, 71662,205
    
    Option Explicit
    DefLng A-Z
    

Private Sub Command1_Click()
' Display volume information
    Dim bUnknown As Boolean         'found volume?
    Dim sTemp As String             'work variable
    Dim sDrive As String            'drive letter [c:\]
    Dim bSupported As Boolean       'supported switch
    Dim lLength As Long             'length supported
    sDrive = Left$(Drive1.Drive, 2) & "\"   'build drive string
    If GVI_LongFileNamesSupported(sDrive, bSupported, lLength) Then 'get long file name info
        If bSupported Then          'supported, yes
            sTemp = "Supported"
        Else                        'no
            sTemp = "Not Supported"
        End If
    Else                            'unknown
        sTemp = "Not Available"
        bUnknown = True
    End If
    List1.Clear                     'clear the list box
    List1.AddItem " Drive " & vbTab & vbTab & vbTab & sDrive
    If bUnknown Then                'unknown
        List1.AddItem " Drive Information " & vbTab & vbTab & sTemp
    Else
        List1.AddItem " Long File Names " & vbTab & vbTab & sTemp
        List1.AddItem " Length" & vbTab & vbTab & vbTab & lLength
        List1.AddItem " Volume Name " & vbTab & vbTab & GVI_VolumeName(sDrive)
        List1.AddItem " Volume Serial Number " & vbTab & GVI_VolumeSerialNumber(sDrive)
        List1.AddItem " File System Type " & vbTab & vbTab & GVI_FileSystem(sDrive)
        List1.AddItem ""
        List1.AddItem " Case Preserved" & vbTab & vbTab & GVI_FileCasePerserved(sDrive)
        List1.AddItem " Case Sensitive Search" & vbTab & GVI_FileCaseSensitiveSearch(sDrive)
        List1.AddItem " Unicode On Disk" & vbTab & vbTab & GVI_FileUnicodeOnDisk(sDrive)
        List1.AddItem " Persistent ACLs" & vbTab & vbTab & GVI_PersistentACLS(sDrive)
        List1.AddItem " Volume Compressed" & vbTab & GVI_VolumeCompressed(sDrive)
    End If

End Sub

Private Sub Drive1_Change()
    Command1_Click          'drive has changed, show info for it
End Sub

Private Sub Form_Load()
    Move (Screen.Width - Width) \ 2, (Screen.Height - Height) \ 2   'center me
    SetupForm                               'move controls
    Command1_Click                          'show drive info
End Sub

Private Sub SetupForm()
' Setup the form
    Dim l, t, w, h
    w = ScaleWidth                          'width
    h = ScaleHeight                         'height
    t = h - Drive1.Height
    Drive1.Move 30, t - 30, w - 60          'move the drive control
    h = h - Drive1.Height
    List1.Move 30, 30, w - 60, h - 100      'move the list box
End Sub

Private Sub mnuFileExit_Click()
    Unload Me
End Sub

Private Sub mnuHelpAbout_Click()
    Dim sMsg As String
    sMsg = "This freeware code snippet demonstrates calling API GetVolumeInformation. "
    sMsg = sMsg & vbCr & vbCr
    sMsg = sMsg & "It was originally written to make sure that files with long names "
    sMsg = sMsg & "were not written to network drives not supporting long file names. "
    sMsg = sMsg & "It was enhanced to return all information provided by GetVolumeInformation."
    sMsg = sMsg & vbCr & vbCr & vbTab & vbTab
    sMsg = sMsg & "Larry Rebich"
    sMsg = sMsg & vbCr & vbTab & vbTab
    sMsg = sMsg & "The Bridge, Inc."
    sMsg = sMsg & vbCr & vbTab & vbTab
    sMsg = sMsg & "CIS 71662,205"
    sMsg = sMsg & vbCr & vbTab & vbTab
    sMsg = sMsg & "415-737-0870"
    MsgBox sMsg, vbInformation, " Calling API GetVolumeInformation"
End Sub
