Option Explicit

Function ffnValidTimeDate (vTime2Check As Variant, dynDataSet As Dynaset, zFieldNameToCheck As String, fSayMessage As Integer) As Integer
' Returns true if time value is valid.

    ' Data expected:
    ' vTime2Check has time to validate
    ' dynDataSet is the dynaset we will use to validate the date
    ' zFieldNameToCheck is the name of the dynaset field we will use to test the date
    ' If fSayMessage is true display a message
    
    ' This function uses the database itself to validate the date.
    ' A clone of the incomming dynaset is used so that the record pointer of
    ' the original dynaset is not disturbed.
    
    Dim dynDynasetClone As Dynaset
    Dim zMsgText As String

    Set dynDynasetClone = dynDataSet.Clone()

    ' the function only returns false if an error is triggered.
    ffnValidTimeDate = True
    
    dynDynasetClone.AddNew
    
    On Error GoTo ErrorffnValidTimeDate
    
    ' Attempt to set the date field to the date supplied to the function.
    ' An error indicates that the date was not valid.

    dynDynasetClone.Fields(zFieldNameToCheck) = vTime2Check
    
    On Error GoTo 0
    
    ' a second addnew clears the new record buffer
    dynDynasetClone.AddNew
    
    ' because the close occurs without an update, no new records will be added.
    dynDynasetClone.Close

    Set dynDynasetClone = Nothing
        
    GoTo ExitffnValidTimeDate

ErrorffnValidTimeDate:

    ffnValidTimeDate = False
    
    If fSayMessage = True Then
        If Err = 13 Then
            ' Err 13 is a type mismatch error
            zMsgText = "The date you entered does not appear to be correct.  "
            zMsgText = zMsgText & "Please try again."
        Else
            ' Always a good idea to provide for the unknown
            zMsgText = "An unexpected error occur while validating the date.  "
            zMsgText = zMsgText & "Please try again."
        End If
    End If
    
    MsgBox zMsgText
    
    Resume Next

ExitffnValidTimeDate:

End Function

Sub Main ()
    
    Load Form1

    Form1!Data1.DatabaseName = app.Path + "\" + "valdate.mdb"
    Form1!Data1.RecordSource = "Invoices"
    Form1!Text2.DataField = "ShipDate"
    Form1!Text1.DataField = "InvoiceNumber"
    Form1!Text3.DataField = "CustomerID"

    Form1.Show

End Sub

