VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "VB3D By Neil Marshall"
   ClientHeight    =   6600
   ClientLeft      =   1665
   ClientTop       =   1590
   ClientWidth     =   6375
   Height          =   7005
   Icon            =   FORM1.FRX:0000
   Left            =   1605
   LinkTopic       =   "Form1"
   ScaleHeight     =   6600
   ScaleWidth      =   6375
   Top             =   1245
   Width           =   6495
   Begin SSPanel Panel3D2 
      Align           =   2  'Align Bottom
      BevelInner      =   1  'Inset
      BevelOuter      =   0  'None
      Height          =   2295
      Left            =   0
      TabIndex        =   5
      Top             =   4305
      Width           =   6375
      Begin SSCommand Command3D4 
         Height          =   540
         Left            =   1260
         Picture         =   FORM1.FRX:0302
         TabIndex        =   26
         Top             =   945
         Width           =   540
      End
      Begin SSCommand Command3D3 
         Height          =   540
         Left            =   105
         Picture         =   FORM1.FRX:0604
         TabIndex        =   25
         Top             =   945
         Width           =   540
      End
      Begin SSCommand Command3D2 
         Height          =   645
         Left            =   630
         Picture         =   FORM1.FRX:0906
         TabIndex        =   24
         Top             =   1155
         Width           =   645
      End
      Begin SSCommand Command3D1 
         Height          =   645
         Left            =   630
         Picture         =   FORM1.FRX:0C08
         TabIndex        =   23
         Top             =   525
         Width           =   645
      End
      Begin SSCommand btnSpeedZero 
         Caption         =   "Zero"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   252
         Left            =   4500
         TabIndex        =   22
         Top             =   1170
         Width           =   1032
      End
      Begin SSCommand btnSpeedDec 
         Caption         =   "Decrease"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   252
         Left            =   4500
         TabIndex        =   21
         Top             =   885
         Width           =   1032
      End
      Begin SSCommand btnSpeedInc 
         Caption         =   "Increase"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   252
         Left            =   4500
         TabIndex        =   20
         Top             =   600
         Width           =   1032
      End
      Begin SSCommand btnZeroAll 
         Caption         =   "Zero All"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   435
         Left            =   2760
         TabIndex        =   18
         Top             =   1755
         Width           =   795
      End
      Begin SSCommand btnUserPosZDec 
         Caption         =   "-"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   570
         Left            =   3435
         Picture         =   FORM1.FRX:0F0A
         TabIndex        =   17
         Top             =   1155
         Width           =   540
      End
      Begin SSCommand btnUserPosZInc 
         Caption         =   "+"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   570
         Left            =   3435
         Picture         =   FORM1.FRX:120C
         TabIndex        =   16
         Top             =   585
         Width           =   540
      End
      Begin SSCommand btnUserPosYDec 
         Caption         =   "-"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   570
         Left            =   2880
         Picture         =   FORM1.FRX:150E
         TabIndex        =   12
         Top             =   1155
         Width           =   540
      End
      Begin SSCommand btnUserPosYInc 
         Caption         =   "+"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   570
         Left            =   2880
         Picture         =   FORM1.FRX:1810
         TabIndex        =   11
         Top             =   585
         Width           =   540
      End
      Begin SSCommand btnUserPosXDec 
         Caption         =   "R"
         Height          =   570
         Left            =   2340
         Picture         =   FORM1.FRX:1B12
         TabIndex        =   9
         Top             =   1155
         Width           =   525
      End
      Begin SSCommand btnUserPosXInc 
         Caption         =   "L"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   570
         Left            =   2340
         Picture         =   FORM1.FRX:1E14
         TabIndex        =   8
         Top             =   585
         Width           =   525
      End
      Begin SSCommand btnAtloc 
         Caption         =   "AtLoc"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   312
         Left            =   60
         TabIndex        =   6
         Top             =   120
         Width           =   552
      End
      Begin Label Label6 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "Speed"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   195
         Left            =   4575
         TabIndex        =   19
         Top             =   195
         Width           =   795
      End
      Begin Label Label5 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "Z"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   195
         Left            =   3540
         TabIndex        =   15
         Top             =   360
         Width           =   315
      End
      Begin Label Label4 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "Y"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   195
         Left            =   3015
         TabIndex        =   14
         Top             =   375
         Width           =   255
      End
      Begin Label Label3 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "X"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   195
         Left            =   2430
         TabIndex        =   13
         Top             =   375
         Width           =   315
      End
      Begin Label Label2 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "Change your position"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Left            =   2025
         TabIndex        =   10
         Top             =   150
         Width           =   2235
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "True"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   192
         Left            =   660
         TabIndex        =   7
         Top             =   180
         Width           =   672
      End
   End
   Begin PictureBox Picture1 
      Height          =   3312
      Left            =   480
      ScaleHeight     =   3285
      ScaleWidth      =   5505
      TabIndex        =   4
      Top             =   900
      Width           =   5532
   End
   Begin CommonDialog CMDialog1 
      Left            =   0
      Top             =   2520
   End
   Begin SSPanel Panel3D1 
      Align           =   1  'Align Top
      BevelInner      =   1  'Inset
      BevelOuter      =   0  'None
      Height          =   552
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   6372
      Begin SSCommand Command3D5 
         Caption         =   "About"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   435
         Left            =   2220
         TabIndex        =   27
         Top             =   60
         Width           =   1140
      End
      Begin SSCommand btnStart 
         Caption         =   "Start"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   432
         Left            =   1080
         TabIndex        =   3
         Top             =   60
         Width           =   1152
      End
      Begin SSCommand btnExit 
         Caption         =   "Exit"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   432
         Left            =   5220
         TabIndex        =   2
         Top             =   60
         Width           =   1092
      End
      Begin SSCommand btnRead 
         Caption         =   "Read Data"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   432
         Left            =   60
         TabIndex        =   1
         Top             =   60
         Width           =   1032
      End
   End
End

Sub btnAtloc_Click ()
   AtLoc = Not AtLoc
   If AtLoc = True Then
      Label1.Caption = "True"
   Else
      Label1.Caption = "False"
   End If
End Sub

Sub btnExit_Click ()
   End
End Sub

Sub btnRead_Click ()

   On Error GoTo ErrorHandler ' Set up error handler.

' Show File Open Dialog
   CMDialog1.Filter = "3D Data Files (*.3dd)|*.3dd"
   CMDialog1.CancelError = True
   CMDialog1.Action = 1

'Next we read in all of the lines that are in the object...
   Open CMDialog1.Filename For Input As #1  ' Try to open file.
   LineNo = 0
   While Not EOF(1)
      Input #1, Points(LineNo).X, Points(LineNo).Y, Points(LineNo).Z
      Input #1, Points(LineNo).X1, Points(LineNo).Y1, Points(LineNo).Z1
      LineNo = LineNo + 1
   Wend
   NumberOfLines = LineNo
   DeterminePointsToRotate

ExitProcedure:
   Close    ' Close all files.
   Exit Sub ' Exit before entering error  handler.

ErrorHandler:  ' Error handler line label.

   If Err <> CDERR_CANCEL Then
      Msg = "ERROR " & Err & " occurred." ' Show just error number
      MsgBox Msg  ' Display error message.
   End If
   Resume ExitProcedure ' Leave procedure.
End Sub

Sub btnSpeedDec_Click ()
   Speed = Speed - 5
End Sub

Sub btnSpeedInc_Click ()
   Speed = Speed + 5
End Sub

Sub btnSpeedZero_Click ()
   Speed = 0
End Sub

Sub btnStart_Click ()

'The following sets up the rotation & perspective variables.

'Deg1 & Deg2 are the two angles of rotation
'D1 & D2 are the deltas of each axes. If D1 = -5, for instance, then
'Deg1 will be decreased 5 degress every frame.
Deg1 = 0
Deg2 = 0
D1 = 0
D2 = 0

'Spos & Mypos are for the perspective routines...
'Spos is the screen's Z coordinate and Mypos is the users Z coordinate
Spos = -250
Mypos = 0

'Mx, My, and Mz are the coordinates of the user.
Mx = 0
My = 0
Mz = 0
'Ox, Oy, and Oz are the coordinates of the craft.
Ox = 0
Oy = 0
Oz = -260

'main loop
NumOfFrames = 0
AtLoc = True
Do

    'adjust the angles according to their deltas...
    Deg1 = (Deg1 + D1) Mod 360
    Deg2 = (Deg2 + D2) Mod 360
    'fix the angles up if they go out of range
    If Deg1 < 0 Then Deg1 = Deg1 + 360
    If Deg2 < 0 Then Deg2 = Deg2 + 360
    'get the sine and cosine of each angle from the tables
    'that were prepared at the beginning of the program
    Cos1& = Cosine&(Deg1)
    Sin1& = Sine&(Deg1)
    Cos2& = Cosine&(Deg2)
    Sin2& = Sine&(Deg2)

    'now we must adjust the object's coordinates
    'based on how quickly it is moving...

    Xc = Speed
    Yc = 0
    Zc = 0

    X1 = (Xc * Cos1&) \ 1024
    Y1 = (Xc * Sin1&) \ 1024
    X2 = (X1 * Cos2&) \ 1024
    Zn = (X1 * Sin2&) \ 1024
    Ox = Ox + X2
    Oy = Oy + Y1
    Oz = Oz + Zn
    If Oz > 32000 Then Oz = 32000
    If Oz < -32000 Then Oz = -32000
    If Ox > 32000 Then Ox = 32000
    If Ox < -32000 Then Ox = -32000
    If Oy > 32000 Then Oy = 32000
    If Oy < -32000 Then Oy = -32000

    'if Atloc is true then Auto-Center is on...
    If AtLoc Then
	Mx = Mx + (Ox - Mx) \ 4
	My = My + (Oy - My) \ 4
	Mz = Mz + ((Oz + 200) - Mz) \ 4
    Else
	'adjust the users position based on how much he is moving...
	Mz = Mz + Mzm
	Mx = Mx + Mxm
	My = My + Mym
	If Mz > 32000 Then Mz = 32000
	If Mz < -32000 Then Mz = -32000
	If Mx > 32000 Then Mx = 32000
	If Mx < -32000 Then Mx = -32000
	If My > 32000 Then My = 32000
	If My < -32000 Then My = -32000
    End If
    'erase the old lines...
      For A = 0 To LineCount - 1
	 picture1.Line (XOldStart(A), YOldStart(A))-(XOldEnd(A), YOldEnd(A)), QBColor(15)
      Next
    'rotate the points...
    For PointToRotate = 0 To NumberOfPointsToRotate - 1
	Rc = PointsToRotate(PointToRotate)
	Xo = X(Rc)
	Yo = Y(Rc)
	Zo = Z(Rc)
	X1 = (Xo * Cos1& - Yo * Sin1&) \ 1024
	Y1c& = (Xo * Sin1& + Yo * Cos1&) \ 1024 - My + Oy
	X1c& = (X1 * Cos2& - Zo * Sin2&) \ 1024 - Mx + Ox
	Zn = (X1 * Sin2& + Zo * Cos2&) \ 1024 - Mz + Oz
	'if the point is too close(or behind) the viewer then
	'don't draw it...
	If (Mypos - Zn) < 15 Then
	    Xn(Rc) = -1
	    Yn(Rc) = 0
	    Zn = 0
	Else
	    'Put the point into perspective...
	    'The original formula was:
	    'Xnew=Xnew+( -Xold * ( (Spos-Z) / (MPos-Z) ) )
	    'Ynew=Ynew=( -Yold * ( (Spos-Z) / (Mpos-Z) ) )
	    V = (1330& * (Spos - Zn)) \ (Mypos - Zn)
	    Xn(Rc) = 320 + X1c& + (-X1c& * V) \ 1330
	    Yn(Rc) = 175 + Y1c& + (-Y1c& * V) \ 1330
	End If
    Next PointToRotate
    'draw the lines...
    '(puts it's screen coordinates into an array)
      LineCount = 0
      For A = 0 To NumberOfLines - 1
	 EndPoint = Pointers1(A)
	 StartPoint = Pointers2(A)
	 XEndScreen = Xn(EndPoint)
	 YEndScreen = Yn(EndPoint)
	 'if XEndScreen<>-1 then it's in view...
	 If XEndScreen <> -1 Then
	       If Xn(StartPoint) <> -1 Then
		  XStartScreen = Xn(StartPoint)
		  YStartScreen = Yn(StartPoint)
		  picture1.Line (XStartScreen, YStartScreen)-(XEndScreen, YEndScreen), QBColor(0)
		  'store the lines so they can be erased later...
		  XOldStart(LineCount) = XStartScreen
		  YOldStart(LineCount) = YStartScreen
		  XOldEnd(LineCount) = XEndScreen
		  YOldEnd(LineCount) = YEndScreen
		  LineCount = LineCount + 1
	       End If
	 End If
      Next
   NumOfFrames = NumOfFrames + 1
   DoEvents
Loop

End Sub

Sub btnUserPosXDec_Click ()
   Mxm = Mxm - 2
End Sub

Sub btnUserPosXInc_Click ()
   Mxm = Mxm + 2
End Sub

Sub btnUserPosYDec_Click ()
   Mym = Mym - 2
End Sub

Sub btnUserPosYInc_Click ()
   Mym = Mym + 2
End Sub

Sub btnUserPosZDec_Click ()
   Mzm = Mzm - 2
End Sub

Sub btnUserPosZInc_Click ()
   Mzm = Mzm + 2
End Sub

Sub btnZeroAll_Click ()
   Mxm = 0
   Mym = 0
   Mzm = 0
End Sub

Sub Command3D1_Click ()
D1 = D1 + 1
End Sub

Sub Command3D2_Click ()
D1 = D1 - 1
End Sub

Sub Command3D3_Click ()
D2 = D2 + 1
End Sub

Sub Command3D4_Click ()
D2 = D2 - 1
End Sub

Sub Command3D5_Click ()
about.Show
End Sub

Sub Form_Load ()
' Adjust the form size to fit in a screen with VGA resolution
   Form1.Width = 640 * Screen.TwipsPerPixelX
   Form1.Height = 480 * Screen.TwipsPerPixelY

' Place the form on screen
   Form1.Left = 0 ' For VGA resolution
   Form1.Top = 0
   If Screen.Width > 640 * Screen.TwipsPerPixelX Then ' Is it a SVGA screen
      Form1.Left = (Screen.Width - Form1.Width) / 2   ' Yes, center the form
      Form1.Top = (Screen.Height - Form1.Height) / 2
   End If

' Place the buttons  !! If you want the screen look good also when maximized, make
' a resize event too. I didn't place all the buttons.
   btnRead.Left = (Panel3D1.BorderWidth + Panel3D1.BevelWidth) * Screen.TwipsPerPixelX
   btnRead.Top = (Panel3D1.BorderWidth + Panel3D1.BevelWidth) * Screen.TwipsPerPixelY
   btnRead.Height = Panel3D1.Height - 2 * (Panel3D1.BorderWidth + Panel3D1.BevelWidth) * Screen.TwipsPerPixelX
   btnRead.Width = (Panel3D1.Width - 2 * (Panel3D1.BorderWidth + Panel3D1.BevelWidth) * Screen.TwipsPerPixelX) / 6
   btnStart.Left = btnRead.Left + btnRead.Width
   btnStart.Top = btnRead.Top
   btnStart.Width = btnRead.Width
   btnStart.Height = btnRead.Height
   btnExit.Top = btnRead.Top
   btnExit.Height = btnRead.Height
   btnExit.Width = btnRead.Width
   btnExit.Left = Panel3D1.Width - (Panel3D1.BorderWidth + Panel3D1.BevelWidth) * Screen.TwipsPerPixelX - btnRead.Width
   btnAtLoc.Left = (Panel3D2.BorderWidth + Panel3D2.BevelWidth) * Screen.TwipsPerPixelX
   btnAtLoc.Top = (Panel3D2.BorderWidth + Panel3D2.BevelWidth) * Screen.TwipsPerPixelY
   btnAtLoc.Height = 22 * Screen.TwipsPerPixelX
   btnAtLoc.Width = 50 * Screen.TwipsPerPixelX
   Label1.Top = btnAtLoc.Top + (btnAtLoc.Height - Label1.Height) / 2
   Label1.Left = btnAtLoc.Left + btnAtLoc.Width + 4 * Screen.TwipsPerPixelX

'Place the picture box showing our pictures
   picture1.Width = 320 * Screen.TwipsPerPixelX
   picture1.Height = 200 * Screen.TwipsPerPixelY
   picture1.Left = (Form1.Width - picture1.Width) / 2
   picture1.Top = Panel3D1.Height + (Panel3D2.Top - Panel3D1.Height) / 2 - picture1.Height / 2
   picture1.Scale (0, 0)-(640, 480)
   picture1.Visible = True
' Initialize sine and cosine tables
   MakeSinCosTables
End Sub

Sub Form_Resize ()
command3d5.Left = btnStart.Left + btnStart.Width
command3d5.Width = btnStart.Width
End Sub

