DefInt A-Z

' User defined type defining a line by start point
' (X,Y,Z) and end point (X1,Y1,Z1).
Type LineType
    X As Integer
    Y As Integer
    Z As Integer
    X1 As Integer
    Y1 As Integer
    Z1 As Integer
End Type

' An array to store lines
Global points(100) As LineType

Global Xs(100) As Single, Ys(100) As Single, Xe(100) As Single, Ye(100) As Single, Xn(100) As Single, Yn(100) As Single

' Arrays to store screen coordinates of last drawn lines
Global XOldStart(100) As Single, YOldStart(100) As Single, XOldEnd(100) As Single, YOldEnd(100) As Single

' Arrays to store point coordinates. Index is point number
Global X(100) As Single, Y(100) As Single, Z(100) As Single

' Arrays to store point numbers - Pointers1 for start points, Pointers2 for end points
' Index is line #, value is point #
Global Pointers1(100) As Single, Pointers2(100) As Single

' List of points to rotate - value is point number
Global PointsToRotate(100) As Single

'Sine and cosine lookup tables
Global Cosine&(360), Sine&(360)

Global NumberOfLines
Global NumberOfPoints
Global NumberOfPointsToRotate

' Control variables
Global AtLoc
Global Mxm
Global Mym
Global Mzm
Global Speed

    Global D1
    Global D2
' Constants used in program
Global Const CDERR_CANCEL = 32755' Common dialog cancel button was clicked

Sub DeterminePointsToRotate ()
'Here comes the hard part... Consider this scenario:

'We have two connected lines, like this:

'   1--------2 and 3
'            |
'            |
'            |
'            |
'            4
'Where 1,2, 3, & 4 are the starting and ending points of each line.
'The first line consists of points 1 & 2  and the second line
'is made of points 3 & 4.
'So, you ask, what's wrong? Nothing, really, but don't you see that
'points 2 and 3 are really at the sample place? Why rotate them twice,
'that would be a total waste of time? The following code eliminates such
'occurrences from the line table. (great explanation, huh?)

'take all of the starting & ending points and put them in one big
'array...
NumberOfPoints = 0
For LineNumber = 0 To NumberOfLines - 1
    X(NumberOfPoints) = points(LineNumber).X
    Y(NumberOfPoints) = points(LineNumber).Y
    Z(NumberOfPoints) = points(LineNumber).Z
    NumberOfPoints = NumberOfPoints + 1
    X(NumberOfPoints) = points(LineNumber).X1
    Y(NumberOfPoints) = points(LineNumber).Y1
    Z(NumberOfPoints) = points(LineNumber).Z1
    NumberOfPoints = NumberOfPoints + 1
Next LineNumber

'Now set up two sets of pointers that point to each point that a line
'is made of... (in other words, scan for the first occurrence of each
'starting and ending point in the point array we just built...)
For LineToTest = 0 To NumberOfLines - 1
    XTest = points(LineToTest).X
    YTest = points(LineToTest).Y
    ZTest = points(LineToTest).Z            'get the 3 coordinates of the start point
    For PointToTest = 0 To NumberOfPoints - 1         'scan the point array
        If X(PointToTest) = XTest And Y(PointToTest) = YTest And Z(PointToTest) = ZTest Then
            Pointers1(LineToTest) = PointToTest    'set the pointer to point to the
            Exit For            'point we have just found
        End If
    Next PointToTest
    XTest = points(LineToTest).X1           'do the same thing that we did above
    YTest = points(LineToTest).Y1           'except scan for the ending point
    ZTest = points(LineToTest).Z1           'of each line
    For PointToTest = 0 To NumberOfPoints - 1
        If X(PointToTest) = XTest And Y(PointToTest) = YTest And Z(PointToTest) = ZTest Then
            Pointers2(LineToTest) = PointToTest
            Exit For
        End If
    Next PointToTest
Next LineToTest
'Okay, were almost done! All we have to do now is to build a table
'that tells us which points to actually rotate...
NumberOfPointsToRotate = 0
For LineToTest = 0 To NumberOfLines - 1
    StartPointNo = Pointers1(LineToTest)
    EndPointNo = Pointers2(LineToTest)
    If NumberOfPointsToRotate = 0 Then
        PointsToRotate(NumberOfPointsToRotate) = StartPointNo
        NumberOfPointsToRotate = NumberOfPointsToRotate + 1
    Else
        Found = 0
        For PointToTest = 0 To NumberOfPointsToRotate - 1
            If PointsToRotate(PointToTest) = StartPointNo Then
                Found = -1
                Exit For'already in list
            End If
        Next PointToTest
        If Not Found Then PointsToRotate(NumberOfPointsToRotate) = StartPointNo
        NumberOfPointsToRotate = NumberOfPointsToRotate + 1
    End If

    Found = 0
    For PointToTest = 0 To NumberOfPointsToRotate - 1
        If PointsToRotate(PointToTest) = EndPointNo Then
            Found = -1
            Exit For
        End If
    Next PointToTest
    If Not Found Then PointsToRotate(NumberOfPointsToRotate) = EndPointNo
    NumberOfPointsToRotate = NumberOfPointsToRotate + 1
Next LineToTest
End Sub

Sub MakeSinCosTables ()
'The following for/next loop makes a sine & cosine table.
'Each sine & cosine is multiplied by 1024 and stored as long integers.
'This is done so that we don't have to use any slow floating point
'math at run time.
A% = 0
For I! = 0 To 359 / 57.29577951 Step 1 / 57.29577951
    Cosine&(A%) = Int(.5 + Cos(I!) * 1024)
    Sine&(A%) = Int(.5 + Sin(I!) * 1024): A% = A% + 1
Next
End Sub

