Option Explicit
'****************************************************
'* COMMON01.BAS Version 1.0 Date: 3/30/94           *
'* DPM Computer Solutions                           *
'* 8430-D Summerdale Road San Diego CA 92126-5415   *
'* InterNet: DPMCS@HIGH-COUNTRY.COM                 *
'* Compuserve: 74227,1557                           *
'****************************************************
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal AppName As String, ByVal KeyName As String, ByVal NewString As String, ByVal FileName As String) As Integer
Declare Function GetPrivateProfilestring Lib "Kernel" (ByVal AppName As String, ByVal KeyName As String, ByVal default As String, ByVal ReturnedString As String, ByVal MAXSIZE As Integer, ByVal FileName As String) As Integer
Declare Function GetKeyState Lib "User" (ByVal NVirtKey%) As Integer

'*******************************************************
'* Procedure Name: AppRunning                          *
'*-----------------------------------------------------*
'* Created: 2/8/94    By: MSDN                         *
'* Modified:          By:                              *
'*=====================================================*
'*Checks to see if the current application is already  *
'*running. To use just call the sub. If the application*
'*is already running, it will end the current          *
'*application.                                         *
'*                                                     *
'*******************************************************
Sub AppRunning ()
	Dim sMSG As String
	If APP.PrevInstance Then
   	sMSG = APP.EXEName & " already running! "
	   MsgBox sMSG, 4112
   	End
	End If
End Sub

'*******************************************************
'* Procedure Name: CenterForm                          *
'*-----------------------------------------------------*
'* Created: 2/10/94   By: VB Programmers Journal       *
'* Modified: 4/24/94  By: David McCarter               *
'*=====================================================*
'*This code will center a form in the center of the    *
'*screen. To use it, just call the sub and pass it the *
'*form name [Call CenterForm main]                     *
'*                                                     *
'*                                                     *
'*******************************************************
Sub CenterForm (frmIN As Form)
	Dim iTop, iLeft As Integer

	If frmIN.WindowState <> 0 Then Exit Sub
	iTop = (Screen.Height - frmIN.Height) \ 2
	iLeft = (Screen.Width - frmIN.Width) \ 2
    
	If iTop And iLeft Then
   	frmIN.Move iLeft, iTop
	End If
End Sub

'*******************************************************
'*                                                     *
'*      Procedure Name:CenterMDIChild                  *
'*                                                     *
'*             Created:2/10/94       By:VB Prog Journl *
'*            Modified:              By:               *
'*                                                     *
'*            Comments:                                *
'*                                                     *
'*******************************************************
'*******************************************************
'* Procedure Name: CenterMDIChild                      *
'*-----------------------------------------------------*
'* Created: 2/10/94   By: VB Programmers Journal       *
'* Modified: 3/24/94  By: D. McCarter                  *
'*=====================================================*
'* Centers a child form within a parent MDI form. To   *
'* use, call the sub and pass it the parent form name  *
'* and the child form name [CenterMDIChild form1 form2]*
'*                                                     *
'*                                                     *
'*******************************************************
Sub CenterMDIChild (frmParent As Form, frmChild As Form)
	Dim iTop, iLeft As Integer
	If frmParent.WindowState <> 0 Or frmChild.WindowState <> 0 Then Exit Sub
	iTop = (frmParent.ScaleHeight - frmChild.Height) \ 2
	iLeft = (frmParent.ScaleWidth - frmChild.Width) \ 2

	If iTop And iLeft Then
   	frmChild.Move iLeft, iTop
	End If
End Sub

'*******************************************************
'* Procedure Name: CutCopyPaste                        *
'*-----------------------------------------------------*
'* Created:           By: VB Help File                 *
'* Modified:          By:                              *
'*=====================================================*
'*This procedure puts all the cut,copy paste commands  *
'*in one place. To use, just call the sub and pass it  *
'*your choice- 0=Cut, 1=Copy, 2=Paste, 3=Delete,       *
'*[Call CutCopyPaste 2]                                *
'*                                                     *
'*******************************************************
Sub CutCopyPaste (iChoice As Integer)
	' ActiveForm refers to the active form in the MDI form.
	If TypeOf Screen.ActiveControl Is TextBox Then
   	Select Case iChoice
			Case 0          ' Cut.
		   	' Copy selected text to Clipboard.
	    		Clipboard.SetText Screen.ActiveControl.SelText
	    		' Delete selected text.
	    		Screen.ActiveControl.SelText = ""
			Case 1          ' Copy.
	    		' Copy selected text to Clipboard.
	    		Clipboard.SetText Screen.ActiveControl.SelText
			Case 2          ' Paste.
	    		' Put Clipboard text in text box.
	    		Screen.ActiveControl.SelText = Clipboard.GetText()
			Case 3          ' Delete.
	    		' Delete selected text.
	    		Screen.ActiveControl.SelText = ""
    	End Select
	End If
End Sub

'*******************************************************
'* Procedure Name: GetAppPath                          *
'*-----------------------------------------------------*
'* Created: 3/24/94   By: David McCarter               *
'* Modified:          By:                              *
'*=====================================================*
'*Returns the application path with a trailing \.      *
'*To use, call the function [SomeString=GetAppPath()]  *
'*                                                     *
'*                                                     *
'*                                                     *
'*******************************************************
Function GetAPPPath () As String
	Dim sTemp As String
	sTemp = APP.Path
	If Right$(sTemp, 1) <> "\" Then sTemp = sTemp + "\"
	GetAPPPath = sTemp
End Function

'*******************************************************
'* Procedure Name: ReadINI                             *
'*-----------------------------------------------------*
'* Created:           By: Daniel Bowen                 *
'* Modified: 3/24/94  By: David McCarter               *
'*=====================================================*
'*Returns a string from an INI file. To use, call the  *
'*functions and pass it the AppName, KeyName and INI   *
'*File Name, [sReg=ReadINI(App1,Key1,INIFile)]. If you *
'*need the returned value to be a integer then use the *
'*val command.                                         *
'*******************************************************
Function ReadINI (AppName, KeyName, FileName As String) As String
	Dim sRet As String
	sRet = String(255, Chr(0))                    
	ReadINI = Left(sRet, GetPrivateProfilestring(AppName, ByVal KeyName, "", sRet, Len(sRet), FileName))
End Function

'*******************************************************
'* Procedure Name: SelectText                          *
'*-----------------------------------------------------*
'* Created: 2/14/94   By: David McCarter               *
'* Modified:          By:                              *
'*=====================================================*
'*Selects all the text in a text box. Call it when the *
'*text box get focus, [SelectText Text1.text]          *
'*                                                     *
'*                                                     *
'*                                                     *
'*******************************************************
Sub SelectText (ctrIn As Control)
	ctrIn.SelStart = 0
	ctrIn.SelLength = Len(ctrIn.Text)
End Sub

'*******************************************************
'* Procedure Name: WriteINI                            *
'*-----------------------------------------------------*
'* Created: 2/10/94   By: David McCarter               *
'* Modified:          By:                              *
'*=====================================================*
'*Writes a string to an INI file. To use, call the     *
'*function and pass it the AppName, KeyName, the New   *
'*String and the INI File Name,                        *
'*[R=WriteINI(App1,Key1,sReg,INIFile)]. Returns a 1 if *
'*there were no errors and a 0 if there were errors.   *
'*******************************************************
Function WriteINI (AppName, KeyName, NewString, FileName As String) As Integer
	WriteINI = WritePrivateProfileString(AppName, KeyName, NewString, FileName)
End Function

