VERSION 2.00
Begin Form frmExport 
   Caption         =   "VB/ISAM Sample Program SAM4 -- Export to .CSV"
   ClientHeight    =   975
   ClientLeft      =   1155
   ClientTop       =   2145
   ClientWidth     =   6825
   ControlBox      =   0   'False
   Height          =   1380
   Left            =   1095
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   975
   ScaleWidth      =   6825
   Top             =   1800
   Width           =   6945
   Begin SSPanel pnlStopButton 
      BackColor       =   &H00C0C0C0&
      BevelInner      =   1  'Inset
      Font3D          =   0  'None
      ForeColor       =   &H00FF0000&
      Height          =   975
      Left            =   5460
      TabIndex        =   1
      Top             =   0
      Width           =   1365
      Begin SSCommand cmdStop 
         Caption         =   "Stop"
         Font3D          =   0  'None
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   795
         Left            =   90
         Outline         =   0   'False
         Picture         =   SAM4EXPO.FRX:0000
         TabIndex        =   2
         Top             =   90
         Width           =   1185
      End
   End
   Begin SSPanel pnlGauge 
      BackColor       =   &H00C0C0C0&
      BevelInner      =   1  'Inset
      FloodColor      =   &H00008000&
      FloodType       =   1  'Left To Right
      Font3D          =   0  'None
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   13.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00000000&
      Height          =   975
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   5445
   End
End
Option Explicit

Dim StopFlag As Integer

Sub cmdStop_Click ()

    Close #ExportFileNum
    Kill ExportFileName

    StopFlag = True 'Main loop in Form_Activate will see this after DoEvents

End Sub

Sub Form_Activate ()

    Dim TempString As String
    Dim PKey As String
    Dim CSVString As String
    Dim LinesWritten As Long
    Dim PercentExported As Integer


    'Refresh RecordsInFile information (may have added/deleted records):
    rc = VMXInfo(DatasetRefNum, DatasetInfo)
    If rc <> VIS_OK Then
        TellUser (INFO_ERROR)
        ExitProgram 'Panic exit
    End If

    rc = VmxBOF(DatasetRefNum, 0)
    LinesWritten = 0
    PercentExported = 0
    StopFlag = False    'see cmdStop
    rc = VmxGet(DatasetRefNum, 0, XNEXT, "", Throwaway, PKey, ExportRecBuffer)  '"prime" the loop
                'CSVString = CSVString & "," & Format$(TempCurrency, "Standard")
    
    Do While rc = VIS_OK

        CSVString = QuoteMaybe(PKey)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.Description)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.ProductCategory)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.FileType)
        CSVString = CSVString & "," & QuoteMaybe(Format$(ExportRecBuffer.BasePrice, "Standard"))
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.PricingNotes)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.CatalogPage)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.CompanyName)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.Phone)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.Fax)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.Comments)
        CSVString = CSVString & CRLFDelim

        Put #ExportFileNum, , CSVString
        LinesWritten = LinesWritten + 1

        PercentExported = Int((LinesWritten / DatasetInfo.RecordsInFile) * 100)
        If (PercentExported - pnlGauge.FloodPercent) >= 5 Then  'Update the indicator every 5%
            pnlGauge.FloodPercent = PercentExported
            DoEvents    'Be nice to Windows (also listen for StopFlag)
            If StopFlag = True Then
                TellUser (EXPORT_ABORTED)
                Me.Hide
                Exit Sub
            End If
        End If
        
        rc = VmxGet(DatasetRefNum, 0, XNEXT, "", Throwaway, PKey, ExportRecBuffer)

    Loop

    'Make sure we finished the loop because we got to the end:
    If rc <> VIS_NOT_FOUND Then
        MBType = MB_ICONEXCLAMATION
        Msg = "VmxGet error: " & Chr$(34) & VmxReturnCode$(rc) & Chr$(34) & " ...after exporting" & Str$(LinesWritten) & " lines."
        MsgBox Msg, MBType, MBTitle
        Close #ExportFileNum
    Else
        Close #ExportFileNum
        MBType = MB_ICONINFORMATION
        Msg = "Export complete."
        MsgBox Msg, MBType, MBTitle
    End If

    Me.Hide
    
End Sub

Function QuoteMaybe (SourceString As String) As String

    If InStr(SourceString, ",") = 0 Then
        QuoteMaybe = SourceString
    Else
        QuoteMaybe = Chr$(34) & SourceString & Chr$(34)   'double-quotes
    End If
    
End Function

