
' VBIS23DM.BAS
'
'*********************************************************************************
'
' THIS .BAS FILE CORRESPONDS TO THE VBIS23DM.DLL FILE -- A DEMONSTRATION VERSION
' OF VB/ISAM FOR WINDOWS.
'
'*********************************************************************************
'
' VB/ISAM MX for Windows Version 2.3
' Copyright (c) Software Source 1991-1994.  All rights
' reserved.  VB/ISAM is a proprietary computer software product provided by
' its copyright holder, Software Source (42808 Christy St., Fremont,
' California); both the software and its documentation are copyrighted, and
' you may not copy or use either except as expressly provided in the VB/ISAM
' Software License.

'******************* Global Constants and Typedefs *******************************

Global Const VIS_OK = 0
Global Const VIS_NOT_FOUND = 1
Global Const VIS_UPDATE_VIOLATION = 2
Global Const VIS_ACCESS_DENIED = 3
Global Const VIS_BAD_DATASET_NUMBER = 4
Global Const VIS_BAD_FORMAT = 5
Global Const VIS_INVALID_KEY = 6
Global Const VIS_BAD_PARAMETER_VALUE = 7
Global Const VIS_BAD_FILE = 8
Global Const VIS_ALREADY_EXISTS = 9
Global Const VIS_NO_ROOM = 10
Global Const VIS_DISK_FULL = 11
Global Const VIS_OUT_OF_MEMORY = 12
Global Const VIS_DOS_ERROR = 13
Global Const VIS_DISK_ERROR = 14
Global Const VIS_DATA_VALIDITY_CHECK = 15
Global Const VIS_INVALID_SECONDARY_KEY = 16
Global Const VIS_SEQUENCE_ERROR = 17
Global Const VIS_OUT_OF_FILE_HANDLES = 18
Global Const VIS_SPECIAL_DEMO_LIMITATION = 99

Global Const ADD_OR_REPLACE = 0
Global Const ADD_ONLY = 1
Global Const REPLACE_ONLY = 2

Global Const XLOOKUP = 1
Global Const XNEXT = 2
Global Const XPREVIOUS = 4
Global Const XCURRENT = 8

Global Const XANY = 16
Global Const XEQ = 32
Global Const XBEGINS = 64
Global Const XNOT = 128
Global Const XLT = 256
Global Const XGT = 512
Global Const XLE = 1024
Global Const XGE = 2048

Global Const XGET_DATA = 4096
Global Const XNO_DATA = 8192

Type VBISAMInfo
    RecordsInFile           As Long
    GroupsUsed              As Integer
    AllocatedGpsAvail       As Integer
    MaxPrimaryKeyLen        As Integer
    GroupSize               As Long
    InitialAllocation       As Integer
    IncrementalAllocation   As Integer
    FreeFileNoteSpace       As Integer
    StandardFormat          As String
    Reserved                As String
End Type

'******************* Function Declarations ***************************************

Declare Function VmxCreate Lib "VBIS23DM.DLL" (DatasetName$, MaxPrimaryKeyLength%, StandardFormat$) As Integer
Declare Function VmxKill Lib "VBIS23DM.DLL" (DatasetName$) As Integer

Declare Function VmxOpen Lib "VBIS23DM.DLL" (DatasetName$, RDatasetNumber%) As Integer
Declare Function VmxClose Lib "VBIS23DM.DLL" (DatasetNumber%) As Integer

Declare Function VmxGet Lib "VBIS23DM.DLL" (DatasetNumber%, IndexFieldNum%, Options%, SelectorKey$, RIndexEntry$, RPrimaryKey$, RRecordVariable As Any) As Integer
Declare Function VmxPut Lib "VBIS23DM.DLL" (DatasetNumber%, PrimaryKey$, RecordVariable As Any, UpdateMode%) As Integer
Declare Function VmxDelete Lib "VBIS23DM.DLL" (DatasetNumber%, PrimaryKey$) As Integer

Declare Function VmxBOF Lib "VBIS23DM.DLL" (DatasetNumber%, Indx%) As Integer
Declare Function VmxEOF Lib "VBIS23DM.DLL" (DatasetNumber%, Indx%) As Integer

Declare Function VmxWriteNote Lib "VBIS23DM.DLL" (DatasetNumber%, NoteName$, NoteContents$) As Integer
Declare Function VmxReadNote Lib "VBIS23DM.DLL" (DatasetNumber%, NoteName$, RNoteContents$) As Integer

Declare Function VmxFlush Lib "VBIS23DM.DLL" (DatasetNumber%) As Integer
Declare Function VMXInfo Lib "VBIS23DM.DLL" (DatasetNumber%, RInfoStructure As VBISAMInfo) As Integer
Declare Function VmxReturnCode Lib "VBIS23DM.DLL" (FunctionReturnCode%) As String

Declare Function VmxEncode Lib "VBIS23DM.DLL" (InStructure As Any, Frmat$, ROutString$) As Integer
Declare Function VmxDecode Lib "VBIS23DM.DLL" (InString$, Frmat$, ROutStructure As Any) As Integer

' End VBIS23DM.BAS

