//
// VBHELPER.DLL source code
//
// Copyright (c) 1994 SoftCircuits Programming
// Redistributed by Permission.
//
// This program may be used and distributed freely on the condition
// that it is distributed in full and unchanged, and that no fee is
// is charged for such use and distribution with the exception of
// reasonable shipping and/or media charges.
//
// Any or all portions of this program may also be incorporated
// into, or used by your own applications and be distributed
// along with your applications royalty-free on the condition
// that such application do not duplicate the overall functionality
// of vbHelper.
//
// This program was written by Jonathan Wood, SoftCircuits
// Programming, P.O. Box 16262, Irvine, CA 92713.
// CompuServe: 72134,263.
//

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include <vbapi.h>

struct MYREGS {
	int ax;
	int bx;
	int cx;
	int dx;
	int si;
	int di;
	int cflag;
	int ds;
	int es;
};


//
// Standard entry routine
//
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
{
	if(wHeapSize > 0)
		UnlockData(0);
	return 1;
}

//
// Returns a pointer to the specified control's MODEL structure
//
DWORD __export CALLBACK vbGetCtrlModel(HCTL hctl)
{
	return (DWORD)VBGetControlModel(hctl);
}

//
// Destroys the specified control and recreates it
//
int __export CALLBACK vbRecreateCtrl(HCTL hctl)
{
	// Return True if no error, else return False
	return VBRecreateControlHwnd(hctl) ? 0 : -1;
}

//--------------------------------------------------------------------//

//
// Calls an interrupt
//
void __export CALLBACK vbInterrupt(int intnum, struct MYREGS *inregs, struct MYREGS *outregs)
{
	union REGS iregs, oregs;

	// Copy register values to int86 format	
	iregs.x.ax = inregs->ax;
	iregs.x.bx = inregs->bx;
	iregs.x.cx = inregs->cx;
	iregs.x.dx = inregs->dx;
	iregs.x.si = inregs->si;
	iregs.x.di = inregs->di;
	iregs.x.cflag = inregs->cflag;
	
	int86(intnum,&iregs,&oregs);
	
	outregs->ax = oregs.x.ax;
	outregs->bx = oregs.x.bx;
	outregs->cx = oregs.x.cx;
	outregs->dx = oregs.x.dx;
	outregs->si = oregs.x.si;
	outregs->di = oregs.x.di;
	outregs->cflag = oregs.x.cflag;
}

//
// Calls an interrupt with support for ds and es
//
void __export CALLBACK vbInterruptX(int intnum, struct MYREGS *inregs, struct MYREGS *outregs)
{
	union REGS iregs, oregs;
	struct SREGS sregs;

	// Copy register values to int86x format	
	iregs.x.ax = inregs->ax;
	iregs.x.bx = inregs->bx;
	iregs.x.cx = inregs->cx;
	iregs.x.dx = inregs->dx;
	iregs.x.si = inregs->si;
	iregs.x.di = inregs->di;
	iregs.x.cflag = inregs->cflag;

	sregs.ds = inregs->ds;
	sregs.es = inregs->es;
	
	int86x(intnum,&iregs,&oregs,&sregs);
	
	outregs->ax = oregs.x.ax;
	outregs->bx = oregs.x.bx;
	outregs->cx = oregs.x.cx;
	outregs->dx = oregs.x.dx;
	outregs->si = oregs.x.si;
	outregs->di = oregs.x.di;
	outregs->cflag = oregs.x.cflag;

	outregs->ds = sregs.ds;
	outregs->es = sregs.es;
}

// OBSOLETE -- Use vbGetFullPath
//
// Makes an absolute path name from a relative path name
//
int __export CALLBACK vbFullPath(char *szFullPath, char *szPartialPath, int nMaxLen)
{
	char *ptr;

   // This one's easy, use the library routine
	ptr = _fullpath(szFullPath,szPartialPath,nMaxLen);

	// Return True if successful
	return (ptr == NULL) ? 0 : 0xFFFF;
}

//
// Makes an absolute path name from a relative path name 
// Returns a VB-compatible string
//
HLSTR __export CALLBACK vbGetFullPath(HLSTR hlstrPartialPath)
{              
	char *lpStr;
	HLSTR lpHlstr;

   // Use the VB string to get the full path
	lpStr = _fullpath(NULL,VBDerefZeroTermHlstr(hlstrPartialPath),0);

	if(lpStr != NULL)
		lpHlstr = VBCreateTempHlstr(lpStr,strlen(lpStr));
	else
		lpHlstr = VBCreateTempHlstr(NULL,0);
   
   // Free buffer allocated by _fullpath
	free(lpStr);
	
	return lpHlstr;
}

//
// Returns the segment portion of a variable address
//
WORD __export CALLBACK vbVarSeg(void *ptr)
{
	return HIWORD(ptr);
}

//
// Returns the offset portion of a variable address
//
WORD __export CALLBACK vbVarPtr(void *ptr)
{
	return LOWORD(ptr);
}

//
// Returns the offset portion of a variable address
//
DWORD __export CALLBACK vbGetLongPtr(void *ptr)
{
	return (DWORD)ptr;
}

//
// Copies data pointed to by lpSrc to the variable lpDest
//
void __export CALLBACK vbGetData(void *lpSrc,void *lpDest,int nCount)
{
	memmove(lpDest,lpSrc,nCount);
}

//
// Copies data from the variable lpSrc to memory pointed to by lpDest
//
void __export CALLBACK vbSetData(void *lpDest,void *lpSrc,int nCount)
{
	memmove(lpDest,lpSrc,nCount);
}


// Note: Since C doesn't support constants, we will
// declare these constants as near pointers
extern WORD __near *_0000h;
extern WORD __near *_A000h;
extern WORD __near *_B000h;
extern WORD __near *_C000h;
extern WORD __near *_D000h;
extern WORD __near *_E000h;
extern WORD __near *_F000h;

//
//
//
int GetSegmentSelector(WORD nSegment,WORD *nSelector,WORD *nOffset)
{
   switch(nSegment) {
		case 0x0000:
			*nSelector = (int)&_0000h;
			break;
		case 0x0040:
			*nSelector = (int)&_0000h;
			*nOffset += 0x0400;
			break;
		case 0xA000:
			*nSelector = (int)&_A000h;
			break;
		case 0xB000:
			*nSelector = (int)&_B000h;
			break;
		case 0xB800:
			*nSelector = (int)&_B000h;
			*nOffset += 0x8000;
			break;
		case 0xC000:
			*nSelector = (int)&_C000h;
			break;
		case 0xD000:
			*nSelector = (int)&_D000h;
			break;
		case 0xE000:
			*nSelector = (int)&_E000h;
			break;
		case 0xF000:
			*nSelector = (int)&_F000h;
			break;
		default:
			// Unsupported segment
			return FALSE;
	}
	return TRUE;
}


//
// Writes a byte to low memory
//
void __export CALLBACK vbPoke(WORD nSegment, WORD nOffset, int nValue)
{
	WORD nSelector;
	
	if(!GetSegmentSelector(nSegment,&nSelector,&nOffset))
		return;
	//
	_asm {
		mov	es,nSelector
		mov	bx,nOffset
		mov	ax,nValue
		mov	es:[bx],al
	}
}

//
// Writes a word to low memory
//
void __export CALLBACK vbPokew(WORD nSegment, WORD nOffset, int nValue)
{
	WORD nSelector;
	
	if(!GetSegmentSelector(nSegment,&nSelector,&nOffset))
		return;
	//
	_asm {
		mov	es,nSelector
		mov	bx,nOffset
		mov	ax,nValue
		mov	es:[bx],ax
	}
}

//
// Reads a byte from low memory
//
int __export CALLBACK vbPeek(WORD nSegment, WORD nOffset)
{
	WORD nSelector;
	int retval;

	if(!GetSegmentSelector(nSegment,&nSelector,&nOffset))
		return -1;
	//
	_asm {
		mov	es,nSelector
		mov	bx,nOffset
		mov	al,es:[bx]
		sub	ah,ah
		mov	retval,ax
	}
	return retval;
}

//
// Reads a word from low memory
//
int __export CALLBACK vbPeekw(WORD nSegment, WORD nOffset)
{
	WORD nSelector;
	int retval;

	if(!GetSegmentSelector(nSegment,&nSelector,&nOffset))
		return -1;
	//
	_asm {
		mov	es,nSelector
		mov	bx,nOffset
		mov	ax,es:[bx]
		mov	retval,ax
	}
	return retval;
}

//
// Writes a byte to the specified I/O port
//
void __export CALLBACK vbOut(int nPort, int nData)
{
	_asm {
		mov	dx,nPort
		mov	ax,nData
		out	dx,al
	}
}

//
// Writes a word to the specified I/O port
//
void __export CALLBACK vbOutw(int nPort, int nData)
{
	_asm {
		mov	dx,nPort
		mov	ax,nData
		out	dx,ax
	}
}

//
// Reads a byte from the specified I/O port
//
int __export CALLBACK vbInp(int nPort)
{
	int retval;

	_asm {
		mov	dx,nPort
		in		al,dx
		sub	ah,ah
		mov	retval,ax
	}
	return retval;
}

//
// Reads a word from the specified I/O port
//
int __export CALLBACK vbInpw(int nPort)
{
	int retval;

	_asm {
		mov	dx,nPort
		in		ax,dx
		mov	retval,ax
	}
	return retval;
}

//--------------------------------------------------------------------//

