VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "Searchable Listbox Class Demo"
   ClientHeight    =   6405
   ClientLeft      =   1095
   ClientTop       =   1515
   ClientWidth     =   5850
   Height          =   6810
   Left            =   1035
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   6405
   ScaleWidth      =   5850
   Top             =   1170
   Width           =   5970
   Begin VB.ListBox List2 
      Height          =   5130
      Left            =   2970
      Sorted          =   -1  'True
      TabIndex        =   3
      Top             =   540
      Width           =   2535
   End
   Begin VB.ListBox List1 
      Height          =   5130
      Left            =   180
      Sorted          =   -1  'True
      TabIndex        =   1
      Top             =   540
      Width           =   2535
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&System Directory:"
      Height          =   195
      Left            =   2970
      TabIndex        =   2
      Top             =   270
      Width           =   1230
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "&Windows Directory:"
      Height          =   195
      Left            =   180
      TabIndex        =   0
      Top             =   270
      Width           =   1380
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
'
' Windows API Declarations
'
#If Win32 Then
   Private Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
   Private Declare Function GetSystemDirectory Lib "kernel32" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
#ElseIf Win16 Then
   Private Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
   Private Declare Function GetSystemDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
#End If
'
' Create searchable listbox objects
'
Private cLstWin As New CListSearch
Private cLstSys As New CListSearch

Private Sub Form_Load()
   Dim path As String
   Dim file As String
   Dim nRet As Long
   '
   ' Fill List1 with \Windows files.
   '
   path = Space(256)
   nRet = GetWindowsDirectory(path, Len(path))
   file = Dir(Left(path, nRet) & "\*.*")
   Do While Len(file)
      List1.AddItem file
      file = Dir()
   Loop
   Label1.Caption = Left(path, nRet)
   '
   ' Fill List2 with \Windows\System files.
   '
   path = Space(256)
   nRet = GetSystemDirectory(path, Len(path))
   file = Dir(Left(path, nRet) & "\*.*")
   Do While Len(file)
      List2.AddItem file
      file = Dir()
   Loop
   Label2.Caption = Left(path, nRet)
   '
   ' Setup searchable listbox objects
   '
   Set cLstWin.Client = List1
   Set cLstSys.Client = List2
   '
   ' Center form
   '
   Me.Move (Screen.Width - Me.Width) \ 2, (Screen.Height - Me.Height) \ 2
End Sub

Private Sub Form_Resize()
   '
   ' Resize listbox to fit form.
   '
   List1.Move List1.Left, List1.Top, Me.ScaleWidth \ 2 - List1.Left * 2, Me.ScaleHeight - List1.Top - List1.Left
   List2.Move List1.Left * 3 + List1.Width, List1.Top, List1.Width, List1.Height
   Label2.Left = List2.Left
End Sub

Private Sub List1_KeyPress(KeyAscii As Integer)
   '
   ' Allow class module to do all the work!
   '
   KeyAscii = cLstWin.KeyPress(KeyAscii)
End Sub

Private Sub List2_KeyPress(KeyAscii As Integer)
   '
   ' Allow class module to do all the work!
   '
   KeyAscii = cLstSys.KeyPress(KeyAscii)
End Sub

