
// File : IMPLCALL.C
// this program demonstrates implicit importing of functions in a DLL
// implicit linking is accomplished via an IMPORT library, produced
// by a call to the import librarian, IMPLIB
#include <windows.h>
#include "testdll.h"

char name[] = "implcall";

long FAR PASCAL _export MainWndProc( HWND hWnd, WORD msg, 
WORD wParam, LONG lParam )
{
    switch( msg )
    {
	case WM_COMMAND :
	    switch( wParam )
	    {
		case 101 :
		    TestFunc( hWnd );
		    return 0;
		default :
		    break;
	    }
	    break;
	case WM_DESTROY :
	    PostQuitMessage( 0 );
	    return 0;
	default :
	    break;
    }
    return DefWindowProc( hWnd, msg, wParam, lParam );
}

BOOL InitApplication( HANDLE hInst )
{
    WNDCLASS wcTemp;

    wcTemp.style = 0;
// For compilers prior to BC++ 3.1 and TCW 3.1 use a (FARPROC) cast instead.
    wcTemp.lpfnWndProc = (WNDPROC)MainWndProc;
    wcTemp.cbClsExtra = 0;
    wcTemp.cbWndExtra = 0;
    wcTemp.hInstance = hInst;
    wcTemp.hIcon = LoadIcon( 0, IDI_APPLICATION );
    wcTemp.hCursor = LoadCursor( 0, IDC_ARROW );
    wcTemp.hbrBackground = COLOR_WINDOW + 1;
    wcTemp.lpszMenuName = name;
    wcTemp.lpszClassName = name;
    if( !RegisterClass( &wcTemp ) ) return FALSE;
    return TRUE;
}

BOOL InitInstance( HANDLE hInst, int nCmdShw )
{
    HWND hWndTemp;

    hWndTemp = CreateWindow
    (
	name, __FILE__,
	WS_OVERLAPPEDWINDOW,
	CW_USEDEFAULT, CW_USEDEFAULT,
	CW_USEDEFAULT, CW_USEDEFAULT,
	0, 0,
	hInst, NULL
	);
    if( !hWndTemp ) return FALSE;
    ShowWindow( hWndTemp, nCmdShw );
    UpdateWindow( hWndTemp );
    return TRUE;
}

int PASCAL WinMain( HANDLE hInst, HANDLE hPrvInst, LPSTR lpCmdLn, int nCmdShw )
{
    MSG msgTemp;

    if( lpCmdLn [0] != '\0' )
    {
	MessageBox( 0, "Command line ignored!", __FILE__, MB_ICONINFORMATION );
    }
    if( (!hPrvInst) && (!InitApplication( hInst )) ) return FALSE;
    if( !InitInstance( hInst, nCmdShw ) ) return FALSE;
    while( GetMessage( &msgTemp, 0, 0, 0 ) )
    {
	TranslateMessage( &msgTemp );
	DispatchMessage( &msgTemp );
    }
    return msgTemp.wParam;
}

