'The WinHelp function types dwData as Any. It is safer to Alias the function for each possible type, in this case, long
'and string. This idea is per Dan Appleman in his book "VB Programmer's Guide to the Windows API."

'Declare Function WinHelp Lib "User" (ByVal hWnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, dwData As Any) As Integer

Declare Function WinHelpByNum% Lib "User" Alias "WinHelp" (ByVal hWnd%, ByVal lpHelpFile$, ByVal wCommand%, ByVal dwData&)
Declare Function WinHelpByStr% Lib "User" Alias "WinHelp" (ByVal hWnd%, ByVal lpHelpFile$, ByVal wCommand%, ByVal dwData$)

'---------------------------------------------
'WinHelp Constants  NOTE: If dwData is not used, use the ByNum version of WinHelp and pass 0 as the parameter value.
'----------------------------------------------
Global Const HELP_COMMAND = &H102    ' Execute Help macro. dwData = macro (string)
Global Const HELP_CONTENTS = &H3     ' Display Help for a particular topic. dwData not used
Global Const HELP_CONTEXTPOPUP = &H8 ' Display Help topic in popup window. dwData = context number of topic (long)
Global Const HELP_CONTEXT = &H1      ' Display topic. dwData = context number of topic (long)
Global Const HELP_FORCEFILE = &H9    ' Ensure correct Help file is displayed. dwData not used
Global Const HELP_HELPONHELP = &H4   ' Display help on using help. dwData not used
Global Const HELP_KEY = &H101        ' Display topic for keyword. dwData = keyword (string)
Global Const HELP_MULTIKEY = &H201   ' Displays topic from an alternate keyword table. dwData = pointer to a MULTIKEYHELP structure
Global Const HELP_QUIT = &H2         ' Terminate help. dwData not used
Global Const HELP_PARTIALKEY = &H105 ' Display topic found in keyword list. dwData = keyword (string)
Global Const HELP_SETCONTENTS = &H5  ' Display Help contents topic. dwData not used
Global Const HELP_SETWINPOS = &H203  ' Display and position Help window. dwData = pointer to a HELPWININFO structure
                                 

