// dda.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CDDA document

class CDDA : public CObject
{
public:
    CDDA(int iFirst, int iLast, int iSteps);
    ~CDDA();

// Attributes
public:

// Operations
public:
    int Next();

// Implementation
private:
    int m_iFirst;            // the first value
    int m_iLast;             // the last value
    int m_iSteps;            // number of steps to take
    int m_iCurrent;          // the current value
    int m_iInc;              // the basic increment
    int m_iAdd;
    int m_iSub;
    int m_iDelta;
    int m_iErr;
};

inline int CDDA::Next()
{
    int iResult;

    iResult = m_iCurrent;

    m_iCurrent += m_iInc;
    m_iErr  -= m_iSub;

    if (m_iErr <= 0) {
        m_iErr  += m_iAdd;
        m_iCurrent += m_iDelta;
    }

    return iResult;
}
