//***************************************************************************
// tutor.cpp - My First PowerCode App
// 4/22/92 - 6:24:12pm
// John Doe
//***************************************************************************
#include <owl.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <dialog.h>
#include <listbox.h>
#include <edit.h>
#include <radiobut.h>
#include <checkbox.h>
#include <combobox.h>
#include <listbox.h>
#include "Tutor.h"				// Resource Constants
#include "Tutor.hpp"				// Main App Class Definitions
#include "jtools.hpp"				// Module Class Definitions

//
// Member Functions - Main 
//
// Window Constructor
Main::Main(PTWindowsObject AParent) 
: TWindow(AParent, "My First PowerCode App")
{

	// Create ToolBar - This is a child window so OWL will delete
	PTToolBar pTB = new TToolBar(this, 44);	
	pTB->ToolItems->add(* new TToolItem(this, "Button", CM_MAINAPP, -1, -1, 45, 45, 
		 "NMainApp", "SMainApp", "Y", "Y"));
	pTB->ToolItems->add(* new TToolItem(this, "Button", CM_MAINDIALOG, 43, -1, 45, 45, 
		 "NMainDialog", "SMainDialog", "Y", "Y"));
	pTB->ToolItems->add(* new TToolItem(this, "Button", CM_MAINWINDOW, 87, -1, 45, 45, 
		 "NMainWindow", "SMainWindow", "Y", "Y"));
	pTB->ToolItems->add(* new TToolItem(this, "Checkbox", CM_MAINCHECKBOX, 134, 2, 40, 40, 
		 "NMainCheckBox", "SMainCheckBox", "N", "N"));
}
//
// GetWindowClass - Allows a new window class to be defined 
//
void Main::GetWindowClass(WNDCLASS& AWndClass)
{
	TWindow::GetWindowClass(AWndClass);
	AWndClass.hbrBackground = CreateSolidBrush(RGB(255,255,128));
	AWndClass.hIcon = LoadIcon(GetApplication()->hInstance, "Main");
}
//
//	SetupWindow - Initialization stuff requiring a window handle
//
void Main::SetupWindow()
{
	AssignMenu("Main");

	TWindowsObject::SetupWindow();	// will setup child windows
}
//
// Window Response functions
//
void Main::MsgMainApp(RTMessage )
{
	WinExec("notepad.exe tutor.txt", SW_SHOW);
}
void Main::MsgMainDialog(RTMessage )
{
	PAddress pDlg = new Address(this, "ADDRESS");
	GetApplication()->MakeWindow(pDlg);
	pDlg->Show(SW_SHOW);
}
void Main::MsgMainWindow(RTMessage )
{
	PTWindow pWin = new NewWin(this);
	GetApplication()->MakeWindow(pWin);
	pWin->Show(SW_SHOW);
}
void Main::MsgNew(RTMessage )
{
	PTWindow pWin = new NewWin(this);
	GetApplication()->MakeWindow(pWin);
	pWin->Show(SW_SHOW);
}
void Main::MsgOpen(RTMessage )
{
	MessageBox(HWindow, "User Clicked on Item: &Open", "Info", 
	   MB_OK | MB_ICONINFORMATION);
}
void Main::MsgSave(RTMessage )
{
	MessageBox(HWindow, "User Clicked on Item: &Save", "Info", 
	   MB_OK | MB_ICONINFORMATION);
}
void Main::MsgExit(RTMessage )
{
	MessageBox(HWindow, "User Clicked on Item: &Exit", "Info", 
	   MB_OK | MB_ICONINFORMATION);
}
void Main::MsgAbout(RTMessage )
{
	GetApplication()->ExecDialog(new About(this, "ABOUT") );
}
//
// CloseWindow - Close Window and Update Data
//
void Main::CloseWindow()
{
	if ( CanClose() )	// Update Window if OK
	{
		TWindow::CloseWindow();	// Finish the CloseWindow
	}
}


//
// Member Functions - NewWin 
//
// Window Constructor
NewWin::NewWin(PTWindowsObject AParent) 
: TWindow(AParent, "")
{
	Attr.Style = WS_OVERLAPPEDWINDOW|WS_VISIBLE;

}
//
// GetWindowClass - Allows a new window class to be defined 
//
void NewWin::GetWindowClass(WNDCLASS& AWndClass)
{
	TWindow::GetWindowClass(AWndClass);
}
//
//	SetupWindow - Initialization stuff requiring a window handle
//
void NewWin::SetupWindow()
{

	TWindowsObject::SetupWindow();	// will setup child windows
}
//
// Window Response functions
//
//
// CloseWindow - Close Window and Update Data
//
void NewWin::CloseWindow()
{
	if ( CanClose() )	// Update Window if OK
	{
		TWindow::CloseWindow();	// Finish the CloseWindow
	}
}


//
// Dialog Member Functions - About 
//
About::About(PTWindowsObject AParent, Pchar DlgName) : TDialog(AParent, DlgName)
{
}
//
//	SetupWindow - Initialize controls, anything requiring win handle
//
void About::SetupWindow()
{
	TWindowsObject::SetupWindow();	// will setup child windows
}
//
// Dialog Response functions - About
//
//
// CanClose - Determine if dialog should be allowed to update
//
BOOL About::CanClose()
{
	return TRUE;
}
//
// CloseWindow - Close Window and Update Data
//
void About::CloseWindow(int ARetValue)
{
	if ( ARetValue == IDOK && CanClose() ) // Update Dialog
	{
		
		TDialog::CloseWindow(ARetValue);	// Finish the CloseWindow
	}
}
//
// Dialog Member Functions - Address 
//
Address::Address(PTWindowsObject AParent, Pchar DlgName) : TDialog(AParent, DlgName)
{
	Lname = new TEdit(this, ID_LNAME, 30);
	Name = new TEdit(this, ID_NAME, 0);
	Title = new TEdit(this, ID_TITLE, 0);
	Coname = new TEdit(this, ID_CONAME, 0);
	Street1 = new TEdit(this, ID_STREET1, 0);
	Street2 = new TEdit(this, ID_STREET2, 0);
	City = new TEdit(this, ID_CITY, 0);
	State = new TEdit(this, ID_STATE, 0);
	Zip = new TEdit(this, ID_ZIP, 0);
	Bphone = new TEdit(this, ID_BPHONE, 0);
	Hphone = new TEdit(this, ID_HPHONE, 0);
	Fax = new TEdit(this, ID_FAX, 0);
	Comments = new TEdit(this, ID_COMMENTS, 0);
	Addtype = new TComboBox(this, ID_ADDTYPE, 0);
	Male = new TRadioButton(this, ID_MALE, NULL);
	Female = new TRadioButton(this, ID_FEMALE, NULL);
}
//
//	SetupWindow - Initialize controls, anything requiring win handle
//
void Address::SetupWindow()
{
	TWindowsObject::SetupWindow();	// will setup child windows
	Female->SetCheck(TRUE);	 // Set Initial Check
	// Fill Combo with initial values
	Addtype->AddString("Employee");
	Addtype->AddString("Vendor");
	Addtype->AddString("Friend");
	Addtype->AddString("Other");
}
//
// Dialog Response functions - Address
//
void Address::MsgSearch(RTMessage )
{
	GetApplication()->ExecDialog(new Search(this, "SEARCH") );
}
//
// CanClose - Determine if dialog should be allowed to update
//
BOOL Address::CanClose()
{
	if ( Lname->GetTextLen() == 0 )
	{
		MessageBox(HWindow, "Mandatory field requires input.", "Error", 
	  	 MB_OK | MB_ICONEXCLAMATION);
		SetFocus(Lname->HWindow);	 // Position cursor to error
		return FALSE;
	}
	return TRUE;
}
//
// CloseWindow - Close Window and Update Data
//
void Address::CloseWindow(int ARetValue)
{
	if ( ARetValue == IDOK && CanClose() ) // Update Dialog
	{
		
		TDialog::CloseWindow(ARetValue);	// Finish the CloseWindow
	}
}
//
// Dialog Member Functions - Search 
//
Search::Search(PTWindowsObject AParent, Pchar DlgName) : TDialog(AParent, DlgName)
{
	List = new TListBox(this, ID_LIST, NULL);
}
//
//	SetupWindow - Initialize controls, anything requiring win handle
//
void Search::SetupWindow()
{
	TWindowsObject::SetupWindow();	// will setup child windows
}
//
// Dialog Response functions - Search
//
//
// CanClose - Determine if dialog should be allowed to update
//
BOOL Search::CanClose()
{
	return TRUE;
}
//
// CloseWindow - Close Window and Update Data
//
void Search::CloseWindow(int ARetValue)
{
	if ( ARetValue == IDOK && CanClose() ) // Update Dialog
	{
		
		TDialog::CloseWindow(ARetValue);	// Finish the CloseWindow
	}
}
//
//	Application Member Functions
//
void TutorApp::InitMainWindow()
{
		MainWindow = new Main(NULL);
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{
	TutorApp TutorApp("My First PowerCode App", hInstance, hPrevInstance,
		lpCmd, nCmdShow);
	TutorApp.Run();
	return TutorApp.Status;
}
