///////////////////////////////////////////////////////////
//  Program Name: Combo1.cpp
//  Programmer: Charlie Calvert                                        
//  Description: Dropdown ComboBox windows Example
//  Date: 12/19/93
///////////////////////////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma warning (disable: 4068)
// -------------------------------------------------------
// Interface
// -------------------------------------------------------

LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);

// Controls IDs
#define ID_LISTBOX 101
#define ID_FILLBTN 102

// Declarations for class Combo1
#define Combo1_DefProc    DefWindowProc
BOOL Combo1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct);
void Combo1_OnDestroy(HWND hwnd);
void Combo1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
static char szAppName[] = "Combo1";
static HWND MainWindow;
static HINSTANCE hInstance;


// -------------------------------------------------------
// Initialization
// -------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;
  
  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;  

  while (GetMessage(&Msg, NULL, 0, 0))
  {
    TranslateMessage(&Msg);
    DispatchMessage(&Msg);
  } 

  return Msg.wParam;
}


//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style      	 = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc	 = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName	 = NULL;
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}


//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, Combo1_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, Combo1_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, Combo1_OnCommand);
    default: return Combo1_DefProc(hwnd, Message, wParam, lParam);
  }
}


//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL Combo1_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  CreateWindow("button", "Fill ListBox",
               WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON,
               10, 7, 203, 38, hwnd, HMENU(ID_FILLBTN),
               hInstance, NULL);

  CreateWindow("combobox", NULL,
               WS_CHILD | WS_VISIBLE | CBS_DROPDOWN,
               12, 50, 201, 180, hwnd, HMENU(ID_LISTBOX),
               hInstance, NULL);

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void Combo1_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void Combo1_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  static char *List[7] = {"Sam", "Mike", "Anne", "Mary",
                          "David", "LouAnne", "Lisa"};

  char S[100];

  switch (id)
  {
    case ID_FILLBTN:
    {
      for (int i = 0; i < 7; i++)
        ComboBox_AddString(GetDlgItem(hwnd, ID_LISTBOX), List[i]);
    }
    break;

    case ID_LISTBOX:
      if (codeNotify == LBN_SELCHANGE)
      {
        HWND ListWnd = GetDlgItem(hwnd, ID_LISTBOX);
        int index = ComboBox_GetCurSel(ListWnd);
        ComboBox_GetLBText(ListWnd, index, S);
        MessageBox(hwnd, S, "You selected", MB_OK | MB_ICONINFORMATION);
      }
    break;
  }
}