//////////////////////////////////////
//  Program Name: EASYTEXT.CPP
//  Programmer: Charlie Calvert
//  Description: Demonstrate simple text I/O
//  Date: Feb 27, 1993
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#pragma warning (disable: 4068)
#pragma warning (disable:4100)

// -------------------------------------------
// Interface
// -------------------------------------------

// variables
static char szAppName[] = "EasyText";

// Class EasyText
#define EasyText_DefProc DefWindowProc
BOOL EasyText_OnCreate(HWND hwnd,
                       CREATESTRUCT FAR* lpCreateStruct);
void EasyText_OnDestroy(HWND hwnd);
void EasyText_OnPaint(HWND hwnd);
 
// variables
char Directions[100];
static HWND MainWindow;
static HINSTANCE hInst;
 
// functions
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                                 WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);
 
// ----------------------------------------
// Initialization
// ----------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  if (!Create(hInst, nCmdShow))
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName   = NULL;
  WndClass.lpszClassName  = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInstance, int nCmdShow)
{
  HWND hwnd = CreateWindow(szAppName, szAppName,
                           WS_OVERLAPPEDWINDOW,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           NULL, NULL, hInstance, NULL);

  if (hwnd == NULL)
     return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------
// WndProc and Implementation
// ------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                                 WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, EasyText_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, EasyText_OnDestroy);
    HANDLE_MSG(hwnd, WM_PAINT, EasyText_OnPaint);
    default:
      return EasyText_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// The destructor handles WM_DESTROY
//////////////////////////////////////
#pragma argsused
BOOL EasyText_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  strcpy(Directions, "Try resizing this window.");
  return TRUE;
}

//////////////////////////////////////
// The destructor handles WM_DESTROY
//////////////////////////////////////
#pragma argsused
void EasyText_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_PAINT messages
// Show how to use TextOut and DrawText.
//////////////////////////////////////
void EasyText_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;
  RECT Rect;

  HDC PaintDC = BeginPaint(hwnd, &PaintStruct);

  TextOut(PaintDC, 10, 10, Directions, lstrlen(Directions));

  GetClientRect(hwnd, &Rect);

  DrawText(PaintDC, "The middle of the road", -1, &Rect,
           DT_SINGLELINE | DT_CENTER | DT_VCENTER);

  EndPaint(hwnd, &PaintStruct);
 }
