// ====================================================
// Program Name: EMERSON
// Programmer: Charlie Calvert
// Description: Part 1 of 2 part exploration of resources
// ======================================================

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include "Emerson.h"
#pragma warning (disable : 4068)
#pragma warning (disable : 4100)

static char szAppName[] = "Emerson";
static HINSTANCE hInstance;
static HANDLE hResource;

int ScrollWidth;
int MaxLines  = 21;
int Start = 33;
int TextHeight;
int PageSize;
int nPosition = 0;

// ===============================================
// INITIALIZATION
// ===============================================

//////////////////////////////////////
// The WinMain function is the program entry point.
// Register the Window, Create it, enter the Message Loop.
// If either of the first two steps fail, then quit
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  if (!Create(hInst, nCmdShow))
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}


//////////////////////////////////////
//Register Window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(hInst, "Icon");
  WndClass.hCursor        = LoadCursor(hInst, "Cursor");
  WndClass.hbrBackground  = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName   = "Menu";
  WndClass.lpszClassName  = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window and show it.
//////////////////////////////////////
BOOL Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                           WS_OVERLAPPEDWINDOW,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return FALSE;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return TRUE;
}

//=================================================
// IMPLEMENTATION
//=================================================

//////////////////////////////////////
// The window proc helps control the program at runtime
//////////////////////////////////////
LRESULT CALLBACK __export WndProc(HWND hwnd, UINT Message,
                                  WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, Emerson_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, Emerson_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, Emerson_OnCommand);
    HANDLE_MSG(hwnd, WM_PAINT, Emerson_OnPaint);
    default: return Emerson_DefProc(hwnd, Message, wParam, 
lParam);
  }
}

//////////////////////////////////////
// Create Window
// Load the Bitmap from resource
//////////////////////////////////////
#pragma argsused
BOOL Emerson_OnCreate(HWND hwnd, CREATESTRUCT FAR* 
lpCreateStruct)
{
  hResource = LoadResource(hInstance,
              FindResource(hInstance, "Brahma", "TEXT"));
  return TRUE;
}

//////////////////////////////////////
// Destructor
// Delete Bitmap from memory
//////////////////////////////////////
#pragma argsused
void Emerson_OnDestroy(HWND hwnd)
{
  FreeResource(hResource);
  PostQuitMessage(0);
}


//////////////////////////////////////
//  The Emerson Dialog Procedure controls the dialog
//////////////////////////////////////
#pragma argsused
void Emerson_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT 
codeNotify)
{
  switch(id)
  {
    case CM_ABOUT:
      NotYetAvailable(hwnd);
      break;

    case CM_BITMAP:
      NotYetAvailable(hwnd);
      break;

    case CM_BRAHMIN:
      NotYetAvailable(hwnd);
      break;

    case CM_WOODNOTES:
      NotYetAvailable(hwnd);
      break;

    case CM_SEASHORE:
      NotYetAvailable(hwnd);
      break;
  }
}

//////////////////////////////////////
// Handle WM_PAINT
// Paint a bunch of copies of TheBitmap
//////////////////////////////////////
void Emerson_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;
  char far *Poem;
  RECT Rect;

  HDC PaintDC = BeginPaint(hwnd, &PaintStruct);

  Poem = (char far *)LockResource(hResource);
  GetClientRect(hwnd, &Rect);
  Rect.left += 10;
  Rect.top += 10;
  DrawText(PaintDC, Poem, -1, &Rect, DT_EXTERNALLEADING);
  GlobalUnlock(hResource);

  EndPaint(hwnd, &PaintStruct);
}

//////////////////////////////////////
// NotYetAvailable
//////////////////////////////////////
void NotYetAvailable(HWND hwnd)
{
  MessageBox(hwnd, "Not yet available", "Under Construction", 
MB_OK);
}
