// =============================================
// Program Name: EMERSON2
// Programmer: Charlie Calvert
// Description: Example program with string table,
//              dialog and bitmap
// =============================================

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <string.h>
#include "Emerson2.h"
#pragma warning (disable : 4100)
#pragma warning (disable : 4068)
static char szAppName[] = "Emerson2";
static HINSTANCE hInstance;

int MaxLines  = 21;
int Start = 32;
int TextHeight;
int PageSize = 10;
int nPosition = 0;
BOOL DrawBitmaps = TRUE;

// ==============================================
// INITIALIZATION
// ==============================================

//////////////////////////////////////
// The WinMain function is the program entry point.
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  if (!Create(hInst, nCmdShow))
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}


//////////////////////////////////////
// Register Window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(hInst, "Emerson2");
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName   = "MENU_1";
  WndClass.lpszClassName  = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window and show it.
//////////////////////////////////////
BOOL Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                           WS_OVERLAPPEDWINDOW | WS_VSCROLL,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return FALSE;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return TRUE;
}

//==============================================
// IMPLEMENTATION
//==============================================

//////////////////////////////////////
// The window proc helps control the
// program while it is running
//////////////////////////////////////
LRESULT CALLBACK __export WndProc(HWND hwnd, UINT Message,
                                  WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, Emerson_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, Emerson_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, Emerson_OnCommand);
    HANDLE_MSG(hwnd, WM_KEYDOWN, Emerson_OnKey);
    HANDLE_MSG(hwnd, WM_PAINT, Emerson_OnPaint);
    HANDLE_MSG(hwnd, WM_VSCROLL, Emerson_OnVScroll);
    default:
      return Emerson_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Create Window
// Load the Bitmap from resource
//////////////////////////////////////
#pragma argsused
BOOL Emerson_OnCreate(HWND hwnd, CREATESTRUCT FAR* 
lpCreateStruct)
{
  TEXTMETRIC TextMetrics;

  TheBitmap = LoadBitmap(hInstance, "Bitmap");
  if (!TheBitmap)
  {
    MessageBox(hwnd, "No Bitmap", "Fatal Error", MB_OK);
    return FALSE;
  }

  HDC PaintDC = GetDC(hwnd);
  GetTextMetrics(PaintDC, &TextMetrics);
  ReleaseDC(hwnd, PaintDC);
  TextHeight = TextMetrics.tmHeight +
               TextMetrics.tmExternalLeading;

  SetScrollRange(hwnd,  SB_VERT, 0,
                 MaxLines - Start, FALSE);

  return TRUE;
}

//////////////////////////////////////
// Destructor: Delete Bitmap from memory
//////////////////////////////////////
#pragma argsused
void Emerson_OnDestroy(HWND hwnd)
{
  DeleteBitmap(TheBitmap);
  PostQuitMessage(0);
}

//////////////////////////////////////
//  The Emerson2 Dialog Procedure controls the dialog
//////////////////////////////////////
#pragma argsused
void Emerson_OnCommand(HWND hwnd, int id,
                       HWND hwndCtl, UINT codeNotify)
{
  switch(id)
  {
    case CM_ABOUT:
    {
      FARPROC AboutBox =
          MakeProcInstance((FARPROC)AboutDlgProc, 
hInstance);
      DialogBox(hInstance, "About",
                hwnd, (DLGPROC)AboutBox);
      FreeProcInstance(AboutBox);
      break;
    }

    case CM_BRAHMIN:
      Start = 32;
      MaxLines = 22;
      InvalidateRect(hwnd, NULL, TRUE);
      DrawBitmaps = FALSE;
      break;

    case CM_WOODNOTES:
      Start = 0;
      MaxLines = 32;
      InvalidateRect(hwnd, NULL, TRUE);
      DrawBitmaps = FALSE;
      break;

    case CM_SEASHORE:
      Start = 64;
      MaxLines = 37;
      InvalidateRect(hwnd, NULL, TRUE);
      DrawBitmaps = FALSE;
      break;

    case CM_DRAWBITMAPS:
      DrawBitmaps = TRUE;
      InvalidateRect(hwnd, NULL, TRUE);
      break;
  }
}

//////////////////////////////////////
// Handle WM_KEYDOWN to aid in scrolling poems
//////////////////////////////////////
#pragma argsused
void Emerson_OnKey(HWND hwnd, UINT vk, BOOL fDown, int 
cRepeat, UINT flags)
{
  switch(vk)
  {
    case VK_HOME:
      SendMessage(hwnd, WM_VSCROLL, SB_TOP, 0L);
      break;

    case VK_DOWN:
      SendMessage(hwnd, WM_VSCROLL, SB_LINEDOWN, 0L);
      break;

    case VK_UP:
      SendMessage(hwnd, WM_VSCROLL, SB_LINEUP, 0L);
      break;
  }
}

//////////////////////////////////////
// Handle WM_PAINT: Paint TheBitmap and poems
//////////////////////////////////////
void Emerson_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;
  SIZE L;
  int NumImages = 15;
  char S[101];
  int Y = 0;

  HDC PaintDC = BeginPaint(hwnd, &PaintStruct);


  if (DrawBitmaps)
  {
    HDC BitmapDC = CreateCompatibleDC(PaintDC);
    HBITMAP OldBitmap = SelectBitmap(BitmapDC, TheBitmap);
    for (int i = 0; i < NumImages; i++)
      for (int j = 0; j < NumImages; j++)
        BitBlt(PaintDC, i * 66, j * 66, 64, 64,
               BitmapDC, 0, 0, SRCCOPY);
    SelectBitmap(BitmapDC, OldBitmap);
    DeleteDC(BitmapDC);
  }
  else
  {
    HPEN APen = CreatePen(PS_NULL, 0, 0);
    HPEN SavePen = SelectPen(PaintDC, APen);
    for (int i = nPosition; i < MaxLines; i++)
    {
      LoadString(hInstance, i + Start, S, 100);
      TextOut(PaintDC, 1, Y, S, strlen(S));
      GetTextExtentPoint(PaintDC, S, strlen(S), &L);
      if (L.cx == 0)
        Rectangle(PaintDC, 1, Y, 400, Y + 1 + TextHeight);
      else
        Rectangle(PaintDC, L.cx, Y,
                  L.cx + 200, Y + 1 + TextHeight);
      Y += TextHeight;
    }
    Rectangle(PaintDC, 1, Y, 400, Y + 1 + 400);
    SelectPen(PaintDC, SavePen);
    DeleteObject(APen);
  }
  EndPaint(hwnd, &PaintStruct);
}

//////////////////////////////////////
// Handle WM_VSCROL: Aid in scrolling poems
//////////////////////////////////////
#pragma argsused
void Emerson_OnVScroll(HWND hwnd, HWND hwndCtl, UINT code, int pos)
{
  switch(code)
  {
    case SB_TOP:
      nPosition = 0;
      break;

    case SB_BOTTOM:
      nPosition = MaxLines;
      break ;

    case SB_LINEUP:
      if (nPosition > 0) nPosition -= 1 ;
      break ;

    case SB_LINEDOWN:
      if (nPosition < MaxLines) nPosition += 1 ;
      break ;

    case SB_PAGEUP:
      nPosition -= PageSize;
      break ;

    case SB_PAGEDOWN:
      nPosition += PageSize;
      break ;

    case SB_THUMBPOSITION:
      nPosition = pos;
      break;
  }
  nPosition = max(0, min (nPosition, MaxLines - 1)) ;
  SetScrollPos (hwnd, SB_VERT, nPosition, TRUE) ;
  InvalidateRect (hwnd, NULL, FALSE);
}

// ------------------------------------------
// Emerson Dialog
// ------------------------------------------
 
/////////////////////////////////////////////
//  The Emerson Dialog Procedure
/////////////////////////////////////////////
#pragma argsused
BOOL CALLBACK _export AboutDlgProc(HWND hDlg, UINT Message,
                            WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    case WM_INITDIALOG:
      return TRUE;
 
    case WM_COMMAND:
      if (LOWORD(wParam) == IDOK ||
              LOWORD(wParam) == IDCANCEL)
      {
        EndDialog(hDlg, IDOK);
        return TRUE;
      }
      break;
  }
  return FALSE;
}
