//////////////////////////////////////
//  Program Name: FILEBOX.CPP
//  Programmer: Charlie Calvert
//  Description: FileBox windows program
//  Date: 06/28/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma warning (disable: 4068)
#pragma hdrstop
#include <direct.h>
#include <string.h>
#include "filebox.h"

// ---------------------------------------------
// Interface
// ---------------------------------------------

// Variables
static char szAppName[] = "FileBox";
static HWND MainWindow;
static HINSTANCE hInstance;

char *ButtonText[] = {"&Drives", "D&irectories", "&Files"};
char *BmpName[] = {"DRIVES", "DIRS", "FILES"};
WORD DirShowVal[] = {DDL_DRIVES | DDL_EXCLUSIVE, DDL_DIRECTORY
                     | DDL_EXCLUSIVE, DDL_ARCHIVE};
HWND hControl[8];
HBITMAP Bmp[3];
HWND PathWin;
FARPROC lpfnNewEditProc;
char FilesWildCard[100];

// --------------------------------------------------------
// Initialization
// --------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  MSG  Msg;


  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  SetMessageQueue(20);

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
    if (!IsDialogMessage(MainWindow, &Msg))
    {
      TranslateMessage(&Msg);
      DispatchMessage(&Msg);
    }
  }
  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName  = NULL;
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU |
                    WS_MINIMIZEBOX | WS_THICKFRAME,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                      NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                            WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, CopyAll_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, FileBox_OnDestroy);
    HANDLE_MSG(hwnd, WM_CLOSE, FileBox_OnClose);
    HANDLE_MSG(hwnd, WM_COMMAND, FileBox_OnCommand);
    HANDLE_MSG(hwnd, WM_GETMINMAXINFO, FileBox_OnGetMinMaxInfo);
    HANDLE_MSG(hwnd, WM_PAINT, FileBox_OnPaint);
    HANDLE_MSG(hwnd, WM_PARENTNOTIFY, FileBox_OnParentNotify);
    HANDLE_MSG(hwnd, WM_RBUTTONDOWN, FileBox_OnRButtonDown);
    default:
      return FileBox_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Create the Callback procedures
//////////////////////////////////////
void MakeCallBackProcs()
{
  lpfnNewEditProc =
    MakeProcInstance(FARPROC(NewEditProc), hInstance);

  OldEditProc = (WNDPROC)SetWindowLong(hControl[ID_EDIT],
                           GWL_WNDPROC, LONG(lpfnNewEditProc));
}

//////////////////////////////////////
// Handle WM_Create
//////////////////////////////////////
#pragma argsused
BOOL CopyAll_OnCreate(HWND hwnd, CREATESTRUCT FAR* 
lpCreateStruct)
{

  for (int i = 0; i < 3; i++)
  {
    Bmp[i] = LoadBitmap(hInstance, BmpName[i]);
    if (!Bmp[i])
    {
      MessageBox(hwnd, "No Bitmap", "Fatal Error", MB_OK);
      return FALSE;
    }
  }

  hControl[ID_FILELIST] = CreateWindow("listbox", NULL,
                     WS_CHILD | WS_VISIBLE |
                     LBS_STANDARD | WS_TABSTOP,
                     15, 30, 220, 180, hwnd, HMENU(ID_FILELIST),
                     hInstance, NULL);

  hControl[ID_GROUP] = CreateWindow("button", "Mode",
                     WS_CHILD | WS_VISIBLE | BS_GROUPBOX,
                     250, 2, 131, 122, hwnd, HMENU(ID_GROUP),
                     hInstance, NULL);


  hControl[ID_DRIVES] = CreateWindow("button",
                     ButtonText[ID_DRIVES],
                     WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON |
                     WS_TABSTOP | WS_GROUP,
                     270, 25 + (0 * 30), 95, 30, hwnd,
                     HMENU(ID_DRIVES + 100), hInstance, NULL);

  for (i = 1; i < 3; i++)
    hControl[i] = CreateWindow("button", ButtonText[i],
                     WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON,
                     270, 25 + (i * 30), 95, 30, hwnd,
                     HMENU(i + 100), hInstance, NULL);

  hControl[ID_EDIT]  = CreateWindow("edit", "*.exe",
                     WS_CHILD | WS_VISIBLE | WS_BORDER|
                     WS_TABSTOP | WS_GROUP,
                     250, 130, 131, 25, hwnd, HMENU(ID_EDIT),
                     hInstance, NULL);

  hControl[ID_CLOSE] = CreateWindow("button", "Close",
                     WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON |
                     WS_TABSTOP | WS_GROUP,
                     250, 161, 131, 45, hwnd, HMENU(ID_CLOSE),
                     hInstance, NULL);

  PathWin  = CreateWindow("static", NULL,
                     WS_CHILD | WS_VISIBLE | WS_BORDER,
                     14, 10, 222, 20, hwnd,
                     HMENU(ID_PATHS),  hInstance, NULL);

  DlgDirList(hwnd, "*.*", ID_FILELIST,
             ID_PATHS, DirShowVal[DirShowType]);

  MakeCallBackProcs();

  Button_SetCheck(hControl[0], TRUE);
  SetFocus(hControl[ID_FILELIST]);

  strcpy(FilesWildCard, "*.exe");

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void FileBox_OnDestroy(HWND hwnd)
{
  for (int i = 0; i < 3; i++)
    DeleteBitmap(Bmp[i]);

  SetWindowLong(hControl[ID_EDIT], GWL_WNDPROC,
                LONG(OldEditProc));
  FreeProcInstance(lpfnNewEditProc);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_CLOSE
//////////////////////////////////////
void FileBox_OnClose(HWND hwnd)
{
  if (MessageBox(hwnd, "Do you want to exit?", "FileBox",
       MB_ICONQUESTION | MB_OKCANCEL) == IDOK)
    DestroyWindow(hwnd);
}

//////////////////////////////////////
// SetListbox
//////////////////////////////////////
#pragma argsused
void SetListbox(HWND hwnd)
{
  RECT R;
  char WildCard[150];

  if (DirShowType == FILEMODE)
    strcpy(WildCard, FilesWildCard);
  else
    strcpy(WildCard, "*.*");

  ListBox_ResetContent(hControl[ID_FILELIST]);
  ListBox_Dir(hControl[ID_FILELIST], DirShowVal[DirShowType],
              WildCard);

  R.left = 14;
  R.top = 220;
  R.right = 14 + BMPX;
  R.bottom = 220 + BMPY;
  InvalidateRect(hwnd, &R, FALSE);
}


//////////////////////////////////////
// Handle MouseClick on listbox for DIR or DRIVE change
//////////////////////////////////////
#pragma argsused
void HandleMouseClick(HWND hwnd, int id, HWND hwndCtl, UINT 
codeNotify)
{
  char Buffer[100];

  DlgDirSelect(hwnd, Buffer, ID_FILELIST);
  DlgDirList(hwnd, Buffer, ID_FILELIST, ID_PATHS,
             DirShowVal[DirShowType]);
}


//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void FileBox_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT 
codeNotify)
{
  char S[150], lpszBuffer[150];

  switch(id)
  {
    case ID_DRIVES + 100:
      DirShowType = DRIVEMODE;
      SetListbox(hwnd);
      break;

    case ID_DIRS + 100:
      DirShowType = DIRMODE;
      SetListbox(hwnd);
      break;

    case ID_FILES + 100:
      DirShowType = FILEMODE;
      SetListbox(hwnd);
      break;

    case ID_FILELIST:
      if (codeNotify == LBN_DBLCLK)
      {
        if (DirShowType != FILEMODE)
          HandleMouseClick(hwnd, id, hwndCtl, codeNotify);
        else
        {
          int index = ListBox_GetCurSel(hControl[ID_FILELIST]);
          _getdcwd(0, S, 125);
          ListBox_GetText(hControl[ID_FILELIST], index,
                          lpszBuffer);
          strcat(S, "\\");
          strcat(S, lpszBuffer);
          WinExec(S, SW_SHOWNORMAL);
        }
      }
      break;

    case ID_CLOSE:
      SendMessage(hwnd, WM_CLOSE, 0, 0);
      break;
  }
}

//////////////////////////////////////
// Handle WM_GetMinMaxInfo
//////////////////////////////////////
#pragma argsused
void FileBox_OnGetMinMaxInfo(HWND hwnd, MINMAXINFO FAR* 
lpMinMaxInfo)
{
  lpMinMaxInfo->ptMaxSize.x = XSIZE;
  lpMinMaxInfo->ptMaxSize.y = YSIZE;
  lpMinMaxInfo->ptMaxPosition.x = 100;
  lpMinMaxInfo->ptMaxPosition.y = 100;
  lpMinMaxInfo->ptMinTrackSize.x = XSIZE;
  lpMinMaxInfo->ptMinTrackSize.y = YSIZE;
  lpMinMaxInfo->ptMaxTrackSize.x = XSIZE;
  lpMinMaxInfo->ptMaxTrackSize.y = YSIZE;
}

void HandleRightButton(HWND hwnd)
{
  switch(DirShowType)
  {
    case DRIVEMODE:
      Button_SetCheck(hControl[1], TRUE);
      Button_SetCheck(hControl[0], FALSE);
      Button_SetCheck(hControl[2], FALSE);
      DirShowType = DIRMODE;
      break;

    case DIRMODE:
      Button_SetCheck(hControl[2], TRUE);
      Button_SetCheck(hControl[0], FALSE);
      Button_SetCheck(hControl[1], FALSE);
      DirShowType = FILEMODE;
      break;

    default:
      Button_SetCheck(hControl[0], TRUE);
      Button_SetCheck(hControl[1], FALSE);
      Button_SetCheck(hControl[2], FALSE);
      DirShowType = DRIVEMODE;
  }
  SetListbox(hwnd);
}

//////////////////////////////////////
// Handle WM_PAINT
//////////////////////////////////////
void FileBox_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;
  HBITMAP OldBmp;

  HDC PaintDC = BeginPaint(hwnd, &PaintStruct);
  HDC BltDC = CreateCompatibleDC(PaintDC);

  OldBmp = SelectBitmap(BltDC, Bmp[DirShowType]);
  BitBlt(PaintDC, 14, 220, BMPX, BMPY, BltDC, 0, 0, SRCCOPY);

  SelectBitmap(BltDC, OldBmp);
  DeleteDC(BltDC);
  EndPaint(hwnd, &PaintStruct);
};

//////////////////////////////////////
// Handle WM_PARENTNOTIFY
//////////////////////////////////////
#pragma argsused
void FileBox_OnParentNotify(HWND hwnd, UINT msg,
                            HWND hwndChild, int idChild)
{
  if (msg == WM_RBUTTONDOWN)
    HandleRightButton(hwnd);
}

//////////////////////////////////////
// Handle WM_RBUTTONDOWN
//////////////////////////////////////
#pragma argsused
void FileBox_OnRButtonDown(HWND hwnd, BOOL fDoubleClick,
                           int x, int y, UINT keyFlags)
{
  HandleRightButton(hwnd);
}

// --------------------------------------------------------
// The SubClassed WNDPROCS
// --------------------------------------------------------

void SetNewWildCard(HWND hwnd)
{
  char Buffer[150];

  GetWindowText(hwnd, Buffer, sizeof(Buffer));
  strcpy(FilesWildCard, Buffer);
  if (DirShowType == FILEMODE)
    SetListbox(MainWindow);
}

//////////////////////////////////////
// SubClassing for RadioButtons
//////////////////////////////////////
LRESULT CALLBACK NewEditProc(HWND hwnd, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    case WM_GETDLGCODE:
      return DLGC_WANTALLKEYS;

    case WM_CHAR:
      if (wParam == VK_TAB)
        return 0;
      break;

    case WM_KEYDOWN:
      switch (wParam)
      {
        case VK_RETURN:
          SetNewWildCard(hwnd);
          SetFocus(hControl[ID_CLOSE]);
          break;

        case VK_TAB:
          int State = GetKeyState(VK_SHIFT);
          if (State & 0x8000)
            SetFocus(hControl[DirShowType]);
          else
            SetFocus(hControl[ID_CLOSE]);
          break;
      }

      break;

    case WM_KILLFOCUS:
      SetNewWildCard(hwnd);
      break;

    case WM_SETFOCUS:
      Edit_SetSel(hwnd, 0, -1);
      break;
  }

  return
    CallWindowProc(OldEditProc, hwnd, Message, wParam, lParam);
}
