//////////////////////////////////////
//  Program Name: FONTEASY.CPP
//  Programmer: Charlie Calvert
//  Description: FontEasy windows program
//  Date: 3/20/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fonteasy.h"
#pragma warning (disable: 4068)

// variables
static char szAppName[] = "FontEasy";
static HWND MainWindow;
static HINSTANCE hInstance;
static HFONT TheFont;

// ------------------------------------
// Initialization
// ------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName   = NULL;
  WndClass.lpszClassName  = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInstance, NULL);

  if (hWindow == NULL)
    return hWindow;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

// --------------------------------------
// WndProc and Implementation
// --------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hWindow, UINT Message,
                                 WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hWindow, WM_DESTROY, fonteasy_OnDestroy);
    HANDLE_MSG(hWindow, WM_PAINT, fonteasy_OnPaint);
    default:
      return fonteasy_DefProc(hWindow, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void fonteasy_OnDestroy(HWND hwnd)
{
  if (TheFont != 0) DeleteObject(TheFont);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_PAINT changing the color, and rotating the font
//////////////////////////////////////
void fonteasy_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;
  HFONT OldFont;
  LOGFONT LogFont;
  char aFaceName[80];

  HDC PaintDC = BeginPaint(hwnd, &PaintStruct);

  memset(&LogFont, 0, sizeof(LOGFONT));
  LogFont.lfHeight        = 37;
  LogFont.lfWeight        = 400;
  LogFont.lfOutPrecision  = OUT_STROKE_PRECIS;
  LogFont.lfClipPrecision = CLIP_STROKE_PRECIS;
  LogFont.lfQuality       = DEFAULT_QUALITY;
  strcpy(LogFont.lfFaceName, "New Times Roman");

  if (TheFont != 0) DeleteObject(TheFont);
  TheFont = CreateFontIndirect(&LogFont);

  OldFont = SelectFont(PaintDC, TheFont);
  GetTextFace(PaintDC, sizeof(aFaceName), (LPSTR) aFaceName);
  TextOut(PaintDC, 10, 10, aFaceName, strlen(aFaceName));
  SelectFont(PaintDC, OldFont);

  EndPaint(hwnd, &PaintStruct);
}
