//////////////////////////////////////
//  Program Name: FONTSEXP.CPP
//  Programmer: Charlie Calvert
//  Description: FontsExp windows program
//  Date: 06/20/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <string.h>
#include "FontsExp.h"
#include "fontstr.h"
#pragma warning (disable: 4068)
#pragma warning (disable: 4100)

// ---------------------------------------------------------
// Interface
// ---------------------------------------------------------

static char szAppName[] = "FontsExp";
static HWND MainWindow;
static HINSTANCE hInstance;
static TEXTMETRIC TextMetrics;
char aTextFace[80];

// ---------------------------------------------------------
// Initialization
// ---------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style         = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc   = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName  = "TheMenu";
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                      NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                                 WPARAM wParam, LPARAM lParam)
{
  FONTENUMPROC lpfnEnumProc;
  ENUMSTRUCT EnumStruct;
  char S[100];

  switch(Message)
  {
    case WM_STARTFONTS:
    {
      HDC DC = GetDC(hwnd);
      lpfnEnumProc = (FONTENUMPROC)MakeProcInstance((FARPROC)FontCallBack,
                      hInstance);
      EnumStruct.Count = 0;
      EnumStruct.hWindow = hFontList;
      EnumFontFamilies(DC, NULL, lpfnEnumProc,
                      (LONG)&EnumStruct);
      FreeProcInstance((FARPROC)lpfnEnumProc);

      ReleaseDC(hwnd, DC);

      wsprintf(S, "There are %d fonts available",
               EnumStruct.Count);
      SetWindowText(hNumFonts, S);

      SetFocus(hFontList);
      SendMessage(hFontList, LB_SETCURSEL, 0, 0);
      ShowTheFont(hwnd);
      return 1;
    }

    case WM_NEWFONT:
    {
      if (TheFont != 0)
        DeleteObject(TheFont);
      TheLogFont = (LPLOGFONT)lParam;
      TheFont = CreateFontIndirect(TheLogFont);
      return 1;
    }

    HANDLE_MSG(hwnd, WM_COMMAND, FontsExp_OnCommand);
    HANDLE_MSG(hwnd, WM_CREATE, FontsExp_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, FontsExp_OnDestroy);
    default:
      return FontsExp_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL FontsExp_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  static char *Titles[] = { "TrueType" , "Heavy", "Italic" };

  hFontList = CreateWindow("listbox", NULL,
                     WS_CHILD | WS_VISIBLE | LBS_STANDARD,
                     9, 30, 201, 180, hwnd, HMENU(ID_LISTBOX),
                      hInstance, NULL);

  hNumFonts = CreateWindow("static", NULL,
                           WS_CHILD | WS_VISIBLE | WS_BORDER,
                           10, 10, 200, 20, hwnd, HMENU(-1),
                           hInstance, NULL);

  hFontName = CreateWindow("static", NULL,
                  WS_CHILD | WS_VISIBLE | WS_BORDER,
                  260, 10, 350, 70, hwnd, HMENU(-1), hInstance, NULL);

  hAlphaEdit = CreateWindow("edit", NULL,
                 WS_CHILD | WS_VISIBLE | WS_BORDER | WS_HSCROLL |
                 ES_LEFT | ES_AUTOHSCROLL | ES_MULTILINE,
                 260, 90, 350, 70, hwnd, HMENU(-1),
                 hInstance, NULL);

  for (int i = 0; i < 3; i++)
    ButtonWindows[i] = CreateWindow("button", Titles[i],
                           WS_CHILD | WS_VISIBLE | BS_CHECKBOX,
                           260  + (i * 125), 180, 100, 35, hwnd,
                           HMENU(-1), hInstance, NULL);

  TheFont = 0;

  PostMessage(hwnd, WM_STARTFONTS, 0, 0);

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void FontsExp_OnDestroy(HWND hwnd)
{
  if (TheFont != 0)
    DeleteObject(TheFont);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void FontsExp_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  char S[500];

  switch (id)
  {
    case ID_LISTBOX:
      if (codeNotify == LBN_SELCHANGE)
        ShowTheFont(hwnd);
      break;

    case CM_INFO:
      GetFontString(S, TextMetrics, aTextFace);
      MessageBox(hwnd, S, "Info", MB_OK);
      break;
  }
}

//////////////////////////////////////
// ShowTheFont
//////////////////////////////////////
void ShowTheFont(HWND hwnd)
{
  FONTENUMPROC lpfnEnumProc;
  char lpszBuffer[150];
  ENUMSTRUCT EnumStruct;
  HFONT SaveIt;

  char Alpha[] = {"1234567890abcdefghijklmnopqrstuvwxyz"
                  "ABCDEFGHIJKLMNOPQRSTUVWXYZ"};

  HDC DC = GetDC(hwnd);

  LRESULT Index = SendMessage(hFontList, LB_GETCURSEL, 0, 0);
  SendMessage(hFontList, LB_GETTEXT, WPARAM(Index), LPARAM(lpszBuffer));
  lpfnEnumProc = (FONTENUMPROC)MakeProcInstance(
                 (FARPROC)DescribeFontCallBack, hInstance);
  EnumStruct.Count = 0;
  EnumStruct.hWindow = hwnd;
  EnumFontFamilies(DC, lpszBuffer, lpfnEnumProc, (LONG)&EnumStruct);
  FreeProcInstance((FARPROC)lpfnEnumProc);

  if (TheFont != 0)
    SaveIt = SelectFont(DC, TheFont);
  GetTextMetrics(DC, &TextMetrics);
  HandleMetrics(TextMetrics);
  GetTextFace(DC, 150, aTextFace);
  if (TheFont != 0)
    SelectFont(DC, SaveIt);

  ReleaseDC(hwnd, DC);

  SendMessage(hFontName, WM_SETTEXT, 0, LPARAM(&lpszBuffer));
  SendMessage(hFontName, WM_SETFONT, WPARAM(TheFont), 0);

  SendMessage(hAlphaEdit, WM_SETTEXT, 0, LPARAM(&Alpha));
  SendMessage(hAlphaEdit, WM_SETFONT, WPARAM(TheFont), 0);
}

//////////////////////////////////////
// HandleMetrics
//////////////////////////////////////
void HandleMetrics(TEXTMETRIC TextMetrics)
{

  if ((TextMetrics.tmPitchAndFamily & TMPF_TRUETYPE) == TMPF_TRUETYPE)
    SendMessage(ButtonWindows[0], BM_SETCHECK, 1, 0L);
  else
    SendMessage(ButtonWindows[0], BM_SETCHECK, 0, 0L);

  if ((TextMetrics.tmWeight) > 600)
    SendMessage(ButtonWindows[1], BM_SETCHECK, 1, 0L);
  else
    SendMessage(ButtonWindows[1], BM_SETCHECK, 0, 0L);

  if (TextMetrics.tmItalic)
    SendMessage(ButtonWindows[2], BM_SETCHECK, 1, 0L);
  else
    SendMessage(ButtonWindows[2], BM_SETCHECK, 0, 0L);

}


//////////////////////////////////////
// FontCallback
//////////////////////////////////////
#pragma argsused
int CALLBACK FontCallBack(LPENUMLOGFONT lpnlf,
                          LPNEWTEXTMETRIC lpntm,
                          int FontType, ENUMSTRUCT FAR * lpData)
{
  SendMessage(lpData->hWindow, LB_ADDSTRING, 0, 
LPARAM(lpnlf->elfLogFont.lfFaceName));
  lpData->Count++;
  return 1;
}

//////////////////////////////////////
// DescribeFontCallback
//////////////////////////////////////
#pragma argsused
int CALLBACK DescribeFontCallBack(LPENUMLOGFONT lpnlf,
                                  LPNEWTEXTMETRIC lpntm,
                                  int FontType, ENUMSTRUCT FAR * lpData)
{
  SendMessage(lpData->hWindow, WM_NEWFONT, 0, LPARAM(&lpnlf->elfLogFont));
  return 1;
}
