//////////////////////////////////////
//  Program Name: FONTSEXP.H
//  Programmer: Charlie Calvert
//  Description: FontsExp windows program
//  Date: 06/20/93
//////////////////////////////////////
//////////////////////////////////////
// constants
#define WM_STARTFONTS (WM_USER + 0)
#define WM_NEWFONT (WM_USER + 1)

#define ID_LISTBOX 1
#define CM_INFO 101


// Types
typedef struct
{
  int Count;
  HWND hWindow;
}ENUMSTRUCT;

// Declarations for class FontsExp
#define FontsExp_DefProc    DefWindowProc
BOOL FontsExp_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct);
void FontsExp_OnDestroy(HWND hwnd);
void FontsExp_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);

// Variables
HWND hFontList;
HWND hAlphaEdit;
HWND hTrueType;
HWND hNumFonts;
HWND hFontName;
static HFONT TheFont;
static LPLOGFONT TheLogFont;
HWND ButtonWindows[3];

// Procs
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                           WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);
void HandleMetrics(TEXTMETRIC TextMetrics);
void ShowTheFont(HWND hwnd);
BOOL CALLBACK _export FontCallBack(LPENUMLOGFONT lpnlf,
                         LPNEWTEXTMETRIC lpntm,
                         int FontType, ENUMSTRUCT FAR * lpData);
int CALLBACK _export DescribeFontCallBack(LPENUMLOGFONT lpnlf,
                         LPNEWTEXTMETRIC lpntm,
                         int FontType, ENUMSTRUCT FAR * lpData);
