///////////////////////////////////////////////////////////
//  Program Name: Generic.cpp
//  Programmer: Charlie Calvert                                        
//  Description: Generic windows program
//  Date: 00/00/00
///////////////////////////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma warning (disable: 4068)
// -------------------------------------------------------
// Interface
// -------------------------------------------------------

LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);

// Declarations for class Generic
#define Generic_DefProc    DefWindowProc
void Generic_OnDestroy(HWND hwnd);

static char szAppName[] = "Generic";
static HWND MainWindow;
static HINSTANCE hInstance;


// -------------------------------------------------------
// Initialization
// -------------------------------------------------------

//////////////////////////////////////////////////////////
// Program entry point
//////////////////////////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;
  
  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;  

  while (GetMessage(&Msg, NULL, 0, 0))
  {
    TranslateMessage(&Msg);
    DispatchMessage(&Msg);
  } 

  return Msg.wParam;
}

/////////////////////////////////////////////////////////
// Register the window
/////////////////////////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style      	 = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc	 = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  WndClass.lpszMenuName	 = NULL;
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}

/////////////////////////////////////////////////////////
// Create the window
/////////////////////////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
		            NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

/////////////////////////////////////////////////////////
// The Window Procedure
/////////////////////////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_DESTROY, Generic_OnDestroy);
    default: return Generic_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////////////////////////
#pragma argsused
void Generic_OnDestroy(HWND hwnd)
{
  PostQuitMessage(0);
}
