//////////////////////////////////////
//  Module Name: CDUTIL.CPP
//  Programmer: Charlie Calvert
//  Description: Harmony windows program
//  Date: 08/07/93
//////////////////////////////////////
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include "harmony.h"
#include "cdinfo.h"
#include "stdio.h"
#include "playinfo.h"

extern BYTE State;
extern BYTE PlayType;

//////////////////////////////////////
// HandleDCPAndS
//////////////////////////////////////
void HandleCDPAndS(HWND hwnd, int id)
{
  switch(id)
  {
    case CM_PAUSE:
      State = PAUSED;
      SetWindowText(GetDlgItem(hwnd, ID_MODE), "Paused");
      PauseCDMCI();
      break;

    case CM_STOP:
      State = STOPPED;
      SetWindowText(GetDlgItem(hwnd, ID_MODE), "Stopped");
      StopCDMCI();
      break;
  }
}

//////////////////////////////////////
// OpenCDFile
//////////////////////////////////////
BOOL OpenCDFile(HWND hwnd)
{
  if ((State == PAUSED) || (State == STOPPED) || (State == OPENNED))
    return TRUE;

  if (OpenCD(hwnd))
  {
    State = OPENNED;
    SetTMSFasFormat();
    return TRUE;
  }
  else
    return FALSE;
}

//////////////////////////////////////
// GetTrackString
//////////////////////////////////////
LPSTR GetTrackString(LPSTR S, DWORD i, BOOL LongString)
{
  BYTE Min,Sec,Frame;

  GetCDTrackLength(i, &Min, &Sec, &Frame);
  Min = Min;
  Sec = Sec;
  Frame = Frame;
  if (LongString)
    sprintf(S, "Track: %ld  >> Time: %d:%d", i, Min, Sec);
  else
    sprintf(S, "%d:%d", Min, Sec);
  return S;
}

//////////////////////////////////////
// PlayCD
//////////////////////////////////////
void PlayCD(HWND hwnd)
{
  char S[100];

  if (OpenCDFile(hwnd))
  {
    SetTimer(hwnd, HARMONY_TIMER, 10, NULL);
    // PlayMciCD(4, 5);
    DWORD Index =
      ListBox_GetCurSel(GetDlgItem(hwnd, ID_FILELIST));
    if (Index == LB_ERR)
    {
      MessageBox(hwnd, "You must select a file", NULL, MB_OK);
      return;
    }
    PlayCDOneTrack(Index + 1);
    State = PLAYING;
    SetWindowText(GetDlgItem(hwnd, ID_MODE), "Playing");
    GetTrackString(S, Index + 1, FALSE);
    SetWindowText(GetDlgItem(hwnd, ID_LENGTH), S);
  }
}

//////////////////////////////////////
// HandleDCPTimer
//////////////////////////////////////
void HandleCDTimer(HWND hwnd)
{
  DWORD Track;
  DWORD Time;
  int TimeAry[2];
  char S[50];

  Track = GetCurrentCDTrack();
  sprintf(S, "%ld", Track);
  SetWindowText(GetDlgItem(hwnd, ID_NUMTRACKS), S);
  SetTMSFasFormat();
  Time = GetCDLocation();
  sprintf(S, "%d:%d", MCI_TMSF_MINUTE(Time),
          MCI_TMSF_SECOND(Time));
  SetWindowText(GetDlgItem(hwnd, ID_POSITION), S);
}

//////////////////////////////////////
// FillCDTrackBox
//////////////////////////////////////
void FillCDTrackBox(HWND hwnd)
{
  DWORD i;
  char S[100];

  if (!OpenCDFile(hwnd))
    return;

  ListBox_ResetContent(GetDlgItem(hwnd, ID_FILELIST));
  DWORD NumTracks = GetCDNumTracks();
  if (NumTracks == -1) return;

  HCURSOR Cursor1 = LoadCursor(0, IDC_WAIT);
  SetCursor(Cursor1);
  HCURSOR OldCursor = (HCURSOR)SetClassWord(hwnd, GCW_HCURSOR,
                                (WORD)Cursor1);
  SetCapture(GetDlgItem(hwnd, ID_LENGTH));
  for (i = 1; i <= NumTracks; i++)
  {
    GetTrackString(S, i, TRUE);
    ListBox_AddString(GetDlgItem(hwnd, ID_FILELIST), S);
  }
  ListBox_SetCurSel(GetDlgItem(hwnd, ID_FILELIST), 0);
  SetCursor(OldCursor);
  SetClassWord(hwnd, GCW_HCURSOR, (WORD)OldCursor);
  ReleaseCapture();
}

//////////////////////////////////////
// CloseCompact
//////////////////////////////////////
void CloseCompact(void)
{
  if (State == CLOSED) return;
  if (State == PLAYING)
    StopCDMCI();
  CloseCDMCI();
}

//////////////////////////////////////
// CheckForClose
//////////////////////////////////////
void CheckForClose(void)
{
  if (State != CLOSED)
   if (PlayType == COMPACT)
     CloseCompact();
   else
     CloseMCI();

  State = CLOSED;
}
