//////////////////////////////////////
//  Module Name: HARMONY.H
//  Programmer: Charlie Calvert
//  Description: Harmony windows program
//  Date: 08/07/93
//////////////////////////////////////
//////////////////////////////////////
// User defined messages
#define WM_FILLLISTBOX (WM_USER + 0)

// Buttons the user can push
#define CM_WAVEPLAY 101
#define CM_PAUSE 102
#define CM_STOP 103
#define CM_DIRECTORY 104
#define CM_RECORD 105
#define CM_HELP     106

// Listbox and Combo
#define ID_FILELIST 120
#define ID_PLAYLIST 121

// Controls that report to user
#define ID_MODE 140
#define ID_NUMTRACKS 141
#define ID_POSITION 142
#define ID_LENGTH 143
#define ID_DIREDIT 145

// The radio buttons for selecting mode
#define ID_GROUP 5000
#define CM_COMPACT 5001
#define CM_WAVE 5002
#define CM_MIDI 5003

// States
#define PAUSED 1
#define PLAYING 2
#define STOPPED 3
#define CLOSED 4
#define OPENNED 6
#define RECORDING 7
#define ERROR_OCCURED 8

// Devices
#define WAVE 1
#define COMPACT 2
#define MIDI 3

// Misc
#define DIRSTRSIZE 200
#define DEVICESTRSIZE 50
#define HARMONY_TIMER 1

// WindowsX extensions
#define HANDLE_MM_MCINOTIFY(hwnd, wParam, lParam, fn) \
    ((fn)((hwnd), (UINT)(wParam), (int)LOWORD(lParam)), 0L)
#define FORWARD_MM_MCINOTIFY(hwnd, status, DeviceID, fn) \
    (void)(fn)((hwnd), MM_MCINOTIFY, (WPARAM)(status), \
    MAKELPARAM((UINT)(DeviceID), 0))

#define HANDLE_WM_FILLLISTBOX(hwnd, wParam, lParam, fn) \
    ((fn)(hwnd), 0L)
#define FORWARD_WM_FILLLISTBOX(hwnd, fn) \
    (void)(fn)((hwnd), WM_FILLLISTBOX, 0, 0L)

// Declarations for class Harmony
#define Harmony_DefProc    DefWindowProc
BOOL Harmony_OnCreate(HWND hwnd,
                      CREATESTRUCT FAR* lpCreateStruct);
void Harmony_OnDestroy(HWND hwnd);
void Harmony_OnFillListBox(HWND hwnd);
void Harmony_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT 
codeNotify);
void Harmony_OnMCINotify(HWND hwnd, UINT status, int DeviceID);
void Harmony_OnTimer(HWND hwnd, UINT id);

// The sum of frustrations
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                           WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);
