# HARMONY.MAK

APPNAME = Harmony
DLLCOMPFLAGS = -c -ALw -Gsw -Ow -W2 -Zp
DLLLINKFLAGS = /align:16, NUL, /nod ldllcew libw mmsystem
COMPFLAGS = -c -Gsw -Ow -W3 -AL -Zp
LINKFLAGS = /align:16, NUL, /nod llibcew libw
OBJS = Harmony.obj WaveMidi.obj CDUtil.obj
LIBS = PlayInfo.lib CDInfo.lib

# goal
ALL: $(APPNAME).exe PlayInfo.dll CDInfo.dll

# link EXES
$(APPNAME).exe: $(OBJS) $(APPNAME).def $(APPNAME).res $(LIBS)
  link $(OBJS), $(LINKFLAGS) $(LIBS) CommDlg, $(APPNAME)
  rc $(APPNAME).res

# link DLLS
playinfo.dll: playinfo.obj playinfo.def
  link playinfo, playinfo.dll $(DLLLINKFLAGS), playinfo

cdinfo.dll: cdinfo.obj cdinfo.def
  link cdinfo, cdinfo.dll $(DLLLINKFLAGS), cdinfo

# compile
$(APPNAME).obj: $(APPNAME).cpp
  cl $(COMPFLAGS) $(APPNAME).cpp

# compile
CDUtils.obj: CDUtils.cpp
  cl $(COMPFLAGS) CDUtils.cpp

# compile
WaveMidi.obj: WaveMidi.cpp
  cl $(COMPFLAGS) WaveMidi.cpp

# compile
.cpp.obj:
  cl $(DLLCOMPFLAGS) $(PATHS) { $< }

# resource
harmony.res: harmony.rc
  rc -r harmony.rc

# libraries
playinfo.lib: playinfo.dll
  implib playinfo.lib playinfo.dll

cdinfo.lib: cdinfo.dll
  implib cdinfo.lib cdinfo.dll
