//////////////////////////////////////
//  Program Name: MAPPER.H
//  Programmer: Charlie Calvert
//  Description: Mapper windows program
//  Date: 07/18/93
//////////////////////////////////////
//////////////////////////////////////
// Const
#define WM_DIALOG (WM_USER + 0x100)
#define WM_HELP (WM_USER + 0x101)

// Arrows Dialog
#define ID_LEFT     150
#define ID_RIGHT    251
#define ID_DIALOG   252
#define ID_QUIT     253
#define ID_START    254
#define ID_END      255
#define ID_RSCREEN  256
#define ID_LSCREEN  257
#define ID_HELP     1001

// Options dialog constnants
#define ID_XSIZE   101
#define ID_YSIZE   102
#define ID_NUMX    103
#define ID_NUMY    104
#define ID_SAVE    105
#define ID_BITMAP1 120
#define ID_BITMAP2 121
#define ID_BITMAP3 122
#define ID_BITMAP4 123

#define MaxY 21
#define MaxX 4 * 32

#define BITHEIGHT 32
#define BITWIDTH 25

#define JUMPSPACE 32

// Types
struct TDAT
{
  int MenuSpace;
  int SizeX, SizeY;
  int SPos;
  int GrassX;
  int GrassY;
};

// Declarations for class Mapper
#define Mapper_DefProc    DefWindowProc
BOOL Mapper_OnCreate(HWND hwnd, 
                     CREATESTRUCT FAR* lpCreateStruct);
void Mapper_OnDestroy(HWND hwnd);
void Mapper_OnMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
void Mapper_OnLButtonDown(HWND hwnd, BOOL fDoubleClick, 
                          int x, int y, UINT keyFlags);
void Mapper_OnRButtonDown(HWND hwnd, BOOL fDoubleClick, 
                          int x, int y, UINT keyFlags);
void Mapper_OnPaint(HWND hwnd);

// Procs
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                                 WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK _export BitmapProc(HWND hwnd, UINT Message,
                                 WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);
BOOL CALLBACK OptionsDlgProc(HWND hDlg, WORD Message, 
                             WPARAM wParam, LPARAM lParam);
BOOL CALLBACK ArrowDlgProc(HWND hDlg, WORD Message,
                           WPARAM wParam, LPARAM lParam);
