//////////////////////////////////////
// Program Name: ANISOTRP.CPP
// Programmer: Charlie Calvert
// Description: MDI example program
// Date: 07/25/93
//////////////////////////////////////
//////////////////////////////////////
#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <stdlib.h>
#include "draw.h"
#pragma warning(disable : 4068)

extern HMENU hMenuMultiple, hMenuInit;
extern HMENU hMenuFileMultiple, hMenuFileInit;
static HWND hwndClient, hwndFrame ;

// AnIsotrop_Play Object
#define AnIsotrop_DefProc DefMDIChildProc
BOOL AnIsotrop_OnCreate(HWND hwnd,
                        CREATESTRUCT FAR* lpCreateStruct);
void AnIsotrop_MDIActivate(HWND hwnd, BOOL fActive, 
                           HWND hwndActivate, HWND hwndDeactivate);
void AnIsotrop_OnPaint(HWND hwnd);

//////////////////////////////////////
// The WndProc
//////////////////////////////////////
LRESULT CALLBACK AnIsotropicWndProc (HWND hwnd, UINT message, 
                                     WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, AnIsotrop_OnCreate);
    HANDLE_MSG(hwnd, WM_MDIACTIVATE, AnIsotrop_MDIActivate);
    HANDLE_MSG(hwnd, WM_PAINT, AnIsotrop_OnPaint);
  default:
    return AnIsotrop_DefProc(hwnd, message, wParam, lParam) ;
  }
}

//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL AnIsotrop_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  hwndClient = GetParent (hwnd) ;
  hwndFrame  = GetParent (hwndClient) ;
  return TRUE;
}

//////////////////////////////////////
// Handle WM_ACTIVATE
//////////////////////////////////////
#pragma argsused
void AnIsotrop_MDIActivate(HWND hwnd, BOOL fActive,
                           HWND hwndActivate,
                           HWND hwndDeactivate)
{
  if (fActive)
    SendMessage (hwndClient, WM_MDISETMENU, 0,
                 MAKELONG(hMenuMultiple, hMenuFileMultiple));

  if (!fActive)
    SendMessage (hwndClient, WM_MDISETMENU, 0,
                 MAKELONG(hMenuInit, hMenuFileInit));
  DrawMenuBar (hwndFrame) ;
}

//////////////////////////////////////
// Handle WM_PAINT
//////////////////////////////////////
void AnIsotrop_OnPaint(HWND hwnd)
{
  HDC PaintDC;
  PAINTSTRUCT PaintStruct;
  RECT R;

  PaintDC = BeginPaint (hwnd, &PaintStruct);

  SetMapMode(PaintDC, MM_ANISOTROPIC);
  GetClientRect(hwnd, &R);
  SetWindowExt(PaintDC, 210, 210);
  SetViewportExt(PaintDC, R.right, R.bottom);
  SetViewportOrg(PaintDC, R.right / 2, R.bottom / 2);
  DoDraw(PaintDC);

  EndPaint (hwnd, &PaintStruct);
}
