//////////////////////////////////////
// Program Name: MDIPAINT.CPP
// Programmer: Charlie Calvert
// Description: MDI example program
// Note: Use Smart Callbacks or Explicit Exports
// Date: 07/25/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include "mdipaint.h"
#pragma warning(disable : 4068)

// global variables
static HWND hWndFrame, hWndClient;
static char szFrameClass[] = "MDI_Frame";
static char szIsotropic[] = "MDI_AnIsotropic";
static char szAnIsotropic[] = "MDI_Isotropic";
static char szNormal[] = "MDI_Normal";
static char szFern[] = "MDI_Fern";
static HINSTANCE hInstance;
HMENU  hMenuInit, hMenuMultiple;
HMENU  hMenuFileInit, hMenuFileMultiple;
HACCEL hAccel;

//#define Frame_DefProc DefFrameProc
BOOL Frame_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct);
void Frame_OnDestroy(HWND hwnd);
void Frame_OnClose(HWND hwnd);
void Frame_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT
codeNotify);
BOOL Frame_OnQueryEndSession(HWND hwnd);

//////////////////////////////////////
// DefProc for the Frame window.
//////////////////////////////////////
LRESULT Frame_DefProc (HWND hwnd, UINT uMsg, WPARAM wParam,
LPARAM lParam)
{
   return(DefFrameProc(hwnd, hWndClient, uMsg, wParam, lParam));
}

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain (HINSTANCE hInst, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
  MSG      msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  if (!(hWndFrame = Create(hInst, nCmdShow)))
    return FALSE;

  while (GetMessage (&msg, NULL, 0, 0))
  {
    if (!TranslateMDISysAccel (hWndClient, &msg) &&
        !TranslateAccelerator (hWndFrame, hAccel, &msg))
      {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
      }
  }
  return msg.wParam;
}

//////////////////////////////////////
// Register classes with the OS
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS wndclass;

  // Register the frame window class
  wndclass.style         = CS_HREDRAW | CS_VREDRAW;
  wndclass.lpfnWndProc   = FrameWndProc;
  wndclass.cbClsExtra    = 0;
  wndclass.cbWndExtra    = 0;
  wndclass.hInstance     = hInst;
  wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
  wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
  wndclass.hbrBackground =
          CreateSolidBrush(GetSysColor(COLOR_APPWORKSPACE));
  wndclass.lpszMenuName  = NULL;
  wndclass.lpszClassName = szFrameClass;

  if(!RegisterClass (&wndclass))
    return FALSE;

  // Register the Isotropic window class
  wndclass.lpfnWndProc   = IsotropicWndProc;
  wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
  wndclass.hbrBackground = GetStockBrush(WHITE_BRUSH);
  wndclass.lpszMenuName  = NULL;
  wndclass.lpszClassName = szIsotropic;

  if(!RegisterClass (&wndclass))
    return FALSE;

  // Register the AnIsotropic window class
  wndclass.lpfnWndProc   = AnIsotropicWndProc;
  wndclass.hIcon         = NULL;
  wndclass.lpszClassName = szAnIsotropic;

  if(!RegisterClass (&wndclass))
    return FALSE;

  // Register the Normal window class
  wndclass.lpfnWndProc   = NormalWndProc;
  wndclass.lpszClassName = szNormal;

  if(!RegisterClass (&wndclass))
    return FALSE;

  // Register the Normal window class
  wndclass.lpfnWndProc   = FernWndProc;
  wndclass.hbrBackground = GetStockBrush(BLACK_BRUSH);
  wndclass.lpszClassName = szFern;

  return RegisterClass(&wndclass);
}

//////////////////////////////////////
// Create the main window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{
  hInstance = hInst;

  HWND hwnd = CreateWindow (szFrameClass, "MDI Paint",
                           WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           NULL, hMenuInit, hInstance, NULL);

  if (hwnd == NULL)
    return hwnd;

  ShowWindow (hwnd, nCmdShow);
  UpdateWindow (hwnd);

  return hwnd;
}

LRESULT CALLBACK __export FrameWndProc (HWND hwnd, UINT message,
WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
     HANDLE_MSG(hwnd, WM_CREATE, Frame_OnCreate);
     HANDLE_MSG(hwnd, WM_DESTROY, Frame_OnDestroy);
     HANDLE_MSG(hwnd, WM_CLOSE, Frame_OnClose);
     HANDLE_MSG(hwnd, WM_COMMAND, Frame_OnCommand);
     HANDLE_MSG(hwnd, WM_QUERYENDSESSION,
                Frame_OnQueryEndSession);
     default:
       return(DefFrameProc(hwnd, hWndClient, message, wParam,
lParam));
  }
}

//////////////////////////////////////
// WM_CREATE   Create the client window
//////////////////////////////////////
#pragma argsused
BOOL Frame_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  CLIENTCREATESTRUCT clientcreate;

  hMenuInit = LoadMenu(hInstance, "MdiMenuInit");
  hMenuMultiple = LoadMenu(hInstance, "MDIMultiple");
  SetMenu(hwnd, hMenuInit);

  // Load accelerator table
  hWndClient = GetWindow (hwnd, GW_CHILD);
  hAccel = LoadAccelerators (hInstance, "MdiAccel");

  hMenuFileInit = GetSubMenu(hMenuInit, 0);
  hMenuFileMultiple = GetSubMenu(hMenuMultiple, 0);

  clientcreate.hWindowMenu  = hMenuFileInit;
  clientcreate.idFirstChild = IDM_FIRSTCHILD;

  hWndClient = CreateWindow ("MDICLIENT", NULL,
                        WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE,
                        0, 0, 0, 0, hwnd, HMENU(1), hInstance,
                        (LPSTR) &clientcreate);
  if (hWndClient == NULL)
    return FALSE;

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void Frame_OnDestroy(HWND hwnd)
{
  DestroyMenu(hMenuMultiple);
  SetMenu(hwnd, NULL);
  DestroyMenu(hMenuInit);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_CLOSE
//////////////////////////////////////
void Frame_OnClose(HWND hwnd)
{
  if (NULL != GetWindow (hWndClient, GW_CHILD))
    SendMessage (hwnd, WM_COMMAND, CM_CLOSEALL, 0L);

  if (NULL != GetWindow (hWndClient, GW_CHILD))
    return;

  DestroyWindow(hwnd);
}

//////////////////////////////////////
// Create an MDI child, HANDLE WM_MDICREATE
//////////////////////////////////////
HWND CreateMDIChild(LPCSTR szClass, LPCSTR szTitle)
{
  MDICREATESTRUCT    MCS;

  MCS.szClass = szClass;
  MCS.szTitle = szTitle;
  MCS.hOwner  = hInstance;
  MCS.x       = CW_USEDEFAULT;
  MCS.y       = CW_USEDEFAULT;
  MCS.cx      = CW_USEDEFAULT;
  MCS.cy      = CW_USEDEFAULT;
  MCS.style   = 0;
  MCS.lParam  = NULL;
  return FORWARD_WM_MDICREATE(hWndClient, &MCS, SendMessage);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void Frame_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT
codeNotify)
{
  WNDENUMPROC        lpfnEnum;
  HWND               hwndChild;


  // Do default processing for any system commands (SC_*).
  if ((unsigned) id >= 0xF000u) goto DWP; // thanks to J. Richter

  switch (id)
  {
     case CM_ANISOTROP:
       CreateMDIChild(szAnIsotropic, "AnIsotropic");
       break;

     case CM_ISOTROP:
       CreateMDIChild(szIsotropic, "Isotripic");
       break;

     case CM_NORMAL:
       CreateMDIChild(szNormal, "Normal Ratio");
       break;

     case CM_FERN:
       CreateMDIChild(szFern, "Lar Fern");
       break;

     case CM_CLOSE:          // Close the active window
       hwndChild = (HWND)LOWORD(SendMessage(hWndClient,
                                WM_MDIGETACTIVE, 0, 0L));
       if (SendMessage(hwndChild, WM_QUERYENDSESSION, 0, 0L))
          SendMessage(hWndClient, WM_MDIDESTROY,
                      (WPARAM)hwndChild, 0L);
       break;

     case CM_EXIT:           // Exit the program
       SendMessage (hwnd, WM_CLOSE, 0, 0L);
       break;

     case CM_TILE:
       SendMessage (hWndClient, WM_MDITILE, 0, 0L);
       break;

     case CM_CASCADE:
       SendMessage (hWndClient, WM_MDICASCADE, 0, 0L);
       break;

     case CM_ARRANGE:
       SendMessage (hWndClient, WM_MDIICONARRANGE, 0, 0L);
       break;

     case CM_CLOSEALL:       // Attempt to close all children
       lpfnEnum = (WNDENUMPROC)MakeProcInstance(
                          (FARPROC)EnumChildWnds, hInstance);
       EnumChildWindows (hWndClient, lpfnEnum, 0L);
       FreeProcInstance ((FARPROC)lpfnEnum);
       break;

     default:            // Pass to active child
       hwndChild = (HWND)LOWORD(SendMessage(hWndClient,
                   WM_MDIGETACTIVE, 0, 0L));
       if (IsWindow (hwndChild))
         SendMessage (hwndChild, WM_COMMAND, id, codeNotify);
       break;        // and then to DefFrameProc
  }
  DWP:
   FORWARD_WM_COMMAND(hwnd, id, hwndCtl,
                      codeNotify, Frame_DefProc);
}

//////////////////////////////////////
// Handle WM_QUERYENDSESSION
//////////////////////////////////////
#pragma argsused
BOOL Frame_OnQueryEndSession(HWND hwnd)
{
  if (NULL != GetWindow (hWndClient, GW_CHILD))
    SendMessage (hwnd, WM_COMMAND, CM_CLOSEALL, 0L);

  if (NULL != GetWindow (hWndClient, GW_CHILD))
    return FALSE;
  else
    return TRUE;
}

// ---------------------------------------
// Callbacks
// ---------------------------------------

//////////////////////////////////////
// Callbacks
//////////////////////////////////////
#pragma argsused
BOOL CALLBACK EnumChildWnds(HWND hwnd, LONG lParam)
{
  if (GetWindow(hwnd, GW_OWNER)) // Icon Title?
    return TRUE;

  SendMessage (GetParent(hwnd), WM_MDIRESTORE, (WPARAM)hwnd, 0L);
  if (!SendMessage (hwnd, WM_QUERYENDSESSION, 0, 0L))
    return TRUE;

  SendMessage (GetParent(hwnd), WM_MDIDESTROY, (WPARAM)hwnd, 0L);
    return TRUE;
}
