//////////////////////////////////////
//  Program Name: MENUAID.CPP
//  Programmer: Charlie Calvert
//  Thanks: Dave Wilhelm
//  Description: MenuAid windows program
//  Date: 07/04/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#pragma warning (disable: 4068)

// -------------------------------------------------------
// Interface
// -------------------------------------------------------

#define CM_EDIT 1
#define WM_SPECIAL (WM_USER + 0x100)
#define ID_LISTBOX 102
#define CM_UPDATE 103
#define XSIZE 223
#define YSIZE 253

LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, WPARAM wParam,
                                  LPARAM  lParam);
LRESULT CALLBACK _export NewDesktopProc(HWND hWindow, UINT Message,
WPARAM wParam, LPARAM lParam);
BOOL Register(HINSTANCE hInst);
HWND Create(HINSTANCE hInst, int nCmdShow);
HMENU NewMenu(void);

// Declarations for class MenuAid
#define MenuAid_DefProc    DefWindowProc
BOOL MenuAid_OnCreate(HWND hwnd,
                      CREATESTRUCT FAR* lpCreateStruct);
void MenuAid_OnDestroy(HWND hwnd);
void MenuAid_OnCommand(HWND hwnd, int id,
                       HWND hwndCtl, UINT codeNotify);
void MenuAid_OnGetMinMaxInfo(HWND hwnd,
                       MINMAXINFO FAR* lpMinMaxInfo);

static char szAppName[] = "MenuAid";
static char IniName[] = "MenuAid.Ini";
static HWND MainWindow, DeskWnd, hListBox;
static HINSTANCE hInstance;
WNDPROC OldDesk;
FARPROC lpfnNewProc;
HMENU Float;
static int ItemsInMenu = 1;

// -------------------------------
// Initialization
// -------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance, LPSTR
                   lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style         = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc   = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(hInst, "MenuAid");
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = GetStockBrush(LTGRAY_BRUSH);
  WndClass.lpszMenuName  = NULL;
  WndClass.lpszClassName = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{
  hInstance = hInst;
  DWORD Style = WS_OVERLAPPEDWINDOW & ~WS_MAXIMIZEBOX;

  HWND hwnd = CreateWindow(szAppName, szAppName,
                Style & ~WS_THICKFRAME,
                CW_USEDEFAULT, CW_USEDEFAULT,
                CW_USEDEFAULT, CW_USEDEFAULT,
                NULL, NULL, hInst, NULL);

  if (hwnd == NULL)
    return hwnd;

  nCmdShow = SW_SHOWMINIMIZED;

  ShowWindow(hwnd, nCmdShow);
  UpdateWindow(hwnd);

  return hwnd;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message, 
                                 WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    case WM_SPECIAL:
    {
      POINT P = MAKEPOINT(lParam);
      Float = NewMenu();
      TrackPopupMenu(Float, TPM_LEFTALIGN,
                     P.x, P.y, 0, hwnd, NULL);
      return 0;
    }

    HANDLE_MSG(hwnd, WM_CREATE, MenuAid_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, MenuAid_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, MenuAid_OnCommand);
    HANDLE_MSG(hwnd, WM_GETMINMAXINFO, MenuAid_OnGetMinMaxInfo);
    default:
      return MenuAid_DefProc(hwnd, Message, wParam, lParam);
  }
}

void FillListBox(HWND hwnd)
{
  int Temp, Total = 0;
  const int Size = 1024;
  char Buffer[Size];

  ListBox_ResetContent(hwnd);
  ListBox_AddString(hwnd, "Edit");

  int Len = GetPrivateProfileString("Files", NULL, "",
                                    Buffer, Size, IniName);
  while(Len > Total)
  {
    ListBox_AddString(hwnd, Buffer);
    Temp = strlen(Buffer) + 1;
    Total += Temp;
    memmove(Buffer, &Buffer[Temp], Size - Total);
  }
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
BOOL MenuAid_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  Float = NULL;

  DeskWnd = GetDesktopWindow();
  lpfnNewProc =
    MakeProcInstance(FARPROC(NewDesktopProc), hInstance);
  OldDesk = (WNDPROC)SetWindowLong(DeskWnd,
                         GWL_WNDPROC, LONG(lpfnNewProc));

  hListBox = CreateWindow("ListBox", NULL,
               WS_CHILD | WS_VISIBLE | LBS_NOTIFY | WS_BORDER,
               10, 10, 200, 200, hwnd,
               HMENU(ID_LISTBOX), hInstance, NULL);

  FillListBox(hListBox);

  HMENU TheMenu = CreateMenu();
  HMENU AMenu = CreatePopupMenu();
  AppendMenu(AMenu, MF_STRING, CM_EDIT, "Edit");
  AppendMenu(AMenu, MF_STRING, CM_UPDATE, "Update");
  AppendMenu(TheMenu, MF_ENABLED | MF_POPUP,
            (UINT) AMenu, "&File");
  SetMenu(hwnd, TheMenu);

  Float = NewMenu();

  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void MenuAid_OnDestroy(HWND hwnd)
{
  SetWindowLong(DeskWnd, GWL_WNDPROC, LONG(OldDesk));
  FreeProcInstance(lpfnNewProc);
  DestroyMenu(Float);
  PostQuitMessage(0);
}

//////////////////////////////////////
// Launch
//////////////////////////////////////
void FAR Launch(int id)
{
  char FileName[50];
  char Buffer[200];

  if (GetMenuString(Float, id, FileName,
                    sizeof(FileName), MF_BYCOMMAND) > 0)
    if (GetPrivateProfileString("Files", FileName, "",
                    Buffer, sizeof(Buffer), IniName) > 0)
      WinExec(Buffer, SW_SHOWNORMAL);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused
void MenuAid_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  const int Size = 250;
  char Buffer[Size];
  char Buffer2[Size];

  if((id > CM_EDIT) && (id <= ItemsInMenu))
    Launch(id);
  else
    switch(id)
    {
      case CM_EDIT:
        GetWindowsDirectory(Buffer, Size);
        strcpy(Buffer2, Buffer);
        strcat(Buffer2, "\\notepad.exe ");
        strcat(Buffer2, Buffer);
        strcat(Buffer2, "\\MenuAid.Ini");
        WinExec(Buffer2, SW_SHOWNORMAL);
        break;

      case ID_LISTBOX:
        if(codeNotify == LBN_DBLCLK)
        {
          int Index = ListBox_GetCurSel(hListBox);
          SendMessage(hwnd, WM_COMMAND, Index + 1, 0L);
        }
        break;

      case CM_UPDATE:
        FillListBox(hListBox);
        Float = NewMenu();
        break;
    }
}

//////////////////////////////////////
// Handle WM_GetMinMaxInfo
//////////////////////////////////////
#pragma argsused
void MenuAid_OnGetMinMaxInfo(HWND hwnd,
                             MINMAXINFO FAR* lpMinMaxInfo)
{
  lpMinMaxInfo->ptMaxSize.x = XSIZE;
  lpMinMaxInfo->ptMaxSize.y = YSIZE;
  lpMinMaxInfo->ptMaxPosition.x = 100;
  lpMinMaxInfo->ptMaxPosition.y = 100;
  lpMinMaxInfo->ptMinTrackSize.x = XSIZE;
  lpMinMaxInfo->ptMinTrackSize.y = YSIZE;
  lpMinMaxInfo->ptMaxTrackSize.x = XSIZE;
  lpMinMaxInfo->ptMaxTrackSize.y = YSIZE;
}

//////////////////////////////////////
// NewMenu
//////////////////////////////////////
HMENU NewMenu(void)
{
  int Temp, Total = 0;
  const int Size = 1024;
  char Buffer[Size];
  ItemsInMenu = 2;

  if (Float) DestroyMenu(Float);
  int Len = GetPrivateProfileString("Files", NULL, "",
                                     Buffer, Size, IniName);

  Float = CreatePopupMenu();
  AppendMenu(Float, MF_STRING, 1, "Edit");

  while(Len > Total)
  {
    AppendMenu(Float, MF_ENABLED | MF_STRING,
               ItemsInMenu, Buffer);
    Temp = strlen(Buffer) + 1;
    Total += Temp;
    memmove(Buffer, &Buffer[Temp], Size - Total);
    ItemsInMenu++;
  }

  return Float;
}

//////////////////////////////////////
// NewDesktopProc
//////////////////////////////////////
LRESULT CALLBACK NewDesktopProc(HWND hwnd, UINT Message, WPARAM wParam,
                                LPARAM lParam)
{
  if (Message == WM_RBUTTONDOWN)
    PostMessage(MainWindow, WM_SPECIAL, 0, lParam);

  return CallWindowProc(OldDesk, hwnd, Message, wParam, lParam);
}
