//////////////////////////////////////
//  Program Name: METAENUM.CPP
//  Programmer: Charlie Calvert
//  Description: Part of Metaphor windows project
//  Date: 7/23/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma warning (disable: 4068)

int CALLBACK EnumMetaFileProc(HDC hdc, HANDLETABLE FAR* lpHTable,
    METARECORD FAR* lpMFR, int cObj, BYTE FAR* lpClientData);

//////////////////////////////////////
// EnumTheMeta
//////////////////////////////////////
void EnumTheMeta(HWND hwnd, HMETAFILE AMeta)
{
  MFENUMPROC lpEnumMetaProc;
  HDC PaintDC;
  HINSTANCE hInst;

  PaintDC = GetDC(hwnd);
  hInst = (HINSTANCE)GetClassWord(hwnd, GCW_HMODULE);
  if (hInst)
  {
    lpEnumMetaProc = (MFENUMPROC) MakeProcInstance(
      (FARPROC) EnumMetaFileProc, hInst);
    EnumMetaFile(PaintDC, AMeta, lpEnumMetaProc, NULL);
    FreeProcInstance((FARPROC) lpEnumMetaProc);
  }
  ReleaseDC(hwnd, PaintDC);
}

// ----------------------------------------------------
// Callbacks, etc
// ----------------------------------------------------

//////////////////////////////////////
// EnumMetaFileProc
//////////////////////////////////////
#pragma argsused
int CALLBACK EnumMetaFileProc(HDC hdc, HANDLETABLE FAR* lpHTable,
    METARECORD FAR* lpMFR, int cObj, BYTE FAR* lpClientData)
{
    PlayMetaFileRecord(hdc, lpHTable, lpMFR, cObj);
    return 1;
}
