//////////////////////////////////////
//  Program Name: METAUTIL.CPP
//  Programmer: Charlie Calvert
//  Description: Part of MetaFor windows project
//  Date: 4/17/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <commdlg.h>
#include <string.h>
#include <direct.h>
#include <stdio.h>
#include <stdlib.h>
#include "metaphor.h"
#include "metautil.h"
#pragma warning (disable: 4068)

extern HMETAFILE hmf;
static METAHEADER mfHeader;
static BOOL bMetaInRam;
static BOOL IsAldus;

//////////////////////////////////////
// Create Meta
//////////////////////////////////////
#pragma argsused
void CreateMeta(HWND hwnd)
{
   HDC MetaDC;
   HPEN OldPen;
   char FName[256];

   _getdcwd(0, FName, MAXSIZE);
   strcat(FName, "\\quickmet.wmf");
   MetaDC = CreateMetaFile(FName);
   if (MetaDC != NULL)
   {
     HPEN Pen = CreatePen(PS_SOLID, 10, RGB(0, 255, 127));
     OldPen = SelectPen(MetaDC, Pen);
     Ellipse(MetaDC, 200, 200, 100, 100);
     SelectObject(MetaDC, OldPen);
     DeleteObject(Pen);
     Pen = CreatePen(PS_SOLID, 10, RGB(255, 0, 0));
     OldPen = SelectPen(MetaDC, Pen);
     Rectangle(MetaDC, 20, 20, 100, 100);
     SelectObject(MetaDC, OldPen);
     DeleteObject(Pen);
     hmf = CloseMetaFile(MetaDC);
   }
}

//////////////////////////////////////
// IsAldusFile
//////////////////////////////////////
BOOL IsAldusFile(void)
{
  return IsAldus;
}

//////////////////////////////////////
// ReadPlaceableHeader
//////////////////////////////////////
BOOL ReadPlaceableHeader(HWND hwnd, HFILE fh)
{
  char *ErrString = "Error reading placeable header";
  int wBytesRead;
  ALDUSMFHEADER AldusMFHeader;

  wBytesRead = _lread(fh, (LPSTR)&AldusMFHeader, 
sizeof(ALDUSMFHEADER));
  if( wBytesRead == -1 || wBytesRead < sizeof(ALDUSMFHEADER) )
  {
    MessageBox(hwnd, ErrString, NULL, MB_OK | MB_ICONHAND);
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// Read header of metafile
//////////////////////////////////////
BOOL ReadHeader(METAHEADER *mfHeader, HWND hwnd, HFILE fh)
{
  int wBytesRead;
  char * ErrString = "Error reading metafile header";

  _llseek(fh, sizeof(ALDUSMFHEADER), 0);
  wBytesRead = _lread(fh, (LPSTR)mfHeader, sizeof(METAHEADER));

  if( wBytesRead == -1 || wBytesRead < sizeof(METAHEADER) )
  {
    MessageBox(hwnd, ErrString,  NULL, MB_OK | MB_ICONHAND);
    return(FALSE);
  }

  return TRUE;
}

//////////////////////////////////////
// Allocate memory for meta bits
//////////////////////////////////////
HANDLE AllocMetaMemory(HWND hwnd, METAHEADER *mfHeader)
{
  char *ErrString1 = "Memory allocation error";
  HANDLE   hMem;

  if (!(hMem = GlobalAlloc(GHND, (mfHeader->mtSize * 2L))))
  {
    MessageBox(hwnd, ErrString1, NULL, MB_OK | MB_ICONHAND);
    return hMem = 0;
  }
  return hMem;
}

BOOL ReadMetafileBits(HWND hwnd, HFILE fh, METAHEADER mfHeader, LPSTR
                      lpMem, HANDLE * hMem)
{
  int wBytesRead;
  char *ErrString = "Unable to read metafile bits";

  _llseek(fh, sizeof(ALDUSMFHEADER), 0);
  wBytesRead = _lread(fh, lpMem, (WORD)(mfHeader.mtSize * 2));

  if( wBytesRead == -1 )
  {
    MessageBox(hwnd, ErrString, NULL, MB_OK | MB_ICONHAND);
    GlobalUnlock(*hMem);
    GlobalFree(*hMem);
    return FALSE;
  }
  return TRUE;
}

//////////////////////////////////////
// RenderMeta
//////////////////////////////////////
BOOL RenderPlaceableMeta(HWND hwnd, HFILE fh)
{
  LPSTR    lpMem;
  HANDLE   hMem;

  if ((bMetaInRam) && (hmf))
    DeleteMetaFile(hmf);
  _llseek(fh, 0, 0);

  if (!ReadPlaceableHeader(hwnd, fh)) return FALSE;
  if (!ReadHeader(&mfHeader, hwnd, fh)) return FALSE;
  if (!(hMem = AllocMetaMemory(hwnd, &mfHeader))) return FALSE;
  lpMem = (LPSTR)GlobalLock(hMem);
  if(!ReadMetafileBits(hwnd, fh, mfHeader, lpMem, &hMem))
    return FALSE;
  if (!(hmf = SetMetaFileBits(hMem))) return(FALSE);
  GlobalUnlock(hMem);
  return(TRUE);
}

//////////////////////////////////////
// OpenMetaFile
//////////////////////////////////////
BOOL OpenMetaFile(HWND hwnd, char * lpFileName)
{
    HFILE fh;
    int wBytesRead;
    LONG dwIsAldus;

    fh = _lopen(lpFileName, OF_READ);

    if (fh != -1)
    {
      // See if it is a placeable wmf
      wBytesRead =
         _lread(fh,(LPSTR)&dwIsAldus, sizeof(dwIsAldus));
      if (wBytesRead == -1 || wBytesRead < sizeof(dwIsAldus))
      {
        _lclose(fh);
        MessageBox(hwnd, "unable to read file", NULL,
                   MB_OK | MB_ICONEXCLAMATION);
        return (FALSE);
      }

      if (dwIsAldus != ALDUSKEY)
      {
        IsAldus = FALSE;
        hmf = GetMetaFile(lpFileName);
      }
      else
      {
        IsAldus = TRUE;
        RenderPlaceableMeta(hwnd, fh);
      }
      _lclose(fh);
    }
    return TRUE;
}

//////////////////////////////////////
// GetFileName
//////////////////////////////////////
char * GetFileName(HWND hwnd, char * szFile, int StringSize)
{
  OPENFILENAME ofn;
  char szDirName[256];
  char szFileTitle[256];
  char szFilter[256];

  memset(&ofn, 0, sizeof(OPENFILENAME));
  strcpy(szFilter, "Metafiles");
  strcpy(&szFilter[strlen(szFilter) + 1], "*.wmf");

  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = szFilter;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile= szFile;
  ofn.nMaxFile = StringSize;
  ofn.lpstrFileTitle = szFileTitle;
  ofn.nMaxFileTitle = sizeof(szFileTitle);
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_FILEMUSTEXIST;

  GetOpenFileName(&ofn);

  return szFile;
}

//////////////////////////////////////
// LoadFile
//////////////////////////////////////
void LoadFile(HWND hwnd)
{
  char S[100];
  bMetaInRam = TRUE;
  memset(&S, 0, 100);

  GetFileName(hwnd, S, 100);

  OpenMetaFile(hwnd, S);

  if (!hmf)
    MessageBox(hwnd, "No Meta", "sdf", MB_OK);

  InvalidateRect(hwnd, NULL, TRUE);

}

//////////////////////////////////////
// GetSaveName;
//////////////////////////////////////
char *GetSaveName(HWND hwnd, char * SaveName)
{
  OPENFILENAME ofn;
  char szDirName[256];
  char szFile[256], szFileTitle[256];
  UINT  i;
  char  chReplace;
  char  szFilter[256];

  _getdcwd(0, szDirName, 255);

  strcpy(szFilter,
         "Metafiles(*.wmf)|*.wmf|Bitmap Files(*.bmp)|*.bmp|");
  chReplace = szFilter[strlen(szFilter) - 1];
  for (i = 0; szFilter[i] != '\0'; i++)
  {
      if (szFilter[i] == chReplace)
         szFilter[i] = '\0';
  }

  /* Set all structure members to zero. */

  memset(&ofn, 0, sizeof(OPENFILENAME));

  /* Initialize the OPENFILENAME members. */

  szFile[0] = '\0';

  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = szFilter;
  ofn.lpstrFile= szFile;
  ofn.nMaxFile = sizeof(szFile);
  ofn.lpstrFileTitle = szFileTitle;
  ofn.nMaxFileTitle = sizeof(szFileTitle);
  ofn.lpstrInitialDir = szDirName;

  ofn.Flags = OFN_OVERWRITEPROMPT;

  if (GetSaveFileName(&ofn))
    strcpy(SaveName, ofn.lpstrFile);
  else
    strcpy(SaveName, "");

  return SaveName;
}

int FileExists(const char *path)
{
  FILE *f = fopen(path, "r");
  if (!f)
    return FALSE;
  else
  {
    fclose(f);
    return TRUE;
  }
}

void SaveFile(HWND hwnd, char * OldName)
{
  char Name[256];
  int i;

  GetSaveName(hwnd, Name);

  if (strlen(Name) == 0) return;

  if (FileExists(Name))
  {
    i = remove(Name);
    if (i != 0)
      MessageBox(hwnd, "Error deleting", "No", MB_OK);
  }

  i = rename(OldName, Name);
  if (i != 0)
    MessageBox(hwnd, "Error renaming", "No", MB_OK);

  OpenMetaFile(hwnd, Name);
}

void TurnOffSave(HWND hwnd)
{
  HMENU hMenu = GetMenu(hwnd);
  EnableMenuItem(hMenu, CM_ENDMETA, MF_BYCOMMAND | MF_GRAYED);
}
