//////////////////////////////////////
// Module Name: GRUNT.H
// Programmer: Charlie Calvert
// Description: Do the work of moving the snake
//////////////////////////////////////
#include <windows.h>
#include <windowsx.h>

#define BORDERSIZE 15
#define MAXSECTIONS 1024
#define MAXPRIZES 512

// Type definitions
enum TDir {Left, Right, Up, Down};

struct TSectInfo
{
  BOOL DirChange;
  TDir Dir, OldDir;
  int SecNum;
  int Row, Col;
  int OldRow, OldCol;
};

struct TTurn
{
  TDir Dir;
  BOOL SectChangeDir[256];
  int TurnCol, TurnRow;
};

struct TPrize
{
  BOOL Exists;
  int Value;
  int Col, Row;
};


// Class Game
#define Game_DefProc    DefWindowProc
BOOL Game_OnCreate(HWND hWindow,
                    CREATESTRUCT FAR* lpCreateStruct);
void Game_OnDestroy(HWND hWindow);
void Game_OnChar(HWND hWindow, UINT ch, int cRepeat);
void Game_OnKey(HWND hWindow, UINT vk,
                 BOOL fDown, int cRepeat, UINT flags);
void Game_OnPaint(HWND hWindow);
void Game_OnTimer(HWND hWindow, UINT id);

// Procs
LRESULT CALLBACK __export GameWndProc(HWND, UINT,
                                      WPARAM, LPARAM);
void InitializeSections();
void GetOldDir(TDir NewDir);
void MoveBitmap(HWND hWindow);
void SetSections(void);
void SetPrizes(void);
