//////////////////////////////////////
// Module: GRUNT.CPP
// Project: Snake
// Programmer: Charlie Calvert
// Date: May 29, 1993
// Description: Do the real work of moving the snake.
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <stdlib.h>
#include <string.h>
#include "grunt.h"
#include "snako.h"
#include "score.h"
#include "snakutil.h"
#include "snakopnt.h"
#pragma warning (disable : 4100)

extern TSNAKEMAP SMap;
extern HWND hScoreWindow;
extern PGAMEINFO G;

int FindSafe(HWND hwnd)
{
  int Result;

  KillTimer(hwnd, SNAKETIMER);
  if ((G->ScoreRep.Level != 1) || (G->ScoreRep.ScreenNum != 1))
  {
     Result = MessageBox(hwnd,
       "Yes to try this level again, no to start over.",
       "Snako by Charlie Calvert!", MB_YESNO | MB_ICONSTOP);
  }
  else
  {
    Result = MessageBox(hwnd, "Dead Snake!",
           "Snako by Charlie Calvert!", MB_OK | MB_ICONSTOP);
  }
  if ((Result == IDOK) || (Result == IDNO))
  SendMessage(hScoreWindow, WM_SCORE, 0,
              (LPARAM)G->ScoreRep.TotalScore);
  if (Result != IDYES)
  {
    DoSnakePainting(hwnd);
    memset(&G->SectInfo, '\0', sizeof(G->SectInfo));
    memset(&G->ScoreRep, '\0', sizeof(TSCOREREP));
    G->ScoreRep.Level = 1;
  }
  else
    G->Dat.NewScreenStarted = 2;
  return FALSE;
}

//////////////////////////////////////
// Will the snake hit its own body if it
// goes in the direction user asked for?
//////////////////////////////////////
BOOL DidSnakeHitSnake(HWND hwnd)
{
  int C = G->SectInfo[0].Col;
  int R = G->SectInfo[0].Row;

  for (int i = 1; i <= G->Dat.Sections; i++)
    if ((C == G->SectInfo[i].Col) && (R == G->SectInfo[i].Row))
    {
      FindSafe(hwnd);
      return TRUE;
    }

  return FALSE;
}

//////////////////////////////////////
// This only gets called for the head.
// It tests if head is going to hit the
// body of the snake or if it hits the grass
// In either case it returns FALSE, else TRUE
//////////////////////////////////////
BOOL FindNextSpace(HWND hwnd)
{
  int Test;

  switch(G->SectInfo[0].Dir)
  {
    case UP:
      if (G->SectInfo[0].Row <= 0)
        return FindSafe(hwnd);
      Test = G->Map[G->SectInfo[0].Row - 1][G->SectInfo[0].Col];
      if ((Test == GRASSMAP) || (G->SectInfo[0].Row <= 0))
        return FindSafe(hwnd);
      G->SectInfo[0].Row -= 1;
      break;

    case DOWN:
      Test = G->Map[G->SectInfo[0].Row + 1][G->SectInfo[0].Col];
      if ((Test == GRASSMAP) || (G->SectInfo[0].Row >= MAXY - 1))
        return FindSafe(hwnd);
      G->SectInfo[0].Row += 1;
      break;

    case LEFT:
      Test = G->Map[G->SectInfo[0].Row][G->SectInfo[0].Col - 1];
      if ((Test == GRASSMAP) || (G->SectInfo[0].Col < 1))
        return FindSafe(hwnd);
      G->SectInfo[0].Col -= 1;
      break;

    case RIGHT:
      Test = G->Map[G->SectInfo[0].Row][G->SectInfo[0].Col + 1];
      if ((Test == GRASSMAP) || (G->SectInfo[0].Col > MAXX))
        return FindSafe(hwnd);
      G->SectInfo[0].Col += 1;
      break;
  }

  if (Test == PRIZEMAP)
  {
    G->ScoreRep.TotalScore += (LONG)100;
    G->ScoreRep.NumPrizes--;
  }

  G->Map[G->SectInfo[0].Row][G->SectInfo[0].Col] = ROADMAP;

  if(DidSnakeHitSnake(hwnd))
    return FALSE;
  else
    return TRUE;
}

//////////////////////////////////////
// This moves each section of the
// snake on one place. It never
// gets called for the head.
//////////////////////////////////////
void SetNextSection(int i)
{
  switch(G->SectInfo[i].Dir)
  {
    case UP: G->SectInfo[i].Row -= 1; break;
    case DOWN: G->SectInfo[i].Row += 1; break;
    case LEFT: G->SectInfo[i].Col -= 1; break;
    case RIGHT: G->SectInfo[i].Col += 1; break;
  }
}

//////////////////////////////////////
// When ever the snake moves back and forth
// across a screen, we need to know which
// number screen he is on so we can tell the user
//////////////////////////////////////
void SetScreenNum(void)
{
  switch (G->Dat.MaxCols)
  {
    case JUMPSPACE: G->ScoreRep.ScreenNum = 1; break;
    case JUMPSPACE * 2: G->ScoreRep.ScreenNum = 2; break;
    case JUMPSPACE * 3: G->ScoreRep.ScreenNum = 3; break;
    case JUMPSPACE * 4: G->ScoreRep.ScreenNum = 4; break;
  }
}

//////////////////////////////////////
// Move things left one screen or
// right one screen if we hit end of screen
//////////////////////////////////////
void CheckForEndScreen(HWND hwnd, int i)
{
  if ((i == 0) && (G->SectInfo[i].Col >= G->Dat.MaxCols))
  {
    if (G->Dat.XPos != (MAXX - JUMPSPACE))
    {
      G->Dat.XPos += JUMPSPACE;
      G->Dat.MaxCols += JUMPSPACE;
      G->Dat.MinCols += JUMPSPACE;
      G->ScoreRep.NumPrizes = 10000;
      InvalidateRect(hwnd, NULL, TRUE);
      SetScreenNum();
      G->Dat.NewScreenStarted = TRUE;
    }
  }

  if ((i == 0) && (G->SectInfo[i].Col < G->Dat.MinCols))
  {
    if (G->Dat.XPos != 0)
    {
      G->Dat.XPos -= JUMPSPACE;
      G->Dat.MaxCols -= JUMPSPACE;
      G->Dat.MinCols -= JUMPSPACE;
      G->ScoreRep.NumPrizes = 10000;
      InvalidateRect(hwnd, NULL, TRUE);
      SetScreenNum();
    }
  }
}

//////////////////////////////////////
// Move the whole snake forward. The calls to
// FindNextSpace move the head and test to see
// if move is legal. Once we know the move is legal,
// then move everything else by calling SetNextSection.
// CheckForEndScreen moves to next screen or back
//////////////////////////////////////
void SetColRow(HWND hwnd)
{
  int i;
  BOOL Result;

  for (i = 0; i <= G->Dat.Sections; i++)
  {
    G->SectInfo[i].OldCol = G->SectInfo[i].Col;
    G->SectInfo[i].OldRow = G->SectInfo[i].Row;

    if (i == 0)
    {
      Result = FindNextSpace(hwnd);
      if(G->Dat.NewScreenStarted == 2)
        return;
    }
    else
      SetNextSection(i);

    if (Result)
      CheckForEndScreen(hwnd, i);
  }

  if (Result)
    for (i = G->Dat.Sections; i > 0; i--)
    {
      if (G->SectInfo[i - 1].DirChange)
      {
        G->SectInfo[i].DirChange = TRUE;
        G->SectInfo[i].Dir = G->SectInfo[i - 1].Dir;
        G->SectInfo[i - 1].DirChange = FALSE;
      }
    }
}

//////////////////////////////////////
// Set New Direction when we turn
//////////////////////////////////////
void SetNewDir(int NewDir)
{
  G->SectInfo[0].Dir = NewDir;
  G->SectInfo[0].DirChange = TRUE;
}

//////////////////////////////////////
// Make the snake a little longer
//////////////////////////////////////
void AddSection(void)
{
  G->Dat.Sections++;

  G->SectInfo[G->Dat.Sections].Dir =
     G->SectInfo[G->Dat.Sections - 1].Dir;
  G->SectInfo[G->Dat.Sections].DirChange = FALSE;

  switch (G->SectInfo[G->Dat.Sections].Dir)
  {
    case LEFT:
    {
      G->SectInfo[G->Dat.Sections].Col =
        G->SectInfo[G->Dat.Sections - 1].Col + 1;
      G->SectInfo[G->Dat.Sections].Row =
        G->SectInfo[G->Dat.Sections - 1].Row;
      break;
    }
    case RIGHT:
    {
      G->SectInfo[G->Dat.Sections].Col =
        G->SectInfo[G->Dat.Sections - 1].Col - 1;
      G->SectInfo[G->Dat.Sections].Row =
        G->SectInfo[G->Dat.Sections - 1].Row;
      break;
    }

    case UP:
    {
      G->SectInfo[G->Dat.Sections].Col =
        G->SectInfo[G->Dat.Sections - 1].Col;
      G->SectInfo[G->Dat.Sections].Row =
        G->SectInfo[G->Dat.Sections - 1].Row + 1;
      break;
    }

    case DOWN:
    {
      G->SectInfo[G->Dat.Sections].Col =
        G->SectInfo[G->Dat.Sections - 1].Col;
      G->SectInfo[G->Dat.Sections].Row =
        G->SectInfo[G->Dat.Sections - 1].Row - 1;
      break;
    }
  } // end switch

  G->SectInfo[G->Dat.Sections].OldCol =
    G->SectInfo[G->Dat.Sections - 1].Col;
  G->SectInfo[G->Dat.Sections].OldRow =
    G->SectInfo[G->Dat.Sections - 1].Row;
}


//////////////////////////////////////
// Game is over
//////////////////////////////////////
void YouWin(HWND hwnd)
{
  KillTimer(hwnd, SNAKETIMER);
  MessageBox(hwnd, "You Win!", "Victory!",
             MB_ICONEXCLAMATION | MB_OK);
  SendMessage(hScoreWindow, WM_SCORE, 0,
             (LPARAM)G->ScoreRep.TotalScore);
}

//////////////////////////////////////
// Make a bridge to the next screen,
// start the next level or proclaim victory.
//////////////////////////////////////
void MakeGateWay(HWND hwnd)
{
  if (G->ScoreRep.ScreenNum == 4)
  {
    if (G->ScoreRep.Level == 2)
    {
      YouWin(hwnd);
      return;
    }
    G->ScoreRep.Level++;
    StartNewScreen(hwnd);
    KillTimer(hwnd, SNAKETIMER);
    MessageBox(hwnd, "Get Ready for a new Level", "Snako",
               MB_OK | MB_ICONEXCLAMATION);
    if (!SetTimer(hwnd, SNAKETIMER, G->Dat.Speed, NULL))
      MessageBox(hwnd,"No Timers Available","Snako",MB_OK);

    SaveGameToMemory(hwnd);
    return;
  }
  MakeAndPaintBridge(hwnd);
}

//////////////////////////////////////
// Command Central for the whole of Grunt
//////////////////////////////////////
void MoveBitMap(HWND hwnd)
{
  SetColRow(hwnd);
  if (G->Dat.NewScreenStarted == 2)
  {
    ReadGameFromMemory();
    G->Dat.NewScreenStarted = 2;
  }
  DoSnakePainting(hwnd);
  G->ScoreRep.TotalScore += 1;
  G->SectInfo[0].DirChange = FALSE;
  if (G->Dat.NewScreenStarted == 1)
  {
    G->Dat.NewScreenStarted = FALSE;
    SaveGameToMemory(hwnd);
  }
}
